/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import com.google.android.gms.common.api.BatchResult;
import com.google.android.gms.common.api.BatchResultToken;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzqe;
import java.util.ArrayList;
import java.util.List;

public final class Batch
extends zzqe<BatchResult> {
    private int vo;
    private boolean vp;
    private boolean vq;
    private final PendingResult<?>[] vr;
    private final Object zzakd = new Object();

    private Batch(List<PendingResult<?>> list, GoogleApiClient googleApiClient) {
        super(googleApiClient);
        this.vo = list.size();
        this.vr = new PendingResult[this.vo];
        if (list.isEmpty()) {
            this.zzc(new BatchResult(Status.vY, this.vr));
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            PendingResult<?> pendingResult = list.get(i);
            this.vr[i] = pendingResult;
            pendingResult.zza(new PendingResult.zza(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void zzv(Status status) {
                    Object object = Batch.this.zzakd;
                    synchronized (object) {
                        if (Batch.this.isCanceled()) {
                            return;
                        }
                        if (status.isCanceled()) {
                            Batch.this.vq = true;
                        } else if (!status.isSuccess()) {
                            Batch.this.vp = true;
                        }
                        Batch.this.vo--;
                        if (Batch.this.vo == 0) {
                            if (Batch.this.vq) {
                                Batch.super.cancel();
                            } else {
                                Status status2 = Batch.this.vp ? new Status(13) : Status.vY;
                                Batch.this.zzc(new BatchResult(status2, Batch.this.vr));
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        for (PendingResult<?> pendingResult : this.vr) {
            pendingResult.cancel();
        }
    }

    public BatchResult createFailedResult(Status status) {
        return new BatchResult(status, this.vr);
    }

    @Override
    public /* synthetic */ Result zzc(Status status) {
        return this.createFailedResult(status);
    }

    public static final class Builder {
        private List<PendingResult<?>> vt = new ArrayList();
        private GoogleApiClient kv;

        public Builder(GoogleApiClient googleApiClient) {
            this.kv = googleApiClient;
        }

        public <R extends Result> BatchResultToken<R> add(PendingResult<R> pendingResult) {
            BatchResultToken batchResultToken = new BatchResultToken(this.vt.size());
            this.vt.add(pendingResult);
            return batchResultToken;
        }

        public Batch build() {
            return new Batch(this.vt, this.kv);
        }
    }
}

