/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.zzb;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new zzb();
    private final int mVersionCode;
    private final Uri AC;
    private final int zzajw;
    private final int zzajx;

    WebImage(int n, Uri uri, int n2, int n3) {
        this.mVersionCode = n;
        this.AC = uri;
        this.zzajw = n2;
        this.zzajx = n3;
    }

    public WebImage(Uri uri, int n, int n2) throws IllegalArgumentException {
        this(1, uri, n, n2);
        if (uri == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    public WebImage(JSONObject jSONObject) throws IllegalArgumentException {
        this(WebImage.zzq(jSONObject), jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    private static Uri zzq(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return uri;
    }

    public Uri getUrl() {
        return this.AC;
    }

    public int getWidth() {
        return this.zzajw;
    }

    public int getHeight() {
        return this.zzajx;
    }

    public String toString() {
        return String.format(Locale.US, "Image %dx%d %s", this.zzajw, this.zzajx, this.AC.toString());
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.AC.toString());
            jSONObject.put("width", this.zzajw);
            jSONObject.put("height", this.zzajx);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)((Object)object);
        return zzab.equal((Object)this.AC, (Object)webImage.AC) && this.zzajw == webImage.zzajw && this.zzajx == webImage.zzajx;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.AC, this.zzajw, this.zzajx});
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }
}

