/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqr;
import com.google.android.gms.internal.zzqy;
import com.google.android.gms.internal.zzrl;
import com.google.android.gms.internal.zzwz;
import com.google.android.gms.internal.zzxa;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzqh
implements zzqy {
    private final Context mContext;
    private final zzqp wV;
    private final Looper zzajn;
    private final zzqr wW;
    private final zzqr wX;
    private final Map<Api.zzc<?>, zzqr> wY;
    private final Set<zzrl> wZ = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze xa;
    private Bundle xb;
    private ConnectionResult xc = null;
    private ConnectionResult xd = null;
    private boolean xe = false;
    private final Lock xf;
    private int xg = 0;

    public static zzqh zza(Context context, zzqp zzqp2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, zzh zzh2, Map<Api<?>, Integer> map2, Api.zza<? extends zzwz, zzxa> zza2, ArrayList<zzqf> arrayList) {
        Object object;
        Api.zze zze2 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzahs()) {
                zze2 = object;
            }
            if (object.zzahd()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzac.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc3 = api.zzapp();
            if (arrayMap2.containsKey(zzc3)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc3)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the apiTypeMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzqf>();
        ArrayList<zzqf> arrayList2 = new ArrayList<zzqf>();
        for (zzqf zzqf2 : arrayList) {
            if (arrayMap5.containsKey(zzqf2.tv)) {
                ((ArrayList)object).add(zzqf2);
                continue;
            }
            if (arrayMap.containsKey(zzqf2.tv)) {
                arrayList2.add(zzqf2);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the apiTypeMap");
        }
        return new zzqh(context, zzqp2, lock, looper, zzc2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzh2, zza2, zze2, (ArrayList<zzqf>)object, arrayList2, (Map<Api<?>, Integer>)arrayMap5, (Map<Api<?>, Integer>)arrayMap);
    }

    private zzqh(Context context, zzqp zzqp2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzh zzh2, Api.zza<? extends zzwz, zzxa> zza2, Api.zze zze2, ArrayList<zzqf> arrayList, ArrayList<zzqf> arrayList2, Map<Api<?>, Integer> map3, Map<Api<?>, Integer> map4) {
        this.mContext = context;
        this.wV = zzqp2;
        this.xf = lock;
        this.zzajn = looper;
        this.xa = zze2;
        this.wW = new zzqr(context, this.wV, lock, looper, zzc2, map2, null, map4, null, arrayList2, new zza());
        this.wX = new zzqr(context, this.wV, lock, looper, zzc2, map, zzh2, map3, zza2, arrayList, new zzb());
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc3 : map2.keySet()) {
            arrayMap.put(zzc3, (Object)this.wW);
        }
        for (Api.zzc<?> zzc3 : map.keySet()) {
            arrayMap.put(zzc3, (Object)this.wX);
        }
        this.wY = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzqc.zza<R, A>> T zzc(@NonNull T t) {
        if (this.zze(t)) {
            if (this.zzare()) {
                t.zzz(new Status(4, null, this.zzarf()));
                return t;
            }
            return this.wX.zzc(t);
        }
        return this.wW.zzc(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzqc.zza<? extends Result, A>> T zzd(@NonNull T t) {
        if (this.zze(t)) {
            if (this.zzare()) {
                t.zzz(new Status(4, null, this.zzarf()));
                return t;
            }
            return this.wX.zzd(t);
        }
        return this.wW.zzd(t);
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.wY.get(api.zzapp()).equals(this.wX)) {
            if (this.zzare()) {
                return new ConnectionResult(4, this.zzarf());
            }
            return this.wX.getConnectionResult(api);
        }
        return this.wW.getConnectionResult(api);
    }

    @Override
    public void connect() {
        this.xg = 2;
        this.xe = false;
        this.zzara();
    }

    @Override
    public ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disconnect() {
        this.xd = null;
        this.xc = null;
        this.xg = 0;
        this.wW.disconnect();
        this.wX.disconnect();
        this.zzard();
    }

    @Override
    public boolean isConnected() {
        this.xf.lock();
        try {
            boolean bl = this.wW.isConnected() && (this.zzaqz() || this.zzare() || this.xg == 1);
            return bl;
        }
        finally {
            this.xf.unlock();
        }
    }

    @Override
    public boolean isConnecting() {
        this.xf.lock();
        try {
            boolean bl = this.xg == 2;
            return bl;
        }
        finally {
            this.xf.unlock();
        }
    }

    @Override
    public boolean zza(zzrl zzrl2) {
        this.xf.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzaqz()) {
                this.wZ.add(zzrl2);
                if (this.xg == 0) {
                    this.xg = 1;
                }
                this.xd = null;
                this.wX.connect();
                boolean bl = true;
                return true;
            }
        }
        finally {
            this.xf.unlock();
        }
        return false;
    }

    @Override
    public void zzaqy() {
        this.wW.zzaqy();
        this.wX.zzaqy();
    }

    @Override
    public void zzaqb() {
        this.xf.lock();
        try {
            boolean bl = this.isConnecting();
            this.wX.disconnect();
            this.xd = new ConnectionResult(4);
            if (bl) {
                Handler handler = new Handler(this.zzajn);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        zzqh.this.xf.lock();
                        try {
                            zzqh.this.zzarb();
                        }
                        finally {
                            zzqh.this.xf.unlock();
                        }
                    }
                });
            } else {
                this.zzard();
            }
        }
        finally {
            this.xf.unlock();
        }
    }

    public boolean zzaqz() {
        return this.wX.isConnected();
    }

    private void zzara() {
        this.xd = null;
        this.xc = null;
        this.wW.connect();
        this.wX.connect();
    }

    private void zzarb() {
        if (zzqh.zzc(this.xc)) {
            if (zzqh.zzc(this.xd) || this.zzare()) {
                this.zzarc();
            } else if (this.xd != null) {
                if (this.xg == 1) {
                    this.zzard();
                } else {
                    this.zzb(this.xd);
                    this.wW.disconnect();
                }
            }
        } else if (this.xc != null && zzqh.zzc(this.xd)) {
            this.wX.disconnect();
            this.zzb(this.xc);
        } else if (this.xc != null && this.xd != null) {
            ConnectionResult connectionResult = this.xc;
            if (this.wX.yo < this.wW.yo) {
                connectionResult = this.xd;
            }
            this.zzb(connectionResult);
        }
    }

    private void zzarc() {
        switch (this.xg) {
            case 2: {
                this.wV.zzn(this.xb);
            }
            case 1: {
                this.zzard();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
            }
        }
        this.xg = 0;
    }

    private void zzb(ConnectionResult connectionResult) {
        switch (this.xg) {
            case 2: {
                this.wV.zzd(connectionResult);
            }
            case 1: {
                this.zzard();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.xg = 0;
    }

    private void zzard() {
        for (zzrl zzrl2 : this.wZ) {
            zzrl2.zzahr();
        }
        this.wZ.clear();
    }

    private void zzb(int n, boolean bl) {
        this.wV.zzc(n, bl);
        this.xd = null;
        this.xc = null;
    }

    private boolean zzare() {
        return this.xd != null && this.xd.getErrorCode() == 4;
    }

    private boolean zze(zzqc.zza<? extends Result, ? extends Api.zzb> zza2) {
        Api.zzc<? extends Api.zzb> zzc2 = zza2.zzapp();
        zzac.zzb((boolean)this.wY.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.wY.get(zzc2).equals(this.wX);
    }

    @Nullable
    private PendingIntent zzarf() {
        if (this.xa == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.wV.getSessionId(), (Intent)this.xa.zzaht(), (int)0x8000000);
    }

    private void zzm(Bundle bundle) {
        if (this.xb == null) {
            this.xb = bundle;
        } else if (bundle != null) {
            this.xb.putAll(bundle);
        }
    }

    private static boolean zzc(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.wX.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.wW.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    private class zzb
    implements zzqy.zza {
        private zzb() {
        }

        @Override
        public void zzn(@Nullable Bundle bundle) {
            zzqh.this.xf.lock();
            try {
                zzqh.this.xd = ConnectionResult.uJ;
                zzqh.this.zzarb();
            }
            finally {
                zzqh.this.xf.unlock();
            }
        }

        @Override
        public void zzd(@NonNull ConnectionResult connectionResult) {
            zzqh.this.xf.lock();
            try {
                zzqh.this.xd = connectionResult;
                zzqh.this.zzarb();
            }
            finally {
                zzqh.this.xf.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zzqh.this.xf.lock();
            try {
                if (zzqh.this.xe) {
                    zzqh.this.xe = false;
                    zzqh.this.zzb(n, bl);
                    return;
                }
                zzqh.this.xe = true;
                zzqh.this.wW.onConnectionSuspended(n);
            }
            finally {
                zzqh.this.xf.unlock();
            }
        }
    }

    private class zza
    implements zzqy.zza {
        private zza() {
        }

        @Override
        public void zzn(@Nullable Bundle bundle) {
            zzqh.this.xf.lock();
            try {
                zzqh.this.zzm(bundle);
                zzqh.this.xc = ConnectionResult.uJ;
                zzqh.this.zzarb();
            }
            finally {
                zzqh.this.xf.unlock();
            }
        }

        @Override
        public void zzd(@NonNull ConnectionResult connectionResult) {
            zzqh.this.xf.lock();
            try {
                zzqh.this.xc = connectionResult;
                zzqh.this.zzarb();
            }
            finally {
                zzqh.this.xf.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zzqh.this.xf.lock();
            try {
                if (zzqh.this.xe || zzqh.this.xd == null || !zzqh.this.xd.isSuccess()) {
                    zzqh.this.xe = false;
                    zzqh.this.zzb(n, bl);
                    return;
                }
                zzqh.this.xe = true;
                zzqh.this.wX.onConnectionSuspended(n);
            }
            finally {
                zzqh.this.xf.unlock();
            }
        }
    }
}

