/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.BinderThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zzqr;
import com.google.android.gms.internal.zzqs;
import com.google.android.gms.internal.zzwz;
import com.google.android.gms.internal.zzxa;
import com.google.android.gms.signin.internal.SignInResponse;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

public class zzqn
implements zzqq {
    private final zzqr xk;
    private final Lock xf;
    private final Context mContext;
    private final com.google.android.gms.common.zzc xn;
    private ConnectionResult xo;
    private int xp;
    private int xq = 0;
    private int xr;
    private final Bundle xs = new Bundle();
    private final Set<Api.zzc> xt = new HashSet<Api.zzc>();
    private zzwz xu;
    private int xv;
    private boolean xw;
    private boolean xx;
    private zzr xy;
    private boolean xz;
    private boolean xA;
    private final zzh xB;
    private final Map<Api<?>, Integer> xC;
    private final Api.zza<? extends zzwz, zzxa> vQ;
    private ArrayList<Future<?>> xD = new ArrayList();

    public zzqn(zzqr zzqr2, zzh zzh2, Map<Api<?>, Integer> map, com.google.android.gms.common.zzc zzc2, Api.zza<? extends zzwz, zzxa> zza2, Lock lock, Context context) {
        this.xk = zzqr2;
        this.xB = zzh2;
        this.xC = map;
        this.xn = zzc2;
        this.vQ = zza2;
        this.xf = lock;
        this.mContext = context;
    }

    @Override
    public void begin() {
        this.xk.yl.clear();
        this.xw = false;
        this.xo = null;
        this.xq = 0;
        this.xv = 2;
        this.xx = false;
        this.xz = false;
        boolean bl = false;
        HashMap<Api.zze, zza> hashMap = new HashMap<Api.zze, zza>();
        for (Api<?> api : this.xC.keySet()) {
            Api.zze zze2 = this.xk.xW.get(api.zzapp());
            int n = this.xC.get(api);
            bl |= api.zzapm().getPriority() == 1;
            if (zze2.zzahd()) {
                this.xw = true;
                if (n < this.xv) {
                    this.xv = n;
                }
                if (n != 0) {
                    this.xt.add(api.zzapp());
                }
            }
            hashMap.put(zze2, new zza(this, api, n));
        }
        if (bl) {
            this.xw = false;
        }
        if (this.xw) {
            this.xB.zzc(this.xk.wV.getSessionId());
            zze zze3 = new zze();
            this.xu = this.vQ.zza(this.mContext, this.xk.wV.getLooper(), this.xB, this.xB.zzaum(), zze3, zze3);
        }
        this.xr = this.xk.xW.size();
        this.xD.add(zzqs.zzarz().submit(new zzb(hashMap)));
    }

    private boolean zzarj() {
        --this.xr;
        if (this.xr > 0) {
            return false;
        }
        if (this.xr < 0) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.xk.wV.zzarv());
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zzg(new ConnectionResult(8, null));
            return false;
        }
        if (this.xo != null) {
            this.xk.yo = this.xp;
            this.zzg(this.xo);
            return false;
        }
        return true;
    }

    private void zza(SignInResponse signInResponse) {
        if (!this.zzfr(0)) {
            return;
        }
        ConnectionResult connectionResult = signInResponse.zzave();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = signInResponse.zzcdl();
            ConnectionResult connectionResult2 = resolveAccountResponse.zzave();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zzg(connectionResult2);
                return;
            }
            this.xx = true;
            this.xy = resolveAccountResponse.zzavd();
            this.xz = resolveAccountResponse.zzavf();
            this.xA = resolveAccountResponse.zzavg();
            this.zzark();
        } else if (this.zzf(connectionResult)) {
            this.zzarn();
            this.zzark();
        } else {
            this.zzg(connectionResult);
        }
    }

    private void zzark() {
        if (this.xr != 0) {
            return;
        }
        if (!this.xw || this.xx) {
            this.zzarl();
        }
    }

    private void zzarl() {
        ArrayList<Api.zze> arrayList = new ArrayList<Api.zze>();
        this.xq = 1;
        this.xr = this.xk.xW.size();
        for (Api.zzc<?> zzc2 : this.xk.xW.keySet()) {
            if (this.xk.yl.containsKey(zzc2)) {
                if (!this.zzarj()) continue;
                this.zzarm();
                continue;
            }
            arrayList.add(this.xk.xW.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.xD.add(zzqs.zzarz().submit(new zzc(arrayList)));
        }
    }

    @Override
    public void onConnected(Bundle bundle) {
        if (!this.zzfr(1)) {
            return;
        }
        if (bundle != null) {
            this.xs.putAll(bundle);
        }
        if (this.zzarj()) {
            this.zzarm();
        }
    }

    @Override
    public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
        if (!this.zzfr(1)) {
            return;
        }
        this.zzb(connectionResult, api, n);
        if (this.zzarj()) {
            this.zzarm();
        }
    }

    private void zzarm() {
        this.xk.zzarx();
        zzqs.zzarz().execute(new Runnable(){

            @Override
            public void run() {
                zzqn.this.xn.zzbq(zzqn.this.mContext);
            }
        });
        if (this.xu != null) {
            if (this.xz) {
                this.xu.zza(this.xy, this.xA);
            }
            this.zzbq(false);
        }
        for (Api.zzc<?> zzc2 : this.xk.yl.keySet()) {
            Api.zze zze2 = this.xk.xW.get(zzc2);
            zze2.disconnect();
        }
        Bundle bundle = this.xs.isEmpty() ? null : this.xs;
        this.xk.yp.zzn(bundle);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzqc.zza<R, A>> T zzc(T t) {
        this.xk.wV.xQ.add(t);
        return t;
    }

    @Override
    public <A extends Api.zzb, T extends zzqc.zza<? extends Result, A>> T zzd(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public void connect() {
    }

    @Override
    public boolean disconnect() {
        this.zzaro();
        this.zzbq(true);
        this.xk.zzi(null);
        return true;
    }

    @Override
    public void onConnectionSuspended(int n) {
        this.zzg(new ConnectionResult(8, null));
    }

    private void zzb(ConnectionResult connectionResult, Api<?> api, int n) {
        int n2;
        if (n != 2 && this.zza(n2 = api.zzapm().getPriority(), n, connectionResult)) {
            this.xo = connectionResult;
            this.xp = n2;
        }
        this.xk.yl.put(api.zzapp(), connectionResult);
    }

    private boolean zza(int n, int n2, ConnectionResult connectionResult) {
        if (n2 == 1 && !this.zze(connectionResult)) {
            return false;
        }
        return this.xo == null || n < this.xp;
    }

    private boolean zze(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return true;
        }
        return this.xn.zzfl(connectionResult.getErrorCode()) != null;
    }

    private void zzarn() {
        this.xw = false;
        this.xk.wV.xX = Collections.emptySet();
        for (Api.zzc zzc2 : this.xt) {
            if (this.xk.yl.containsKey(zzc2)) continue;
            this.xk.yl.put(zzc2, new ConnectionResult(17, null));
        }
    }

    private boolean zzf(ConnectionResult connectionResult) {
        return this.xv == 2 || this.xv == 1 && !connectionResult.hasResolution();
    }

    private void zzg(ConnectionResult connectionResult) {
        this.zzaro();
        this.zzbq(!connectionResult.hasResolution());
        this.xk.zzi(connectionResult);
        this.xk.yp.zzd(connectionResult);
    }

    private void zzbq(boolean bl) {
        if (this.xu != null) {
            if (this.xu.isConnected() && bl) {
                this.xu.zzcda();
            }
            this.xu.disconnect();
            this.xy = null;
        }
    }

    private void zzaro() {
        for (Future<?> future : this.xD) {
            future.cancel(true);
        }
        this.xD.clear();
    }

    private Set<Scope> zzarp() {
        if (this.xB == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.xB.zzaug());
        Map<Api<?>, zzh.zza> map = this.xB.zzaui();
        for (Api<?> api : map.keySet()) {
            if (this.xk.yl.containsKey(api.zzapp())) continue;
            hashSet.addAll(map.get(api).hm);
        }
        return hashSet;
    }

    private boolean zzfr(int n) {
        if (this.xq != n) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.xk.wV.zzarv());
            String string2 = String.valueOf(this);
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Unexpected callback in ").append(string2).toString());
            int n2 = this.xr;
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(33).append("mRemainingConnections=").append(n2).toString());
            String string3 = String.valueOf(this.zzfs(this.xq));
            String string4 = String.valueOf(this.zzfs(n));
            Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("GoogleApiClient connecting is in step ").append(string3).append(" but received callback for step ").append(string4).toString(), (Throwable)new Exception());
            this.zzg(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private String zzfs(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    private static class zzd
    extends com.google.android.gms.signin.internal.zzb {
        private final WeakReference<zzqn> xF;

        zzd(zzqn zzqn2) {
            this.xF = new WeakReference<zzqn>(zzqn2);
        }

        @Override
        @BinderThread
        public void zzb(final SignInResponse signInResponse) {
            final zzqn zzqn2 = (zzqn)this.xF.get();
            if (zzqn2 == null) {
                return;
            }
            zzqn2.xk.zza(new zzqr.zza(zzqn2){

                @Override
                public void zzari() {
                    zzqn2.zza(signInResponse);
                }
            });
        }
    }

    private static class zza
    implements zze.zzf {
        private final WeakReference<zzqn> xF;
        private final Api<?> tv;
        private final int wT;

        public zza(zzqn zzqn2, Api<?> api, int n) {
            this.xF = new WeakReference<zzqn>(zzqn2);
            this.tv = api;
            this.wT = n;
        }

        public void zzh(@NonNull ConnectionResult connectionResult) {
            zzqn zzqn2 = (zzqn)this.xF.get();
            if (zzqn2 == null) {
                return;
            }
            zzac.zza((Looper.myLooper() == ((zzqn)zzqn2).xk.wV.getLooper() ? 1 : 0) != 0, (Object)"onReportServiceBinding must be called on the GoogleApiClient handler thread");
            zzqn2.xf.lock();
            try {
                if (!zzqn2.zzfr(0)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzqn2.zzb(connectionResult, this.tv, this.wT);
                }
                if (zzqn2.zzarj()) {
                    zzqn2.zzark();
                }
            }
            finally {
                zzqn2.xf.unlock();
            }
        }
    }

    private class zze
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zze() {
        }

        @Override
        public void onConnected(Bundle bundle) {
            zzqn.this.xu.zza(new zzd(zzqn.this));
        }

        @Override
        public void onConnectionSuspended(int n) {
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzqn.this.xf.lock();
            try {
                if (zzqn.this.zzf(connectionResult)) {
                    zzqn.this.zzarn();
                    zzqn.this.zzark();
                } else {
                    zzqn.this.zzg(connectionResult);
                }
            }
            finally {
                zzqn.this.xf.unlock();
            }
        }
    }

    private class zzc
    extends zzf {
        private final ArrayList<Api.zze> xK;

        public zzc(ArrayList<Api.zze> arrayList) {
            this.xK = arrayList;
        }

        @Override
        @WorkerThread
        public void zzari() {
            ((zzqn)zzqn.this).xk.wV.xX = zzqn.this.zzarp();
            for (Api.zze zze2 : this.xK) {
                zze2.zza(zzqn.this.xy, ((zzqn)zzqn.this).xk.wV.xX);
            }
        }
    }

    private class zzb
    extends zzf {
        private final Map<Api.zze, zza> xG;

        public zzb(Map<Api.zze, zza> map) {
            this.xG = map;
        }

        @Override
        @WorkerThread
        public void zzari() {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            for (Api.zze object : this.xG.keySet()) {
                if (object.zzapr()) {
                    bl2 = true;
                    if (this.xG.get(object).wT != 0) continue;
                    bl = true;
                    break;
                }
                bl3 = false;
            }
            int n2 = n = bl2 ? zzqn.this.xn.isGooglePlayServicesAvailable(zzqn.this.mContext) : 0;
            if (n != 0 && (bl || bl3)) {
                final ConnectionResult connectionResult = new ConnectionResult(n, null);
                zzqn.this.xk.zza(new zzqr.zza(zzqn.this){

                    @Override
                    public void zzari() {
                        zzqn.this.zzg(connectionResult);
                    }
                });
                return;
            }
            if (zzqn.this.xw) {
                zzqn.this.xu.connect();
            }
            for (Api.zze zze2 : this.xG.keySet()) {
                final zze.zzf zzf2 = this.xG.get(zze2);
                if (zze2.zzapr() && n != 0) {
                    zzqn.this.xk.zza(new zzqr.zza(zzqn.this){

                        @Override
                        public void zzari() {
                            zzf2.zzh(new ConnectionResult(16, null));
                        }
                    });
                    continue;
                }
                zze2.zza(zzf2);
            }
        }
    }

    private abstract class zzf
    implements Runnable {
        private zzf() {
        }

        @Override
        @WorkerThread
        public void run() {
            zzqn.this.xf.lock();
            try {
                if (Thread.interrupted()) {
                    return;
                }
                this.zzari();
            }
            catch (RuntimeException runtimeException) {
                zzqn.this.xk.zza(runtimeException);
            }
            finally {
                zzqn.this.xf.unlock();
            }
        }

        @WorkerThread
        protected abstract void zzari();
    }
}

