/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzqg;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzqn;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zzqy;
import com.google.android.gms.internal.zzrl;
import com.google.android.gms.internal.zzwz;
import com.google.android.gms.internal.zzxa;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class zzqr
implements zzqg,
zzqy {
    private final Lock xf;
    private final Condition yj;
    private final Context mContext;
    private final zzc xn;
    private final zzb yk;
    final Map<Api.zzc<?>, Api.zze> xW;
    final Map<Api.zzc<?>, ConnectionResult> yl = new HashMap();
    final zzh xB;
    final Map<Api<?>, Integer> xC;
    final Api.zza<? extends zzwz, zzxa> vQ;
    private volatile zzqq ym;
    private ConnectionResult yn = null;
    int yo;
    final zzqp wV;
    final zzqy.zza yp;

    public zzqr(Context context, zzqp zzqp2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, zzh zzh2, Map<Api<?>, Integer> map2, Api.zza<? extends zzwz, zzxa> zza2, ArrayList<zzqf> arrayList, zzqy.zza zza3) {
        this.mContext = context;
        this.xf = lock;
        this.xn = zzc2;
        this.xW = map;
        this.xB = zzh2;
        this.xC = map2;
        this.vQ = zza2;
        this.wV = zzqp2;
        this.yp = zza3;
        for (zzqf zzqf2 : arrayList) {
            zzqf2.zza(this);
        }
        this.yk = new zzb(looper);
        this.yj = lock.newCondition();
        this.ym = new zzqo(this);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzqc.zza<R, A>> T zzc(@NonNull T t) {
        t.zzaqt();
        return this.ym.zzc(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzqc.zza<? extends Result, A>> T zzd(@NonNull T t) {
        t.zzaqt();
        return this.ym.zzd(t);
    }

    @Override
    public void connect() {
        this.ym.connect();
    }

    @Override
    public ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.yj.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.uJ;
        }
        if (this.yn != null) {
            return this.yn;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.yj.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.uJ;
        }
        if (this.yn != null) {
            return this.yn;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public void disconnect() {
        boolean bl = this.ym.disconnect();
        if (bl) {
            this.yl.clear();
        }
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzapp();
        if (this.xW.containsKey(zzc2)) {
            if (this.xW.get(zzc2).isConnected()) {
                return ConnectionResult.uJ;
            }
            if (this.yl.containsKey(zzc2)) {
                return this.yl.get(zzc2);
            }
        }
        return null;
    }

    void zzarw() {
        this.xf.lock();
        try {
            this.ym = new zzqn(this, this.xB, this.xC, this.xn, this.vQ, this.xf, this.mContext);
            this.ym.begin();
            this.yj.signalAll();
        }
        finally {
            this.xf.unlock();
        }
    }

    void zzarx() {
        this.xf.lock();
        try {
            this.wV.zzart();
            this.ym = new zzqm(this);
            this.ym.begin();
            this.yj.signalAll();
        }
        finally {
            this.xf.unlock();
        }
    }

    void zzi(ConnectionResult connectionResult) {
        this.xf.lock();
        try {
            this.yn = connectionResult;
            this.ym = new zzqo(this);
            this.ym.begin();
            this.yj.signalAll();
        }
        finally {
            this.xf.unlock();
        }
    }

    void zzary() {
        for (Api.zze zze2 : this.xW.values()) {
            zze2.disconnect();
        }
    }

    @Override
    public boolean isConnected() {
        return this.ym instanceof zzqm;
    }

    @Override
    public boolean isConnecting() {
        return this.ym instanceof zzqn;
    }

    @Override
    public boolean zza(zzrl zzrl2) {
        return false;
    }

    @Override
    public void zzaqb() {
    }

    @Override
    public void zzaqy() {
        if (this.isConnected()) {
            ((zzqm)this.ym).zzarh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, int n) {
        this.xf.lock();
        try {
            this.ym.zza(connectionResult, api, n);
        }
        finally {
            this.xf.unlock();
        }
    }

    @Override
    public void onConnected(@Nullable Bundle bundle) {
        this.xf.lock();
        try {
            this.ym.onConnected(bundle);
        }
        finally {
            this.xf.unlock();
        }
    }

    @Override
    public void onConnectionSuspended(int n) {
        this.xf.lock();
        try {
            this.ym.onConnectionSuspended(n);
        }
        finally {
            this.xf.unlock();
        }
    }

    void zza(zza zza2) {
        Message message = this.yk.obtainMessage(1, zza2);
        this.yk.sendMessage(message);
    }

    void zza(RuntimeException runtimeException) {
        Message message = this.yk.obtainMessage(2, runtimeException);
        this.yk.sendMessage(message);
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.ym);
        for (Api<?> api : this.xC.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            Api.zze zze2 = this.xW.get(api.zzapp());
            zze2.dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static abstract class zza {
        private final zzqq yq;

        protected zza(zzqq zzqq2) {
            this.yq = zzqq2;
        }

        public final void zzc(zzqr zzqr2) {
            zzqr2.xf.lock();
            try {
                if (zzqr2.ym != this.yq) {
                    return;
                }
                this.zzari();
            }
            finally {
                zzqr2.xf.unlock();
            }
        }

        protected abstract void zzari();
    }

    final class zzb
    extends Handler {
        zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zza zza2 = (zza)message.obj;
                    zza2.zzc(zzqr.this);
                    break;
                }
                case 2: {
                    throw (RuntimeException)message.obj;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GACStateManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }
}

