/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.internal.zze;
import com.google.android.gms.auth.api.signin.zzb;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends AbstractSafeParcelable
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    public static final Scope jn = new Scope("profile");
    public static final Scope jo = new Scope("email");
    public static final Scope jp = new Scope("openid");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzb();
    final int versionCode;
    private final ArrayList<Scope> jq;
    private Account gj;
    private boolean jr;
    private final boolean js;
    private final boolean jt;
    private String ju;
    private String jv;
    private static Comparator<Scope> jm = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzari().compareTo(scope2.zzari());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Scope)object, (Scope)object2);
        }
    };

    @Nullable
    public static GoogleSignInOptions zzgb(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(hashSet, account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null));
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        this.versionCode = n;
        this.jq = arrayList;
        this.gj = account;
        this.jr = bl;
        this.js = bl2;
        this.jt = bl3;
        this.ju = string2;
        this.jv = string3;
    }

    private GoogleSignInOptions(Set<Scope> set, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        this(2, new ArrayList<Scope>(set), account, bl, bl2, bl3, string2, string3);
    }

    public ArrayList<Scope> zzait() {
        return new ArrayList<Scope>(this.jq);
    }

    public Scope[] getScopeArray() {
        return this.jq.toArray(new Scope[this.jq.size()]);
    }

    public Account getAccount() {
        return this.gj;
    }

    public boolean zzaiu() {
        return this.jr;
    }

    public boolean zzaiv() {
        return this.js;
    }

    public boolean zzaiw() {
        return this.jt;
    }

    public String zzaix() {
        return this.ju;
    }

    public String zzaiy() {
        return this.jv;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.jq.size() != googleSignInOptions.zzait().size() || !this.jq.containsAll(googleSignInOptions.zzait())) {
                return false;
            }
            return (this.gj == null ? googleSignInOptions.getAccount() == null : this.gj.equals((Object)googleSignInOptions.getAccount())) && (TextUtils.isEmpty((CharSequence)this.ju) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzaix()) : this.ju.equals(googleSignInOptions.zzaix())) && this.jt == googleSignInOptions.zzaiw() && this.jr == googleSignInOptions.zzaiu() && this.js == googleSignInOptions.zzaiv();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Scope scope : this.jq) {
            arrayList.add(scope.zzari());
        }
        Collections.sort(arrayList);
        return new zze().zzq(arrayList).zzq(this.gj).zzq(this.ju).zzbe(this.jt).zzbe(this.jr).zzbe(this.js).zzajf();
    }

    public String zzaiq() {
        return this.zzais().toString();
    }

    private JSONObject zzais() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.jq, jm);
            for (Scope scope : this.jq) {
                jSONArray.put((Object)scope.zzari());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.gj != null) {
                jSONObject.put("accountName", (Object)this.gj.name);
            }
            jSONObject.put("idTokenRequested", this.jr);
            jSONObject.put("forceCodeForRefreshToken", this.jt);
            jSONObject.put("serverAuthRequested", this.js);
            if (!TextUtils.isEmpty((CharSequence)this.ju)) {
                jSONObject.put("serverClientId", (Object)this.ju);
            }
            if (!TextUtils.isEmpty((CharSequence)this.jv)) {
                jSONObject.put("hostedDomain", (Object)this.jv);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public static final class Builder {
        private Set<Scope> jw = new HashSet<Scope>();
        private boolean js;
        private boolean jt;
        private boolean jr;
        private String ju;
        private Account gj;
        private String jv;

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzaa.zzy((Object)googleSignInOptions);
            this.jw = new HashSet<Scope>(googleSignInOptions.jq);
            this.js = googleSignInOptions.js;
            this.jt = googleSignInOptions.jt;
            this.jr = googleSignInOptions.jr;
            this.ju = googleSignInOptions.ju;
            this.gj = googleSignInOptions.gj;
            this.jv = googleSignInOptions.jv;
        }

        public Builder requestId() {
            this.jw.add(jp);
            return this;
        }

        public Builder requestEmail() {
            this.jw.add(jo);
            return this;
        }

        public Builder requestProfile() {
            this.jw.add(jn);
            return this;
        }

        public Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.jw.add(scope);
            this.jw.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public Builder requestIdToken(String string2) {
            this.jr = true;
            this.ju = this.zzgc(string2);
            return this;
        }

        public Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public Builder requestServerAuthCode(String string2, boolean bl) {
            this.js = true;
            this.ju = this.zzgc(string2);
            this.jt = bl;
            return this;
        }

        public Builder setAccountName(String string2) {
            this.gj = new Account(zzaa.zzib((String)string2), "com.google");
            return this;
        }

        public Builder setHostedDomain(String string2) {
            this.jv = zzaa.zzib((String)string2);
            return this;
        }

        public GoogleSignInOptions build() {
            if (this.jr && (this.gj == null || !this.jw.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(this.jw, this.gj, this.jr, this.js, this.jt, this.ju, this.jv);
        }

        private String zzgc(String string2) {
            zzaa.zzib((String)string2);
            zzaa.zzb((this.ju == null || this.ju.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

