/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.zzb;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new zzb();
    final int mVersionCode;
    private final Uri sa;
    private final int zzakh;
    private final int zzaki;

    WebImage(int n, Uri uri, int n2, int n3) {
        this.mVersionCode = n;
        this.sa = uri;
        this.zzakh = n2;
        this.zzaki = n3;
    }

    public WebImage(Uri uri, int n, int n2) throws IllegalArgumentException {
        this(1, uri, n, n2);
        if (uri == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    public WebImage(JSONObject jSONObject) throws IllegalArgumentException {
        this(WebImage.zzp(jSONObject), jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    private static Uri zzp(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return uri;
    }

    public Uri getUrl() {
        return this.sa;
    }

    public int getWidth() {
        return this.zzakh;
    }

    public int getHeight() {
        return this.zzaki;
    }

    public String toString() {
        return String.format(Locale.US, "Image %dx%d %s", this.zzakh, this.zzaki, this.sa.toString());
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.sa.toString());
            jSONObject.put("width", this.zzakh);
            jSONObject.put("height", this.zzaki);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)((Object)object);
        return zzz.equal((Object)this.sa, (Object)webImage.sa) && this.zzakh == webImage.zzakh && this.zzaki == webImage.zzaki;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.sa, this.zzakh, this.zzaki});
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }
}

