/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzaa;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzk
implements Handler.Callback {
    private final zza Ee;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> Ef = new ArrayList();
    final ArrayList<GoogleApiClient.ConnectionCallbacks> Eg = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> Eh = new ArrayList();
    private volatile boolean Ei = false;
    private final AtomicInteger Ej = new AtomicInteger(0);
    private boolean Ek = false;
    private final Handler mHandler;
    private final Object zzako = new Object();

    public zzk(Looper looper, zza zza2) {
        this.Ee = zza2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public void zzawc() {
        this.Ei = false;
        this.Ej.incrementAndGet();
    }

    public void zzawd() {
        this.Ei = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzp(Bundle bundle) {
        zzaa.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.zzako;
        synchronized (object) {
            zzaa.zzbs((!this.Ek ? 1 : 0) != 0);
            this.mHandler.removeMessages(1);
            this.Ek = true;
            zzaa.zzbs((this.Eg.size() == 0 ? 1 : 0) != 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.Ef);
            int n = this.Ej.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.Ei || !this.Ee.isConnected() || this.Ej.get() != n) break;
                if (this.Eg.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnected(bundle);
            }
            this.Eg.clear();
            this.Ek = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzgn(int n) {
        zzaa.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzako;
        synchronized (object) {
            this.Ek = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.Ef);
            int n2 = this.Ej.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.Ei || this.Ej.get() != n2) break;
                if (!this.Ef.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            this.Eg.clear();
            this.Ek = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzn(ConnectionResult connectionResult) {
        zzaa.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzako;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.Eh);
            int n = this.Ej.get();
            for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList) {
                if (!this.Ei || this.Ej.get() != n) {
                    return;
                }
                if (!this.Eh.contains(onConnectionFailedListener)) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzaa.zzy((Object)connectionCallbacks);
        Object object = this.zzako;
        synchronized (object) {
            if (this.Ef.contains(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(62 + String.valueOf(string2).length()).append("registerConnectionCallbacks(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.Ef.add(connectionCallbacks);
            }
        }
        if (this.Ee.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)connectionCallbacks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzaa.zzy((Object)connectionCallbacks);
        Object object = this.zzako;
        synchronized (object) {
            return this.Ef.contains(connectionCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzaa.zzy((Object)connectionCallbacks);
        Object object = this.zzako;
        synchronized (object) {
            boolean bl = this.Ef.remove(connectionCallbacks);
            if (!bl) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(52 + String.valueOf(string2).length()).append("unregisterConnectionCallbacks(): listener ").append(string2).append(" not found").toString());
            } else if (this.Ek) {
                this.Eg.add(connectionCallbacks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzaa.zzy((Object)onConnectionFailedListener);
        Object object = this.zzako;
        synchronized (object) {
            if (this.Eh.contains(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(67 + String.valueOf(string2).length()).append("registerConnectionFailedListener(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.Eh.add(onConnectionFailedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzaa.zzy((Object)onConnectionFailedListener);
        Object object = this.zzako;
        synchronized (object) {
            return this.Eh.contains(onConnectionFailedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzaa.zzy((Object)onConnectionFailedListener);
        Object object = this.zzako;
        synchronized (object) {
            boolean bl = this.Eh.remove(onConnectionFailedListener);
            if (!bl) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(57 + String.valueOf(string2).length()).append("unregisterConnectionFailedListener(): listener ").append(string2).append(" not found").toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message message) {
        if (message.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)message.obj;
            Object object = this.zzako;
            synchronized (object) {
                if (this.Ei && this.Ee.isConnected() && this.Ef.contains(connectionCallbacks)) {
                    Bundle bundle = this.Ee.zzapn();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        int n = message.what;
        Log.wtf((String)"GmsClientEvents", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        return false;
    }

    public static interface zza {
        public boolean isConnected();

        public Bundle zzapn();
    }
}

