/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqr;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.internal.zzrf;
import com.google.android.gms.internal.zzrm;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzxp;
import com.google.android.gms.internal.zzxq;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzqt
implements zzrm {
    private final Context mContext;
    private final zzrd yW;
    private final Looper zzajy;
    private final zzrf yX;
    private final zzrf yY;
    private final Map<Api.zzc<?>, zzrf> yZ;
    private final Set<zzsa> za = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zb;
    private Bundle zc;
    private ConnectionResult zd = null;
    private ConnectionResult ze = null;
    private boolean zf = false;
    private final Lock zg;
    private int zh = 0;

    public static zzqt zza(Context context, zzrd zzrd2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, zzf zzf2, Map<Api<?>, Integer> map2, Api.zza<? extends zzxp, zzxq> zza2, ArrayList<zzqr> arrayList) {
        Object object;
        Api.zze zze2 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzajc()) {
                zze2 = object;
            }
            if (object.zzain()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzaa.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc3 = api.zzaqv();
            if (arrayMap2.containsKey(zzc3)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc3)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the apiTypeMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzqr>();
        ArrayList<zzqr> arrayList2 = new ArrayList<zzqr>();
        for (zzqr zzqr2 : arrayList) {
            if (arrayMap5.containsKey(zzqr2.vS)) {
                ((ArrayList)object).add(zzqr2);
                continue;
            }
            if (arrayMap.containsKey(zzqr2.vS)) {
                arrayList2.add(zzqr2);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the apiTypeMap");
        }
        return new zzqt(context, zzrd2, lock, looper, zzc2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzf2, zza2, zze2, (ArrayList<zzqr>)object, arrayList2, (Map<Api<?>, Integer>)arrayMap5, (Map<Api<?>, Integer>)arrayMap);
    }

    private zzqt(Context context, zzrd zzrd2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzf zzf2, Api.zza<? extends zzxp, zzxq> zza2, Api.zze zze2, ArrayList<zzqr> arrayList, ArrayList<zzqr> arrayList2, Map<Api<?>, Integer> map3, Map<Api<?>, Integer> map4) {
        this.mContext = context;
        this.yW = zzrd2;
        this.zg = lock;
        this.zzajy = looper;
        this.zb = zze2;
        this.yX = new zzrf(context, this.yW, lock, looper, zzc2, map2, null, map4, null, arrayList2, new zza());
        this.yY = new zzrf(context, this.yW, lock, looper, zzc2, map, zzf2, map3, zza2, arrayList, new zzb());
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc3 : map2.keySet()) {
            arrayMap.put(zzc3, (Object)this.yX);
        }
        for (Api.zzc<?> zzc3 : map.keySet()) {
            arrayMap.put(zzc3, (Object)this.yY);
        }
        this.yZ = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzqo.zza<R, A>> T zza(@NonNull T t) {
        if (this.zzc(t)) {
            if (this.zzasf()) {
                t.zzaa(new Status(4, null, this.zzasg()));
                return t;
            }
            return this.yY.zza(t);
        }
        return this.yX.zza(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzqo.zza<? extends Result, A>> T zzb(@NonNull T t) {
        if (this.zzc(t)) {
            if (this.zzasf()) {
                t.zzaa(new Status(4, null, this.zzasg()));
                return t;
            }
            return this.yY.zzb(t);
        }
        return this.yX.zzb(t);
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.yZ.get(api.zzaqv()).equals(this.yY)) {
            if (this.zzasf()) {
                return new ConnectionResult(4, this.zzasg());
            }
            return this.yY.getConnectionResult(api);
        }
        return this.yX.getConnectionResult(api);
    }

    @Override
    public void connect() {
        this.zh = 2;
        this.zf = false;
        this.zzasb();
    }

    @Override
    public ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disconnect() {
        this.ze = null;
        this.zd = null;
        this.zh = 0;
        this.yX.disconnect();
        this.yY.disconnect();
        this.zzase();
    }

    @Override
    public boolean isConnected() {
        this.zg.lock();
        try {
            boolean bl = this.yX.isConnected() && (this.zzasa() || this.zzasf() || this.zh == 1);
            return bl;
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public boolean isConnecting() {
        this.zg.lock();
        try {
            boolean bl = this.zh == 2;
            return bl;
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public boolean zza(zzsa zzsa2) {
        this.zg.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzasa()) {
                this.za.add(zzsa2);
                if (this.zh == 0) {
                    this.zh = 1;
                }
                this.ze = null;
                this.yY.connect();
                boolean bl = true;
                return true;
            }
        }
        finally {
            this.zg.unlock();
        }
        return false;
    }

    @Override
    public void zzarz() {
        this.yX.zzarz();
        this.yY.zzarz();
    }

    @Override
    public void zzard() {
        this.zg.lock();
        try {
            boolean bl = this.isConnecting();
            this.yY.disconnect();
            this.ze = new ConnectionResult(4);
            if (bl) {
                Handler handler = new Handler(this.zzajy);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        zzqt.this.zg.lock();
                        try {
                            zzqt.this.zzasc();
                        }
                        finally {
                            zzqt.this.zg.unlock();
                        }
                    }
                });
            } else {
                this.zzase();
            }
        }
        finally {
            this.zg.unlock();
        }
    }

    public boolean zzasa() {
        return this.yY.isConnected();
    }

    private void zzasb() {
        this.ze = null;
        this.zd = null;
        this.yX.connect();
        this.yY.connect();
    }

    private void zzasc() {
        if (zzqt.zzb(this.zd)) {
            if (zzqt.zzb(this.ze) || this.zzasf()) {
                this.zzasd();
            } else if (this.ze != null) {
                if (this.zh == 1) {
                    this.zzase();
                } else {
                    this.zza(this.ze);
                    this.yX.disconnect();
                }
            }
        } else if (this.zd != null && zzqt.zzb(this.ze)) {
            this.yY.disconnect();
            this.zza(this.zd);
        } else if (this.zd != null && this.ze != null) {
            ConnectionResult connectionResult = this.zd;
            if (this.yY.AB < this.yX.AB) {
                connectionResult = this.ze;
            }
            this.zza(connectionResult);
        }
    }

    private void zzasd() {
        switch (this.zh) {
            case 2: {
                this.yW.zzn(this.zc);
            }
            case 1: {
                this.zzase();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
            }
        }
        this.zh = 0;
    }

    private void zza(ConnectionResult connectionResult) {
        switch (this.zh) {
            case 2: {
                this.yW.zzc(connectionResult);
            }
            case 1: {
                this.zzase();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zh = 0;
    }

    private void zzase() {
        for (zzsa zzsa2 : this.za) {
            zzsa2.zzajb();
        }
        this.za.clear();
    }

    private void zzb(int n, boolean bl) {
        this.yW.zzc(n, bl);
        this.ze = null;
        this.zd = null;
    }

    private boolean zzasf() {
        return this.ze != null && this.ze.getErrorCode() == 4;
    }

    private boolean zzc(zzqo.zza<? extends Result, ? extends Api.zzb> zza2) {
        Api.zzc<? extends Api.zzb> zzc2 = zza2.zzaqv();
        zzaa.zzb((boolean)this.yZ.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.yZ.get(zzc2).equals(this.yY);
    }

    @Nullable
    private PendingIntent zzasg() {
        if (this.zb == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.yW.getSessionId(), (Intent)this.zb.zzajd(), (int)0x8000000);
    }

    private void zzm(Bundle bundle) {
        if (this.zc == null) {
            this.zc = bundle;
        } else if (bundle != null) {
            this.zc.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.yY.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.yX.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    private class zzb
    implements zzrm.zza {
        private zzb() {
        }

        @Override
        public void zzn(@Nullable Bundle bundle) {
            zzqt.this.zg.lock();
            try {
                zzqt.this.ze = ConnectionResult.wO;
                zzqt.this.zzasc();
            }
            finally {
                zzqt.this.zg.unlock();
            }
        }

        @Override
        public void zzc(@NonNull ConnectionResult connectionResult) {
            zzqt.this.zg.lock();
            try {
                zzqt.this.ze = connectionResult;
                zzqt.this.zzasc();
            }
            finally {
                zzqt.this.zg.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zzqt.this.zg.lock();
            try {
                if (zzqt.this.zf) {
                    zzqt.this.zf = false;
                    zzqt.this.zzb(n, bl);
                    return;
                }
                zzqt.this.zf = true;
                zzqt.this.yX.onConnectionSuspended(n);
            }
            finally {
                zzqt.this.zg.unlock();
            }
        }
    }

    private class zza
    implements zzrm.zza {
        private zza() {
        }

        @Override
        public void zzn(@Nullable Bundle bundle) {
            zzqt.this.zg.lock();
            try {
                zzqt.this.zzm(bundle);
                zzqt.this.zd = ConnectionResult.wO;
                zzqt.this.zzasc();
            }
            finally {
                zzqt.this.zg.unlock();
            }
        }

        @Override
        public void zzc(@NonNull ConnectionResult connectionResult) {
            zzqt.this.zg.lock();
            try {
                zzqt.this.zd = connectionResult;
                zzqt.this.zzasc();
            }
            finally {
                zzqt.this.zg.unlock();
            }
        }

        @Override
        public void zzc(int n, boolean bl) {
            zzqt.this.zg.lock();
            try {
                if (zzqt.this.zf || zzqt.this.ze == null || !zzqt.this.ze.isSuccess()) {
                    zzqt.this.zf = false;
                    zzqt.this.zzb(n, bl);
                    return;
                }
                zzqt.this.zf = true;
                zzqt.this.yY.onConnectionSuspended(n);
            }
            finally {
                zzqt.this.zg.unlock();
            }
        }
    }
}

