/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zzqr;
import com.google.android.gms.internal.zzqt;
import com.google.android.gms.internal.zzqu;
import com.google.android.gms.internal.zzrf;
import com.google.android.gms.internal.zzrj;
import com.google.android.gms.internal.zzrm;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzrr;
import com.google.android.gms.internal.zzrs;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzsf;
import com.google.android.gms.internal.zzsg;
import com.google.android.gms.internal.zzsn;
import com.google.android.gms.internal.zzxp;
import com.google.android.gms.internal.zzxq;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzrd
extends GoogleApiClient
implements zzrm.zza {
    private final Lock zg;
    private boolean xT;
    private final zzk Ab;
    private zzrm Ac = null;
    private final int xN;
    private final Context mContext;
    private final Looper zzajy;
    final Queue<zzqo.zza<?, ?>> Ad = new LinkedList();
    private volatile boolean Ae;
    private long Af = 120000L;
    private long Ag = 5000L;
    private final zza Ah;
    private final GoogleApiAvailability xP;
    zzrj Ai;
    final Map<Api.zzc<?>, Api.zze> Aj;
    Set<Scope> Ak = new HashSet<Scope>();
    final zzf zP;
    final Map<Api<?>, Integer> zk;
    final Api.zza<? extends zzxp, zzxq> xQ;
    private final zzrs Al = new zzrs();
    private final ArrayList<zzqr> Am;
    private Integer An = null;
    Set<zzsf> Ao = null;
    final zzsg Ap;
    private final zzk.zza Aq = new zzk.zza(){

        @Override
        public boolean isConnected() {
            return zzrd.this.isConnected();
        }

        @Override
        public Bundle zzapn() {
            return null;
        }
    };

    public zzrd(Context context, Lock lock, Looper looper, zzf zzf2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzxp, zzxq> zza2, Map<Api<?>, Integer> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzqr> arrayList, boolean bl) {
        this.mContext = context;
        this.zg = lock;
        this.xT = bl;
        this.Ab = new zzk(looper, this.Aq);
        this.zzajy = looper;
        this.Ah = new zza(looper);
        this.xP = googleApiAvailability;
        this.xN = n;
        if (this.xN >= 0) {
            this.An = n2;
        }
        this.zk = map;
        this.Aj = map2;
        this.Am = arrayList;
        this.Ap = new zzsg(this.Aj);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.Ab.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.Ab.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zP = zzf2;
        this.xQ = zza2;
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzqo.zza<R, A>> T zza(@NonNull T t) {
        zzaa.zzb((t.zzaqv() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.getApi() != null ? t.getApi().getName() : "the API";
        zzaa.zzb((boolean)this.Aj.containsKey(t.zzaqv()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zg.lock();
        try {
            if (this.Ac == null) {
                this.Ad.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.Ac.zza(t);
            return (T)string2;
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public <A extends Api.zzb, T extends zzqo.zza<? extends Result, A>> T zzb(@NonNull T t) {
        zzaa.zzb((t.zzaqv() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.getApi() != null ? t.getApi().getName() : "the API";
        zzaa.zzb((boolean)this.Aj.containsKey(t.zzaqv()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zg.lock();
        try {
            if (this.Ac == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.isResuming()) {
                this.Ad.add(t);
                while (!this.Ad.isEmpty()) {
                    object = this.Ad.remove();
                    this.Ap.zzb((zzqq<? extends Result>)object);
                    ((zzqo.zza)object).zzaa(Status.yb);
                }
                object = t;
                return (T)object;
            }
            object = this.Ac.zzb(t);
            return (T)object;
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public <L> zzrr<L> zzs(@NonNull L l) {
        this.zg.lock();
        try {
            zzrr<L> zzrr2 = this.Al.zzb(l, this.zzajy);
            return zzrr2;
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.Aj.get(zzc2);
        zzaa.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    <C extends Api.zze> C zzb(Api.zzc<?> zzc2) {
        Api.zze zze2 = this.Aj.get(zzc2);
        zzaa.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public boolean zza(@NonNull Api<?> api) {
        return this.Aj.containsKey(api.zzaqv());
    }

    @Override
    public boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!this.isConnected()) {
            return false;
        }
        Api.zze zze2 = this.Aj.get(api.zzaqv());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        this.zg.lock();
        try {
            if (!this.isConnected() && !this.isResuming()) {
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            if (this.Aj.containsKey(api.zzaqv())) {
                ConnectionResult connectionResult = this.Ac.getConnectionResult(api);
                if (connectionResult == null) {
                    if (this.isResuming()) {
                        ConnectionResult connectionResult2 = ConnectionResult.wO;
                        return connectionResult2;
                    }
                    Log.w((String)"GoogleApiClientImpl", (String)this.zzatb());
                    Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                    ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                    return connectionResult3;
                }
                ConnectionResult connectionResult4 = connectionResult;
                return connectionResult4;
            }
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public void connect() {
        this.zg.lock();
        try {
            if (this.xN >= 0) {
                zzaa.zza((this.An != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.An == null) {
                this.An = zzrd.zza(this.Aj.values(), false);
            } else if (this.An == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.connect(this.An);
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public void connect(int n) {
        this.zg.lock();
        try {
            zzaa.zzb((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzfv(n);
            this.zzasw();
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public ConnectionResult blockingConnect() {
        zzaa.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zg.lock();
        try {
            if (this.xN >= 0) {
                zzaa.zza((this.An != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.An == null) {
                this.An = zzrd.zza(this.Aj.values(), false);
            } else if (this.An == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzfv(this.An);
            this.Ab.zzawd();
            ConnectionResult connectionResult = this.Ac.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zg.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzaa.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzaa.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zg.lock();
        try {
            if (this.An == null) {
                this.An = zzrd.zza(this.Aj.values(), false);
            } else if (this.An == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzfv(this.An);
            this.Ab.zzawd();
            ConnectionResult connectionResult = this.Ac.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.zg.lock();
        try {
            this.Ap.release();
            if (this.Ac != null) {
                this.Ac.disconnect();
            }
            this.Al.release();
            for (zzqo.zza zza2 : this.Ad) {
                zza2.zza(null);
                zza2.cancel();
            }
            this.Ad.clear();
            if (this.Ac == null) {
                return;
            }
            this.zzasz();
            this.Ab.zzawc();
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzaa.zza((boolean)this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzaa.zza((this.An != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        final zzsc zzsc2 = new zzsc(this);
        if (this.Aj.containsKey(zzsn.hg)) {
            this.zza(this, zzsc2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle bundle) {
                    zzrd.this.zza((GoogleApiClient)atomicReference.get(), zzsc2, true);
                }

                @Override
                public void onConnectionSuspended(int n) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

                @Override
                public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
                    zzsc2.zzc(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzsn.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.Ah).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzsc2;
    }

    private void zza(final GoogleApiClient googleApiClient, final zzsc zzsc2, final boolean bl) {
        zzsn.EU.zzg(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzp(@NonNull Status status) {
                com.google.android.gms.auth.api.signin.internal.zzk.zzba(zzrd.this.mContext).zzajo();
                if (status.isSuccess() && zzrd.this.isConnected()) {
                    zzrd.this.reconnect();
                }
                zzsc2.zzc(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        });
    }

    @Override
    public void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        this.zzb(new zzrn((Activity)fragmentActivity));
    }

    private void zzb(@NonNull zzrn zzrn2) {
        if (this.xN < 0) {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
        zzqm.zza(zzrn2).zzfs(this.xN);
    }

    @Override
    public boolean isConnected() {
        return this.Ac != null && this.Ac.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.Ac != null && this.Ac.isConnecting();
    }

    boolean isResuming() {
        return this.Ae;
    }

    private void zzfv(int n) {
        if (this.An == null) {
            this.An = n;
        } else if (this.An != n) {
            String string2 = String.valueOf(zzrd.zzfw(n));
            String string3 = String.valueOf(zzrd.zzfw(this.An));
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.Ac != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.Aj.values()) {
            if (zze2.zzain()) {
                bl = true;
            }
            if (!zze2.zzajc()) continue;
            bl2 = true;
        }
        switch (this.An) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                this.Ac = zzqt.zza(this.mContext, this, this.zg, this.zzajy, this.xP, this.Aj, this.zP, this.zk, this.xQ, this.Am);
                return;
            }
        }
        this.Ac = this.xT && !bl && !bl2 ? new zzqu(this.mContext, this.zg, this.zzajy, this.xP, this.Aj, this.zk, this.Am, this) : new zzrf(this.mContext, this, this.zg, this.zzajy, this.xP, this.Aj, this.zP, this.zk, this.xQ, this.Am, this);
    }

    private void zzasw() {
        this.Ab.zzawd();
        this.Ac.connect();
    }

    private void resume() {
        this.zg.lock();
        try {
            if (this.isResuming()) {
                this.zzasw();
            }
        }
        finally {
            this.zg.unlock();
        }
    }

    private void zzasx() {
        this.zg.lock();
        try {
            boolean bl = this.zzasz();
            if (bl) {
                this.zzasw();
            }
        }
        finally {
            this.zg.unlock();
        }
    }

    void zzasy() {
        if (this.isResuming()) {
            return;
        }
        this.Ae = true;
        if (this.Ai == null) {
            this.Ai = this.xP.zza(this.mContext.getApplicationContext(), new zzb(this));
        }
        this.Ah.sendMessageDelayed(this.Ah.obtainMessage(1), this.Af);
        this.Ah.sendMessageDelayed(this.Ah.obtainMessage(2), this.Ag);
    }

    boolean zzasz() {
        if (!this.isResuming()) {
            return false;
        }
        this.Ae = false;
        this.Ah.removeMessages(2);
        this.Ah.removeMessages(1);
        if (this.Ai != null) {
            this.Ai.unregister();
            this.Ai = null;
        }
        return true;
    }

    @Override
    public void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.Ab.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.Ab.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.Ab.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.Ab.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.Ab.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.Ab.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public void zzn(Bundle bundle) {
        while (!this.Ad.isEmpty()) {
            this.zzb(this.Ad.remove());
        }
        this.Ab.zzp(bundle);
    }

    @Override
    public void zzc(ConnectionResult connectionResult) {
        if (!this.xP.zzd(this.mContext, connectionResult.getErrorCode())) {
            this.zzasz();
        }
        if (!this.isResuming()) {
            this.Ab.zzn(connectionResult);
            this.Ab.zzawc();
        }
    }

    @Override
    public void zzc(int n, boolean bl) {
        if (n == 1 && !bl) {
            this.zzasy();
        }
        this.Ap.zzauf();
        this.Ab.zzgn(n);
        this.Ab.zzawc();
        if (n == 2) {
            this.zzasw();
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzajy;
    }

    @Override
    public boolean zza(zzsa zzsa2) {
        return this.Ac != null && this.Ac.zza(zzsa2);
    }

    @Override
    public void zzard() {
        if (this.Ac != null) {
            this.Ac.zzard();
        }
    }

    @Override
    public void zza(zzsf zzsf2) {
        this.zg.lock();
        try {
            if (this.Ao == null) {
                this.Ao = new HashSet<zzsf>();
            }
            this.Ao.add(zzsf2);
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public void zzb(zzsf zzsf2) {
        this.zg.lock();
        try {
            if (this.Ao == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.Ao.remove(zzsf2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzata()) {
                this.Ac.zzarz();
            }
        }
        finally {
            this.zg.unlock();
        }
    }

    boolean zzata() {
        this.zg.lock();
        try {
            if (this.Ao == null) {
                boolean bl = false;
                return false;
            }
            boolean bl = !this.Ao.isEmpty();
            return bl;
        }
        finally {
            this.zg.unlock();
        }
    }

    String zzatb() {
        StringWriter stringWriter = new StringWriter();
        this.dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.Ae);
        printWriter.append(" mWorkQueue.size()=").print(this.Ad.size());
        this.Ap.dump(printWriter);
        if (this.Ac != null) {
            this.Ac.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public int getSessionId() {
        return System.identityHashCode(this);
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzain()) {
                bl2 = true;
            }
            if (!zze2.zzajc()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    static String zzfw(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    final class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zzrd.this.zzasx();
                    break;
                }
                case 2: {
                    zzrd.this.resume();
                    break;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GoogleApiClientImpl", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }

    static class zzb
    extends zzrj.zza {
        private WeakReference<zzrd> Av;

        zzb(zzrd zzrd2) {
            this.Av = new WeakReference<zzrd>(zzrd2);
        }

        @Override
        public void zzarr() {
            zzrd zzrd2 = (zzrd)this.Av.get();
            if (zzrd2 == null) {
                return;
            }
            zzrd2.resume();
        }
    }
}

