/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzn;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzo
extends zzn
implements Handler.Callback {
    private final HashMap<zzn.zza, zza> zzaGf = new HashMap();
    private final Context zzwi;
    private final Handler mHandler;
    private final com.google.android.gms.common.stats.zza zzaGg;
    private final long zzaGh;
    private final long zzaGi;

    zzo(Context context) {
        this.zzwi = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.zzaGg = com.google.android.gms.common.stats.zza.zzyJ();
        this.zzaGh = 5000L;
        this.zzaGi = 300000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zza(zzn.zza zza2, ServiceConnection serviceConnection, String string2) {
        zzac.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zzn.zza, zza> hashMap = this.zzaGf;
        synchronized (hashMap) {
            zza zza3 = this.zzaGf.get(zza2);
            if (zza3 == null) {
                zza3 = new zza(zza2);
                zza3.zza(serviceConnection, string2);
                zza3.zzdn(string2);
                this.zzaGf.put(zza2, zza3);
            } else {
                this.mHandler.removeMessages(0, (Object)zza2);
                if (zza3.zza(serviceConnection)) {
                    String string3 = String.valueOf(zza2);
                    throw new IllegalStateException(new StringBuilder(81 + String.valueOf(string3).length()).append("Trying to bind a GmsServiceConnection that was already connected before.  config=").append(string3).toString());
                }
                zza3.zza(serviceConnection, string2);
                switch (zza3.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zza3.getComponentName(), zza3.getBinder());
                        break;
                    }
                    case 2: {
                        zza3.zzdn(string2);
                    }
                }
            }
            return zza3.isBound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void zzb(zzn.zza zza2, ServiceConnection serviceConnection, String string2) {
        zzac.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zzn.zza, zza> hashMap = this.zzaGf;
        synchronized (hashMap) {
            zza zza3 = this.zzaGf.get(zza2);
            if (zza3 == null) {
                String string3 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(50 + String.valueOf(string3).length()).append("Nonexistent connection status for service config: ").append(string3).toString());
            }
            if (!zza3.zza(serviceConnection)) {
                String string4 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(76 + String.valueOf(string4).length()).append("Trying to unbind a GmsServiceConnection  that was not bound before.  config=").append(string4).toString());
            }
            zza3.zzb(serviceConnection, string2);
            if (zza3.zzya()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zza2);
                this.mHandler.sendMessageDelayed(message, this.zzaGh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                HashMap<zzn.zza, zza> hashMap = this.zzaGf;
                synchronized (hashMap) {
                    zzn.zza zza2 = (zzn.zza)message.obj;
                    zza zza3 = this.zzaGf.get(zza2);
                    if (zza3 != null && zza3.zzya()) {
                        if (zza3.isBound()) {
                            zza3.zzdo("GmsClientSupervisor");
                        }
                        this.zzaGf.remove(zza2);
                    }
                }
                return true;
            }
            case 1: {
                HashMap<zzn.zza, zza> hashMap = this.zzaGf;
                synchronized (hashMap) {
                    zzn.zza zza4 = (zzn.zza)message.obj;
                    zza zza5 = this.zzaGf.get(zza4);
                    if (zza5 != null && zza5.getState() == 3) {
                        String string2 = String.valueOf(zza4);
                        Log.wtf((String)"GmsClientSupervisor", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Timeout waiting for ServiceConnection callback ").append(string2).toString(), (Throwable)new Exception());
                        string2 = zza5.getComponentName();
                        if (string2 == null) {
                            string2 = zza4.getComponentName();
                        }
                        if (string2 == null) {
                            string2 = new ComponentName(zza4.getPackage(), "unknown");
                        }
                        zza5.onServiceDisconnected((ComponentName)string2);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private final class zza
    implements ServiceConnection {
        private final Set<ServiceConnection> zzaGj;
        private int mState;
        private boolean zzaGk;
        private IBinder zzaFz;
        private final zzn.zza zzaGl;
        private ComponentName zzaGe;

        public zza(zzn.zza zza2) {
            this.zzaGl = zza2;
            this.zzaGj = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            HashMap hashMap = zzo.this.zzaGf;
            synchronized (hashMap) {
                zzo.this.mHandler.removeMessages(1, (Object)this.zzaGl);
                this.zzaFz = iBinder;
                this.zzaGe = componentName;
                for (ServiceConnection serviceConnection : this.zzaGj) {
                    serviceConnection.onServiceConnected(componentName, iBinder);
                }
                this.mState = 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName componentName) {
            HashMap hashMap = zzo.this.zzaGf;
            synchronized (hashMap) {
                zzo.this.mHandler.removeMessages(1, (Object)this.zzaGl);
                this.zzaFz = null;
                this.zzaGe = componentName;
                for (ServiceConnection serviceConnection : this.zzaGj) {
                    serviceConnection.onServiceDisconnected(componentName);
                }
                this.mState = 2;
            }
        }

        public void zzdn(String string2) {
            this.mState = 3;
            this.zzaGk = zzo.this.zzaGg.zza(zzo.this.zzwi, string2, this.zzaGl.zzxZ(), this, 129);
            if (this.zzaGk) {
                Message message = zzo.this.mHandler.obtainMessage(1, (Object)this.zzaGl);
                zzo.this.mHandler.sendMessageDelayed(message, zzo.this.zzaGi);
            } else {
                this.mState = 2;
                try {
                    zzo.this.zzaGg.zza(zzo.this.zzwi, this);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }

        public void zzdo(String string2) {
            zzo.this.mHandler.removeMessages(1, (Object)this.zzaGl);
            zzo.this.zzaGg.zza(zzo.this.zzwi, this);
            this.zzaGk = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzo.this.zzaGg.zza(zzo.this.zzwi, serviceConnection, string2, this.zzaGl.zzxZ());
            this.zzaGj.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzo.this.zzaGg.zzb(zzo.this.zzwi, serviceConnection);
            this.zzaGj.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.zzaGk;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.zzaGj.contains(serviceConnection);
        }

        public boolean zzya() {
            return this.zzaGj.isEmpty();
        }

        public IBinder getBinder() {
            return this.zzaFz;
        }

        public ComponentName getComponentName() {
            return this.zzaGe;
        }
    }
}

