/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbxt;
import com.google.android.gms.internal.zzbxw;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzbxm {
    private final ByteBuffer zzcuH;

    private zzbxm(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzbxm(ByteBuffer byteBuffer) {
        this.zzcuH = byteBuffer;
        this.zzcuH.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzbxm zzag(byte[] byArray) {
        return zzbxm.zzc(byArray, 0, byArray.length);
    }

    public static zzbxm zzc(byte[] byArray, int n, int n2) {
        return new zzbxm(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzN(n, 1);
        this.zzn(d);
    }

    public void zzc(int n, float f) throws IOException {
        this.zzN(n, 5);
        this.zzk(f);
    }

    public void zza(int n, long l) throws IOException {
        this.zzN(n, 0);
        this.zzba(l);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzN(n, 0);
        this.zzbb(l);
    }

    public void zzJ(int n, int n2) throws IOException {
        this.zzN(n, 0);
        this.zzre(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzN(n, 1);
        this.zzbc(l);
    }

    public void zzg(int n, boolean bl) throws IOException {
        this.zzN(n, 0);
        this.zzbq(bl);
    }

    public void zzq(int n, String string2) throws IOException {
        this.zzN(n, 2);
        this.zzka(string2);
    }

    public void zza(int n, zzbxt zzbxt2) throws IOException {
        this.zzN(n, 2);
        this.zzc(zzbxt2);
    }

    public void zzb(int n, byte[] byArray) throws IOException {
        this.zzN(n, 2);
        this.zzah(byArray);
    }

    public void zzK(int n, int n2) throws IOException {
        this.zzN(n, 0);
        this.zzrf(n2);
    }

    public void zzd(int n, long l) throws IOException {
        this.zzN(n, 0);
        this.zzbd(l);
    }

    public void zzn(double d) throws IOException {
        this.zzbj(Double.doubleToLongBits(d));
    }

    public void zzk(float f) throws IOException {
        this.zzrm(Float.floatToIntBits(f));
    }

    public void zzba(long l) throws IOException {
        this.zzbh(l);
    }

    public void zzbb(long l) throws IOException {
        this.zzbh(l);
    }

    public void zzre(int n) throws IOException {
        if (n >= 0) {
            this.zzrk(n);
        } else {
            this.zzbh(n);
        }
    }

    public void zzbc(long l) throws IOException {
        this.zzbj(l);
    }

    public void zzbq(boolean bl) throws IOException {
        this.zzri(bl ? 1 : 0);
    }

    public void zzka(String string2) throws IOException {
        try {
            int n = zzbxm.zzrl(string2.length());
            int n2 = zzbxm.zzrl(string2.length() * 3);
            if (n == n2) {
                int n3 = this.zzcuH.position();
                if (this.zzcuH.remaining() < n) {
                    throw new zza(n3 + n, this.zzcuH.limit());
                }
                this.zzcuH.position(n3 + n);
                zzbxm.zza((CharSequence)string2, this.zzcuH);
                int n4 = this.zzcuH.position();
                this.zzcuH.position(n3);
                this.zzrk(n4 - n3 - n);
                this.zzcuH.position(n4);
            } else {
                this.zzrk(zzbxm.zzb(string2));
                zzbxm.zza((CharSequence)string2, this.zzcuH);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            zza zza2 = new zza(this.zzcuH.position(), this.zzcuH.limit());
            zza2.initCause(bufferOverflowException);
            throw zza2;
        }
    }

    private static int zzb(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zzbxm.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                int n5 = i;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n5).toString());
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zzbxm.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zzbxm.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                n2 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n2).toString());
            }
            n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n < n5 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n + n4;
        }
        int n6 = n + n3;
        while (n3 < n4) {
            int n7;
            char c2;
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n6 < n5) {
                byArray[n6++] = (byte)c;
            } else if (c < '\u0800' && n6 <= n5 - 2) {
                byArray[n6++] = (byte)(0x3C0 | c >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n6 <= n5 - 3) {
                byArray[n6++] = (byte)(0x1E0 | c >>> 12);
                byArray[n6++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & c);
            } else if (n6 <= n5 - 4) {
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    n7 = n3 - 1;
                    throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                }
                n7 = Character.toCodePoint(c, c2);
                byArray[n6++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n6++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n6++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n6++] = (byte)(0x80 | 0x3F & n7);
            } else {
                c2 = c;
                n7 = n6;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n7).toString());
            }
            ++n3;
        }
        return n6;
    }

    public void zzb(zzbxt zzbxt2) throws IOException {
        zzbxt2.zza(this);
    }

    public void zzc(zzbxt zzbxt2) throws IOException {
        this.zzrk(zzbxt2.zzaeS());
        zzbxt2.zza(this);
    }

    public void zzah(byte[] byArray) throws IOException {
        this.zzrk(byArray.length);
        this.zzaj(byArray);
    }

    public void zzrf(int n) throws IOException {
        this.zzrk(zzbxm.zzrn(n));
    }

    public void zzbd(long l) throws IOException {
        this.zzbh(zzbxm.zzbk(l));
    }

    public static int zzb(int n, double d) {
        return zzbxm.zzrj(n) + 8;
    }

    public static int zzd(int n, float f) {
        return zzbxm.zzrj(n) + 4;
    }

    public static int zze(int n, long l) {
        return zzbxm.zzrj(n) + zzbxm.zzbe(l);
    }

    public static int zzf(int n, long l) {
        return zzbxm.zzrj(n) + zzbxm.zzbf(l);
    }

    public static int zzL(int n, int n2) {
        return zzbxm.zzrj(n) + zzbxm.zzrg(n2);
    }

    public static int zzg(int n, long l) {
        return zzbxm.zzrj(n) + 8;
    }

    public static int zzh(int n, boolean bl) {
        return zzbxm.zzrj(n) + 1;
    }

    public static int zzr(int n, String string2) {
        return zzbxm.zzrj(n) + zzbxm.zzkb(string2);
    }

    public static int zzb(int n, zzbxt zzbxt2) {
        return zzbxm.zzrj(n) * 2 + zzbxm.zzd(zzbxt2);
    }

    public static int zzc(int n, zzbxt zzbxt2) {
        return zzbxm.zzrj(n) + zzbxm.zze(zzbxt2);
    }

    public static int zzc(int n, byte[] byArray) {
        return zzbxm.zzrj(n) + zzbxm.zzai(byArray);
    }

    public static int zzM(int n, int n2) {
        return zzbxm.zzrj(n) + zzbxm.zzrh(n2);
    }

    public static int zzh(int n, long l) {
        return zzbxm.zzrj(n) + zzbxm.zzbg(l);
    }

    public static int zzbe(long l) {
        return zzbxm.zzbi(l);
    }

    public static int zzbf(long l) {
        return zzbxm.zzbi(l);
    }

    public static int zzrg(int n) {
        if (n >= 0) {
            return zzbxm.zzrl(n);
        }
        return 10;
    }

    public static int zzkb(String string2) {
        int n = zzbxm.zzb(string2);
        return zzbxm.zzrl(n) + n;
    }

    public static int zzd(zzbxt zzbxt2) {
        return zzbxt2.zzaeT();
    }

    public static int zze(zzbxt zzbxt2) {
        int n = zzbxt2.zzaeT();
        return zzbxm.zzrl(n) + n;
    }

    public static int zzai(byte[] byArray) {
        return zzbxm.zzrl(byArray.length) + byArray.length;
    }

    public static int zzrh(int n) {
        return zzbxm.zzrl(zzbxm.zzrn(n));
    }

    public static int zzbg(long l) {
        return zzbxm.zzbi(zzbxm.zzbk(l));
    }

    public int zzaeF() {
        return this.zzcuH.remaining();
    }

    public void zzaeG() {
        if (this.zzaeF() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzc(byte by) throws IOException {
        if (!this.zzcuH.hasRemaining()) {
            throw new zza(this.zzcuH.position(), this.zzcuH.limit());
        }
        this.zzcuH.put(by);
    }

    public void zzri(int n) throws IOException {
        this.zzc((byte)n);
    }

    public void zzaj(byte[] byArray) throws IOException {
        this.zzd(byArray, 0, byArray.length);
    }

    public void zzd(byte[] byArray, int n, int n2) throws IOException {
        if (this.zzcuH.remaining() < n2) {
            throw new zza(this.zzcuH.position(), this.zzcuH.limit());
        }
        this.zzcuH.put(byArray, n, n2);
    }

    public void zzN(int n, int n2) throws IOException {
        this.zzrk(zzbxw.zzO(n, n2));
    }

    public static int zzrj(int n) {
        return zzbxm.zzrl(zzbxw.zzO(n, 0));
    }

    public void zzrk(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzri(n);
                return;
            }
            this.zzri(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzrl(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzbh(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzri((int)l);
                return;
            }
            this.zzri((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzbi(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zzrm(int n) throws IOException {
        if (this.zzcuH.remaining() < 4) {
            throw new zza(this.zzcuH.position(), this.zzcuH.limit());
        }
        this.zzcuH.putInt(n);
    }

    public void zzbj(long l) throws IOException {
        if (this.zzcuH.remaining() < 8) {
            throw new zza(this.zzcuH.position(), this.zzcuH.limit());
        }
        this.zzcuH.putLong(l);
    }

    public static int zzrn(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzbk(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super(new StringBuilder(108).append("CodedOutputStream was writing to a flat byte array and ran out of space (pos ").append(n).append(" limit ").append(n2).append(").").toString());
        }
    }
}

