/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzf;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import java.util.Arrays;

public final class Status
extends zza
implements Result,
ReflectedParcelable {
    public static final Status zzaBo = new Status(0);
    public static final Status zzaBp = new Status(14);
    public static final Status zzaBq = new Status(8);
    public static final Status zzaBr = new Status(15);
    public static final Status zzaBs = new Status(16);
    private static Status zzaBt = new Status(17);
    private static Status zzaBu = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzf();
    private int zzakw;
    private final int zzaxw;
    private final String zzaAa;
    private final PendingIntent mPendingIntent;

    Status(int n, int n2, String string2, PendingIntent pendingIntent) {
        this.zzakw = n;
        this.zzaxw = n2;
        this.zzaAa = string2;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, String string2, PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public final void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), n, null, 0, 0, 0);
    }

    @Nullable
    public final String getStatusMessage() {
        return this.zzaAa;
    }

    public final boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public final boolean isSuccess() {
        return this.zzaxw <= 0;
    }

    public final boolean isCanceled() {
        return this.zzaxw == 16;
    }

    public final boolean isInterrupted() {
        return this.zzaxw == 14;
    }

    public final int getStatusCode() {
        return this.zzaxw;
    }

    public final PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzakw, this.zzaxw, this.zzaAa, this.mPendingIntent});
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.zzakw == status.zzakw && this.zzaxw == status.zzaxw && zzbh.equal(this.zzaAa, status.zzaAa) && zzbh.equal(this.mPendingIntent, status.mPendingIntent);
    }

    public final String zzpo() {
        if (this.zzaAa != null) {
            return this.zzaAa;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzaxw);
    }

    public final String toString() {
        return zzbh.zzt(this).zzg("statusCode", this.zzpo()).zzg("resolution", this.mPendingIntent).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Status status = this;
        int n2 = zzd.zze(parcel2);
        zzd.zzc(parcel2, 1, status.getStatusCode());
        zzd.zza(parcel2, 2, status.getStatusMessage(), false);
        zzd.zza(parcel2, 3, (Parcelable)status.mPendingIntent, n, false);
        zzd.zzc(parcel2, 1000, status.zzakw);
        zzd.zzI(parcel2, n2);
    }

    @Override
    public final Status getStatus() {
        return this;
    }
}

