/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.zze;
import com.google.android.gms.common.zzo;
import com.google.android.gms.internal.zzfd;
import com.google.android.gms.internal.zzfe;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@KeepForSdkWithMembers
public class AdvertisingIdClient {
    @Nullable
    private com.google.android.gms.common.zza zzsx;
    @Nullable
    private zzfd zzsy;
    private boolean zzsz;
    private Object zzsA = new Object();
    @Nullable
    private zza zzsB;
    private final Context mContext;
    private long zzsC;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L, false);
    }

    public AdvertisingIdClient(Context context, long l, boolean bl) {
        Context context2;
        zzbo.zzu(context);
        this.mContext = bl ? ((context2 = context.getApplicationContext()) == null ? context : context2) : context;
        this.zzsz = false;
        this.zzsC = l;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void start(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzbo.zzcG("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzsz) {
                this.finish();
            }
            this.zzsx = AdvertisingIdClient.zzd(this.mContext);
            this.zzsy = AdvertisingIdClient.zza(this.mContext, this.zzsx);
            this.zzsz = true;
            if (bl) {
                this.zzaj();
            }
            return;
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzaj() {
        Object object = this.zzsA;
        synchronized (object) {
            if (this.zzsB != null) {
                this.zzsB.zzsG.countDown();
                try {
                    this.zzsB.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.zzsC > 0L) {
                this.zzsB = new zza(this, this.zzsC);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        Info info;
        zzbo.zzcG("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzsz) {
                Object object = this.zzsA;
                synchronized (object) {
                    if (this.zzsB == null || !this.zzsB.zzsH) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.start(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzsz) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzbo.zzu(this.zzsx);
            zzbo.zzu(this.zzsy);
            try {
                info = new Info(this.zzsy.getId(), this.zzsy.zzb(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzaj();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzbo.zzcG("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzsx == null) {
                return;
            }
            try {
                if (this.zzsz) {
                    com.google.android.gms.common.stats.zza.zzrU();
                    com.google.android.gms.common.zza zza2 = this.zzsx;
                    Context context = this.mContext;
                    context.unbindService((ServiceConnection)zza2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzsz = false;
            this.zzsy = null;
            this.zzsx = null;
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    private static com.google.android.gms.common.zza zzd(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            context.getPackageManager().getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        switch (zze.zzoW().isGooglePlayServicesAvailable(context)) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (com.google.android.gms.common.stats.zza.zzrU().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    @Nullable
    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Object object;
        boolean bl = false;
        float f = 0.0f;
        try {
            object = zzo.getRemoteContext(context);
            if (object != null) {
                SharedPreferences sharedPreferences = object.getSharedPreferences("google_ads_flags", 0);
                bl = sharedPreferences.getBoolean("gads:ad_id_app_context:enabled", false);
                f = sharedPreferences.getFloat("gads:ad_id_app_context:ping_ratio", 0.0f);
            }
        }
        catch (Exception exception) {
            Log.w((String)"AdvertisingIdClient", (String)"Error while reading from SharedPreferences ", (Throwable)exception);
        }
        object = new AdvertisingIdClient(context, -1L, bl);
        try {
            super.start(false);
            Info info = ((AdvertisingIdClient)object).getInfo();
            super.zza(info, bl, f, null);
            Info info2 = info;
            return info2;
        }
        catch (Throwable throwable) {
            super.zza(null, bl, f, throwable);
            return null;
        }
        finally {
            ((AdvertisingIdClient)object).finish();
        }
    }

    private final void zza(Info info, boolean bl, float f, Throwable throwable) {
        if (Math.random() > (double)f) {
            return;
        }
        Throwable throwable2 = throwable;
        boolean bl2 = bl;
        Info info2 = info;
        Bundle bundle = new Bundle();
        bundle.putString("app_context", bl2 ? "1" : "0");
        if (info2 != null) {
            bundle.putString("limit_ad_tracking", info2.isLimitAdTrackingEnabled() ? "1" : "0");
        }
        if (info2 != null && info2.getId() != null) {
            bundle.putString("ad_id_size", Integer.toString(info2.getId().length()));
        }
        if (throwable2 != null) {
            bundle.putString("error", throwable2.getClass().getName());
        }
        Uri.Builder builder = Uri.parse((String)"https://pagead2.googlesyndication.com/pagead/gen_204?id=gmob-apps").buildUpon();
        for (String string2 : bundle.keySet()) {
            builder.appendQueryParameter(string2, bundle.getString(string2));
        }
        String string3 = builder.build().toString();
        new com.google.android.gms.ads.identifier.zza(this, string3).start();
    }

    private static zzfd zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzfe.zzc(zza2.zza(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzsI;
        private final boolean zzsJ;

        public Info(String string2, boolean bl) {
            this.zzsI = string2;
            this.zzsJ = bl;
        }

        public final String getId() {
            return this.zzsI;
        }

        public final boolean isLimitAdTrackingEnabled() {
            return this.zzsJ;
        }

        public final String toString() {
            String string2 = this.zzsI;
            boolean bl = this.zzsJ;
            return new StringBuilder(7 + String.valueOf(string2).length()).append("{").append(string2).append("}").append(bl).toString();
        }
    }

    static final class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzsE;
        private long zzsF;
        CountDownLatch zzsG;
        boolean zzsH;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzsE = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzsF = l;
            this.zzsG = new CountDownLatch(1);
            this.zzsH = false;
            this.start();
        }

        private final void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzsE.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzsH = true;
            }
        }

        @Override
        public final void run() {
            try {
                if (!this.zzsG.await(this.zzsF, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
                return;
            }
        }
    }
}

