/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.adi;
import com.google.android.gms.internal.adp;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class adh {
    private final ByteBuffer zzcsn;

    private adh(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private adh(ByteBuffer byteBuffer) {
        this.zzcsn = byteBuffer;
        this.zzcsn.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static adh zzI(byte[] byArray) {
        return adh.zzc(byArray, 0, byArray.length);
    }

    public static adh zzc(byte[] byArray, int n, int n2) {
        return new adh(byArray, 0, n2);
    }

    public final void zza(int n, double d) throws IOException {
        this.zzt(n, 1);
        double d2 = d;
        this.zzaQ(Double.doubleToLongBits(d2));
    }

    public final void zzc(int n, float f) throws IOException {
        this.zzt(n, 5);
        float f2 = f;
        int n2 = Float.floatToIntBits(f2);
        adh adh2 = this;
        if (adh2.zzcsn.remaining() < 4) {
            throw new adi(adh2.zzcsn.position(), adh2.zzcsn.limit());
        }
        adh2.zzcsn.putInt(n2);
    }

    public final void zza(int n, long l) throws IOException {
        this.zzt(n, 0);
        long l2 = l;
        this.zzaO(l2);
    }

    public final void zzb(int n, long l) throws IOException {
        this.zzt(n, 0);
        long l2 = l;
        this.zzaO(l2);
    }

    public final void zzr(int n, int n2) throws IOException {
        this.zzt(n, 0);
        int n3 = n2;
        adh adh2 = this;
        if (n3 >= 0) {
            adh2.zzcu(n3);
            return;
        }
        adh2.zzaO(n3);
    }

    public final void zzc(int n, long l) throws IOException {
        this.zzt(n, 1);
        long l2 = l;
        this.zzaQ(l2);
    }

    public final void zzk(int n, boolean bl) throws IOException {
        this.zzt(n, 0);
        boolean bl2 = bl;
        boolean bl3 = bl2;
        byte by = (byte)(bl3 ? 1 : 0);
        adh adh2 = this;
        if (!adh2.zzcsn.hasRemaining()) {
            throw new adi(adh2.zzcsn.position(), adh2.zzcsn.limit());
        }
        adh2.zzcsn.put(by);
    }

    public final void zzl(int n, String string2) throws IOException {
        this.zzt(n, 2);
        String string3 = string2;
        adh adh2 = this;
        try {
            int n2 = adh.zzcv(string3.length());
            int n3 = adh.zzcv(string3.length() * 3);
            if (n2 == n3) {
                int n4 = adh2.zzcsn.position();
                if (adh2.zzcsn.remaining() < n2) {
                    throw new adi(n4 + n2, adh2.zzcsn.limit());
                }
                adh2.zzcsn.position(n4 + n2);
                adh.zza(string3, adh2.zzcsn);
                int n5 = adh2.zzcsn.position();
                adh2.zzcsn.position(n4);
                adh2.zzcu(n5 - n4 - n2);
                adh2.zzcsn.position(n5);
                return;
            }
            adh2.zzcu(adh.zzb(string3));
            adh.zza(string3, adh2.zzcsn);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            adi adi2 = new adi(adh2.zzcsn.position(), adh2.zzcsn.limit());
            adi2.initCause(bufferOverflowException);
            throw adi2;
        }
    }

    public final void zza(int n, adp adp2) throws IOException {
        this.zzt(n, 2);
        this.zzb(adp2);
    }

    public final void zzb(int n, byte[] byArray) throws IOException {
        this.zzt(n, 2);
        byte[] byArray2 = byArray;
        adh adh2 = this;
        adh2.zzcu(byArray2.length);
        adh2.zzK(byArray2);
    }

    public final void zzd(int n, long l) throws IOException {
        this.zzt(n, 0);
        long l2 = l;
        this.zzaO(adh.zzaR(l2));
    }

    private static int zzb(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = adh.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        adh.zzb(charSequence, byteBuffer);
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                n2 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n2).toString());
            }
            n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n5 < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n5 + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n5 + n4;
        }
        n5 += n3;
        while (n3 < n4) {
            int n7;
            char c2;
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    n7 = n3 - 1;
                    throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                }
                n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                c2 = c;
                n7 = n5;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n7).toString());
            }
            ++n3;
        }
        return n5;
    }

    public final void zzb(adp adp2) throws IOException {
        this.zzcu(adp2.zzLU());
        adp2.zza(this);
    }

    public static int zze(int n, long l) {
        return adh.zzct(n) + adh.zzaP(l);
    }

    public static int zzs(int n, int n2) {
        return adh.zzct(n) + adh.zzcr(n2);
    }

    public static int zzm(int n, String string2) {
        return adh.zzct(n) + adh.zzhQ(string2);
    }

    public static int zzb(int n, adp adp2) {
        int n2 = adp2.zzLV();
        return adh.zzct(n) + (adh.zzcv(n2) + n2);
    }

    public static int zzc(int n, byte[] byArray) {
        return adh.zzct(n) + adh.zzJ(byArray);
    }

    public static int zzf(int n, long l) {
        return adh.zzct(n) + adh.zzaP(adh.zzaR(l));
    }

    public static int zzcr(int n) {
        if (n >= 0) {
            return adh.zzcv(n);
        }
        return 10;
    }

    public static int zzhQ(String string2) {
        int n = adh.zzb(string2);
        return adh.zzcv(n) + n;
    }

    public static int zzJ(byte[] byArray) {
        return adh.zzcv(byArray.length) + byArray.length;
    }

    public final void zzLM() {
        if (this.zzcsn.remaining() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    private final void zzcs(int n) throws IOException {
        byte by = (byte)n;
        adh adh2 = this;
        if (!adh2.zzcsn.hasRemaining()) {
            throw new adi(adh2.zzcsn.position(), adh2.zzcsn.limit());
        }
        adh2.zzcsn.put(by);
    }

    public final void zzK(byte[] byArray) throws IOException {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        adh adh2 = this;
        if (adh2.zzcsn.remaining() >= n) {
            adh2.zzcsn.put(byArray2, 0, n);
            return;
        }
        throw new adi(adh2.zzcsn.position(), adh2.zzcsn.limit());
    }

    public final void zzt(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzcu(n << 3 | n3);
    }

    public static int zzct(int n) {
        return adh.zzcv(n << 3);
    }

    public final void zzcu(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzcs(n);
                return;
            }
            this.zzcs(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzcv(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private final void zzaO(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzcs((int)l);
                return;
            }
            this.zzcs((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzaP(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    private final void zzaQ(long l) throws IOException {
        if (this.zzcsn.remaining() < 8) {
            throw new adi(this.zzcsn.position(), this.zzcsn.limit());
        }
        this.zzcsn.putLong(l);
    }

    public static int zzcw(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzaR(long l) {
        return l << 1 ^ l >> 63;
    }
}

