/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzedj;
import com.google.android.gms.internal.zzedk;
import com.google.android.gms.internal.zzedx;
import com.google.android.gms.internal.zzeen;
import com.google.android.gms.internal.zzeey;
import com.google.android.gms.internal.zzefr;
import com.google.android.gms.internal.zzeft;
import com.google.android.gms.internal.zzefw;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzedw
extends zzedj {
    private static final Logger logger = Logger.getLogger(zzedw.class.getName());
    private static final boolean zzmyg = zzefr.zzcdi();

    public static zzedw zzat(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    private zzedw() {
    }

    public abstract void zzt(int var1, int var2) throws IOException;

    public abstract void zzu(int var1, int var2) throws IOException;

    public abstract void zzl(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzedk var2) throws IOException;

    public abstract void zza(int var1, zzeey var2) throws IOException;

    public abstract void zzgp(int var1) throws IOException;

    public abstract void zzgq(int var1) throws IOException;

    public abstract void zzcn(long var1) throws IOException;

    public abstract void zzrb(String var1) throws IOException;

    public abstract void zzah(zzedk var1) throws IOException;

    public abstract void zzd(zzeey var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzv(int n, int n2) {
        return zzedw.zzgr(n) + zzedw.zzgs(n2);
    }

    public static int zzw(int n, int n2) {
        return zzedw.zzgr(n) + zzedw.zzgs(n2);
    }

    public static int zzm(int n, String string2) {
        return zzedw.zzgr(1) + zzedw.zzrc(string2);
    }

    public static int zzb(int n, zzedk zzedk2) {
        int n2 = zzedk2.size();
        return zzedw.zzgr(n) + (zzedw.zzgt(n2) + n2);
    }

    public static int zzb(int n, zzeey zzeey2) {
        zzeey zzeey3 = zzeey2;
        int n2 = zzeey3.zzbjo();
        return zzedw.zzgr(n) + (zzedw.zzgt(n2) + n2);
    }

    private static int zzgr(int n) {
        return zzedw.zzgt(n << 3);
    }

    private static int zzgs(int n) {
        if (n >= 0) {
            return zzedw.zzgt(n);
        }
        return 10;
    }

    public static int zzgt(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private static int zzrc(String string2) {
        int n;
        try {
            n = zzeft.zzb(string2);
        }
        catch (zzefw zzefw2) {
            n = string2.getBytes(zzeen.UTF_8).length;
        }
        int n2 = n;
        return zzedw.zzgt(n2) + n2;
    }

    public abstract int zzccc();

    public final void zzccd() {
        if (this.zzccc() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    final void zza(String string2, zzefw zzefw2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzefw2);
        byte[] byArray = string2.getBytes(zzeen.UTF_8);
        try {
            this.zzgq(byArray.length);
            this.zzb(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzb(indexOutOfBoundsException);
        }
        catch (zzb zzb2) {
            throw zzb2;
        }
    }

    /* synthetic */ zzedw(zzedx zzedx2) {
        this();
    }

    static class zza
    extends zzedw {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzt(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzedw)this).zzgq(n << 3 | n3);
        }

        @Override
        public final void zzu(int n, int n2) throws IOException {
            ((zzedw)this).zzt(n, 0);
            ((zzedw)this).zzgp(n2);
        }

        @Override
        public final void zzl(int n, String string2) throws IOException {
            ((zzedw)this).zzt(1, 2);
            ((zzedw)this).zzrb(string2);
        }

        @Override
        public final void zza(int n, zzedk zzedk2) throws IOException {
            ((zzedw)this).zzt(n, 2);
            ((zzedw)this).zzah(zzedk2);
        }

        @Override
        public final void zzah(zzedk zzedk2) throws IOException {
            ((zzedw)this).zzgq(zzedk2.size());
            zzedk2.zza(this);
        }

        @Override
        public final void zza(int n, zzeey zzeey2) throws IOException {
            ((zzedw)this).zzt(n, 2);
            ((zzedw)this).zzd(zzeey2);
        }

        @Override
        public final void zzd(zzeey zzeey2) throws IOException {
            ((zzedw)this).zzgq(zzeey2.zzbjo());
            zzeey2.zza(this);
        }

        @Override
        public final void zzgp(int n) throws IOException {
            if (n >= 0) {
                ((zzedw)this).zzgq(n);
                return;
            }
            ((zzedw)this).zzcn(n);
        }

        @Override
        public final void zzgq(int n) throws IOException {
            if (zzmyg && ((zzedw)this).zzccc() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzefr.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzefr.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzcn(long l) throws IOException {
            if (zzmyg && ((zzedw)this).zzccc() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzefr.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzefr.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzb(byte[] byArray, int n, int n2) throws IOException {
            ((zzedw)this).write(byArray, n, n2);
        }

        @Override
        public final void zzrb(String string2) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzgt(string2.length() * 3);
                int n3 = zza.zzgt(string2.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzeft.zza(string2, this.buffer, this.position, ((zzedw)this).zzccc());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzedw)this).zzgq(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzeft.zzb(string2);
                ((zzedw)this).zzgq(n6);
                this.position = zzeft.zza(string2, this.buffer, this.position, ((zzedw)this).zzccc());
                return;
            }
            catch (zzefw zzefw2) {
                this.position = n;
                this.zza(string2, zzefw2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzb(indexOutOfBoundsException);
            }
        }

        @Override
        public final int zzccc() {
            return this.limit - this.position;
        }
    }

    public static final class zzb
    extends IOException {
        zzb() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzb(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzb(String string2, Throwable throwable) {
            String string3 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string4 = String.valueOf(string2);
            super(string4.length() != 0 ? string3.concat(string4) : new String(string3), throwable);
        }
    }
}

