/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.internal.zzai;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class zzaj
implements ServiceConnection {
    private final Set<ServiceConnection> zzfyg;
    private int mState;
    private boolean zzfyh;
    private IBinder zzfwv;
    private final zzah zzfyi;
    private ComponentName mComponentName;
    private /* synthetic */ zzai zzfyj;

    public zzaj(zzai zzai2, zzah zzah2) {
        this.zzfyj = zzai2;
        this.zzfyi = zzah2;
        this.zzfyg = new HashSet<ServiceConnection>();
        this.mState = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        HashMap hashMap = zzai.zza(this.zzfyj);
        synchronized (hashMap) {
            zzai.zzb(this.zzfyj).removeMessages(1, (Object)this.zzfyi);
            this.zzfwv = iBinder;
            this.mComponentName = componentName;
            Iterator<ServiceConnection> iterator = this.zzfyg.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceConnected(componentName, iBinder);
            }
            this.mState = 1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceDisconnected(ComponentName componentName) {
        HashMap hashMap = zzai.zza(this.zzfyj);
        synchronized (hashMap) {
            zzai.zzb(this.zzfyj).removeMessages(1, (Object)this.zzfyi);
            this.zzfwv = null;
            this.mComponentName = componentName;
            Iterator<ServiceConnection> iterator = this.zzfyg.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceDisconnected(componentName);
            }
            this.mState = 2;
            return;
        }
    }

    public final void zzge(String string2) {
        this.mState = 3;
        this.zzfyh = zzai.zzd(this.zzfyj).zza(zzai.zzc(this.zzfyj), string2, this.zzfyi.zzala(), this, this.zzfyi.zzakz());
        if (this.zzfyh) {
            Message message = zzai.zzb(this.zzfyj).obtainMessage(1, (Object)this.zzfyi);
            zzai.zzb(this.zzfyj).sendMessageDelayed(message, zzai.zze(this.zzfyj));
            return;
        }
        this.mState = 2;
        try {
            zzai.zzd(this.zzfyj);
            zzaj zzaj2 = this;
            Context context = zzai.zzc(this.zzfyj);
            context.unbindService((ServiceConnection)zzaj2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public final void zzgf(String string2) {
        zzai.zzb(this.zzfyj).removeMessages(1, (Object)this.zzfyi);
        zzai.zzd(this.zzfyj);
        zzaj zzaj2 = this;
        Context context = zzai.zzc(this.zzfyj);
        context.unbindService((ServiceConnection)zzaj2);
        this.zzfyh = false;
        this.mState = 2;
    }

    public final void zza(ServiceConnection serviceConnection, String string2) {
        zzai.zzd(this.zzfyj);
        zzai.zzc(this.zzfyj);
        this.zzfyi.zzala();
        this.zzfyg.add(serviceConnection);
    }

    public final void zzb(ServiceConnection serviceConnection, String string2) {
        zzai.zzd(this.zzfyj);
        zzai.zzc(this.zzfyj);
        this.zzfyg.remove(serviceConnection);
    }

    public final boolean isBound() {
        return this.zzfyh;
    }

    public final int getState() {
        return this.mState;
    }

    public final boolean zza(ServiceConnection serviceConnection) {
        return this.zzfyg.contains(serviceConnection);
    }

    public final boolean zzalb() {
        return this.zzfyg.isEmpty();
    }

    public final IBinder getBinder() {
        return this.zzfwv;
    }

    public final ComponentName getComponentName() {
        return this.mComponentName;
    }
}

