/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.SystemClock;
import android.text.TextUtils;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzah;
import com.google.android.gms.internal.zzai;
import com.google.android.gms.internal.zzb;
import com.google.android.gms.internal.zzc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class zzag
implements zzb {
    private final Map<String, zzah> zzbt = new LinkedHashMap<String, zzah>(16, 0.75f, true);
    private long zzbu = 0L;
    private final File zzbv;
    private final int zzbw;

    private zzag(File file, int n) {
        this.zzbv = file;
        this.zzbw = 0x500000;
    }

    public zzag(File file) {
        this(file, 0x500000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final synchronized zzc zza(String string2) {
        zzah zzah2 = this.zzbt.get(string2);
        if (zzah2 == null) {
            return null;
        }
        File file = this.zze(string2);
        try (zzai zzai2 = new zzai(new BufferedInputStream(zzag.zza(file)), file.length());){
            byte[] byArray;
            zzah zzah3 = zzah.zzc(zzai2);
            if (!TextUtils.equals((CharSequence)string2, (CharSequence)zzah3.key)) {
                zzab.zzb("%s: key=%s, found=%s", file.getAbsolutePath(), string2, zzah3.key);
                this.removeEntry(string2);
                return null;
            }
            byte[] byArray2 = byArray = zzag.zza(zzai2, zzai2.zzn());
            zzah zzah4 = zzah2;
            zzc zzc2 = new zzc();
            new zzc().data = byArray2;
            zzc2.zza = zzah4.zza;
            zzc2.zzb = zzah4.zzb;
            zzc2.zzc = zzah4.zzc;
            zzc2.zzd = zzah4.zzd;
            zzc2.zze = zzah4.zze;
            zzc2.zzf = zzah4.zzf;
            zzc zzc3 = zzc2;
            return zzc3;
        }
        catch (IOException iOException) {
            zzab.zzb("%s: %s", file.getAbsolutePath(), iOException.toString());
            this.remove(string2);
            return null;
        }
    }

    @Override
    public final synchronized void initialize() {
        if (!this.zzbv.exists()) {
            if (!this.zzbv.mkdirs()) {
                zzab.zzc("Unable to create cache dir %s", this.zzbv.getAbsolutePath());
            }
            return;
        }
        File[] fileArray = this.zzbv.listFiles();
        if (fileArray == null) {
            return;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file = fileArray2[i];
            try {
                long l = file.length();
                try (zzai zzai2 = new zzai(new BufferedInputStream(zzag.zza(file)), l);){
                    zzah zzah2 = zzah.zzc(zzai2);
                    zzah.zzc(zzai2).zzbx = l;
                    this.zza(zzah2.key, zzah2);
                    continue;
                }
            }
            catch (IOException iOException) {
                file.delete();
            }
        }
    }

    @Override
    public final synchronized void zza(String string2, zzc zzc2) {
        int n = zzc2.data.length;
        Object object = this;
        if (((zzag)object).zzbu + (long)n >= (long)((zzag)object).zzbw) {
            if (zzab.DEBUG) {
                zzab.zza("Pruning old cache entries.", new Object[0]);
            }
            long l = ((zzag)object).zzbu;
            int n2 = 0;
            long l2 = SystemClock.elapsedRealtime();
            Iterator<Map.Entry<String, zzah>> iterator = ((zzag)object).zzbt.entrySet().iterator();
            while (iterator.hasNext()) {
                zzah zzah2 = iterator.next().getValue();
                if (super.zze(zzah2.key).delete()) {
                    ((zzag)object).zzbu -= zzah2.zzbx;
                } else {
                    zzab.zzb("Could not delete cache entry for key=%s, filename=%s", zzah2.key, zzag.zzd(zzah2.key));
                }
                iterator.remove();
                ++n2;
                if (!((float)(((zzag)object).zzbu + (long)n) < (float)((zzag)object).zzbw * 0.9f)) continue;
            }
            if (zzab.DEBUG) {
                zzab.zza("pruned %d files, %d bytes, %d ms", n2, ((zzag)object).zzbu - l, SystemClock.elapsedRealtime() - l2);
            }
        }
        File file = this.zze(string2);
        try {
            object = file;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object));
            zzah zzah3 = new zzah(string2, zzc2);
            if (!zzah3.zza(bufferedOutputStream)) {
                bufferedOutputStream.close();
                zzab.zzb("Failed to write header for %s", file.getAbsolutePath());
                throw new IOException();
            }
            bufferedOutputStream.write(zzc2.data);
            bufferedOutputStream.close();
            this.zza(string2, zzah3);
            return;
        }
        catch (IOException iOException) {
            if (!file.delete()) {
                zzab.zzb("Could not clean up file %s", file.getAbsolutePath());
            }
            return;
        }
    }

    private final synchronized void remove(String string2) {
        boolean bl = this.zze(string2).delete();
        this.removeEntry(string2);
        if (!bl) {
            zzab.zzb("Could not delete cache entry for key=%s, filename=%s", string2, zzag.zzd(string2));
        }
    }

    private static String zzd(String string2) {
        int n = string2.length() / 2;
        String string3 = String.valueOf(String.valueOf(string2.substring(0, n).hashCode()));
        String string4 = String.valueOf(String.valueOf(string2.substring(n).hashCode()));
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    private final File zze(String string2) {
        return new File(this.zzbv, zzag.zzd(string2));
    }

    private final void zza(String string2, zzah zzah2) {
        if (!this.zzbt.containsKey(string2)) {
            this.zzbu += zzah2.zzbx;
        } else {
            zzah zzah3 = this.zzbt.get(string2);
            this.zzbu += zzah2.zzbx - zzah3.zzbx;
        }
        this.zzbt.put(string2, zzah2);
    }

    private final void removeEntry(String string2) {
        zzah zzah2 = this.zzbt.remove(string2);
        if (zzah2 != null) {
            this.zzbu -= zzah2.zzbx;
        }
    }

    private static byte[] zza(zzai zzai2, long l) throws IOException {
        long l2 = zzai2.zzn();
        if (l < 0L || l > l2 || (long)((int)l) != l) {
            throw new IOException(new StringBuilder(73).append("streamToBytes length=").append(l).append(", maxLength=").append(l2).toString());
        }
        byte[] byArray = new byte[(int)l];
        new DataInputStream(zzai2).readFully(byArray);
        return byArray;
    }

    private static InputStream zza(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private static int zza(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    static void zza(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >>> 24);
    }

    static int zzb(InputStream inputStream) throws IOException {
        return 0 | zzag.zza(inputStream) | zzag.zza(inputStream) << 8 | zzag.zza(inputStream) << 16 | zzag.zza(inputStream) << 24;
    }

    static void zza(OutputStream outputStream, long l) throws IOException {
        outputStream.write((byte)l);
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 32));
        outputStream.write((byte)(l >>> 40));
        outputStream.write((byte)(l >>> 48));
        outputStream.write((byte)(l >>> 56));
    }

    static long zzc(InputStream inputStream) throws IOException {
        return 0L | (long)zzag.zza(inputStream) & 0xFFL | ((long)zzag.zza(inputStream) & 0xFFL) << 8 | ((long)zzag.zza(inputStream) & 0xFFL) << 16 | ((long)zzag.zza(inputStream) & 0xFFL) << 24 | ((long)zzag.zza(inputStream) & 0xFFL) << 32 | ((long)zzag.zza(inputStream) & 0xFFL) << 40 | ((long)zzag.zza(inputStream) & 0xFFL) << 48 | ((long)zzag.zza(inputStream) & 0xFFL) << 56;
    }

    static void zza(OutputStream outputStream, String string2) throws IOException {
        byte[] byArray = string2.getBytes("UTF-8");
        zzag.zza(outputStream, (long)byArray.length);
        outputStream.write(byArray, 0, byArray.length);
    }

    static String zza(zzai zzai2) throws IOException {
        long l = zzag.zzc(zzai2);
        byte[] byArray = zzag.zza(zzai2, l);
        return new String(byArray, "UTF-8");
    }

    static Map<String, String> zzb(zzai zzai2) throws IOException {
        int n = zzag.zzb((InputStream)zzai2);
        HashMap<String, String> hashMap = n == 0 ? Collections.emptyMap() : new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            String string2 = zzag.zza(zzai2).intern();
            String string3 = zzag.zza(zzai2).intern();
            hashMap.put(string2, string3);
        }
        return hashMap;
    }
}

