/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfdd;
import com.google.android.gms.internal.zzfer;
import com.google.android.gms.internal.zzfeu;
import com.google.android.gms.internal.zzfev;
import com.google.android.gms.internal.zzffn;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfeq
extends zzfdd<Integer>
implements zzfeu,
zzffn,
RandomAccess {
    private static final zzfeq zzpcq = new zzfeq();
    private int[] zzpcr;
    private int size;

    public static zzfeq zzcvq() {
        return zzpcq;
    }

    zzfeq() {
        this(new int[10], 0);
    }

    private zzfeq(int[] nArray, int n) {
        this.zzpcr = nArray;
        this.size = n;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfeq)) {
            return super.equals(object);
        }
        zzfeq zzfeq2 = (zzfeq)object;
        if (this.size != zzfeq2.size) {
            return false;
        }
        int[] nArray = zzfeq2.zzpcr;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzpcr[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzpcr[i];
        }
        return n;
    }

    @Override
    public final zzfeu zzlj(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzfeq(Arrays.copyOf(this.zzpcr, n), this.size);
    }

    @Override
    public final int getInt(int n) {
        this.zzll(n);
        return this.zzpcr[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzlk(int n) {
        this.zzai(this.size, n);
    }

    private final void zzai(int n, int n2) {
        this.zzcti();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzlm(n));
        }
        if (this.size < this.zzpcr.length) {
            System.arraycopy(this.zzpcr, n, this.zzpcr, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzpcr, 0, nArray, 0, n);
            System.arraycopy(this.zzpcr, n, nArray, n + 1, this.size - n);
            this.zzpcr = nArray;
        }
        this.zzpcr[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzcti();
        zzfer.checkNotNull(collection);
        if (!(collection instanceof zzfeq)) {
            return super.addAll(collection);
        }
        zzfeq zzfeq2 = (zzfeq)collection;
        if (zzfeq2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfeq2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfeq2.size;
        if (n > this.zzpcr.length) {
            this.zzpcr = Arrays.copyOf(this.zzpcr, n);
        }
        System.arraycopy(zzfeq2.zzpcr, 0, this.zzpcr, this.size, zzfeq2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcti();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzpcr[i])) continue;
            System.arraycopy(this.zzpcr, i + 1, this.zzpcr, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzll(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzlm(n));
        }
    }

    private final String zzlm(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzfeq zzfeq2 = this;
        zzfeq2.zzcti();
        zzfeq2.zzll(n);
        int n4 = zzfeq2.zzpcr[n];
        zzfeq2.zzpcr[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfeq zzfeq2 = this;
        zzfeq2.zzcti();
        zzfeq2.zzll(n);
        int n2 = zzfeq2.zzpcr[n];
        System.arraycopy(zzfeq2.zzpcr, n + 1, zzfeq2.zzpcr, n, zzfeq2.size - n);
        --zzfeq2.size;
        ++zzfeq2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzai(n, n2);
    }

    @Override
    public final /* synthetic */ zzfev zzln(int n) {
        return this.zzlj(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzpcq.zzbim();
    }
}

