/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzg;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;

public final class Status
extends zzbfm
implements Result,
ReflectedParcelable {
    public static final Status zzfni = new Status(0);
    public static final Status zzfnj = new Status(14);
    public static final Status zzfnk = new Status(8);
    public static final Status zzfnl = new Status(15);
    public static final Status zzfnm = new Status(16);
    public static final Status zzfnn = new Status(17);
    private static Status zzfno = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzg();
    private int zzeck;
    private final int zzcd;
    @Nullable
    private final String zzfks;
    @Nullable
    private final PendingIntent zzeeo;

    Status(int n, int n2, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this.zzeck = n;
        this.zzcd = n2;
        this.zzfks = string2;
        this.zzeeo = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, @Nullable String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public final void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.zzeeo.getIntentSender(), n, null, 0, 0, 0);
    }

    @Nullable
    public final String getStatusMessage() {
        return this.zzfks;
    }

    public final boolean hasResolution() {
        return this.zzeeo != null;
    }

    public final boolean isSuccess() {
        return this.zzcd <= 0;
    }

    public final boolean isCanceled() {
        return this.zzcd == 16;
    }

    public final boolean isInterrupted() {
        return this.zzcd == 14;
    }

    public final int getStatusCode() {
        return this.zzcd;
    }

    public final PendingIntent getResolution() {
        return this.zzeeo;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzeck, this.zzcd, this.zzfks, this.zzeeo});
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.zzeck == status.zzeck && this.zzcd == status.zzcd && zzbg.equal(this.zzfks, status.zzfks) && zzbg.equal(this.zzeeo, status.zzeeo);
    }

    public final String zzagx() {
        if (this.zzfks != null) {
            return this.zzfks;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzcd);
    }

    public final String toString() {
        return zzbg.zzx(this).zzg("statusCode", this.zzagx()).zzg("resolution", this.zzeeo).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Status status = this;
        int n2 = zzbfp.zze(parcel2);
        zzbfp.zzc(parcel2, 1, status.getStatusCode());
        zzbfp.zza(parcel2, 2, status.getStatusMessage(), false);
        zzbfp.zza(parcel2, 3, (Parcelable)status.zzeeo, n, false);
        zzbfp.zzc(parcel2, 1000, status.zzeck);
        zzbfp.zzai(parcel2, n2);
    }

    @Override
    public final Status getStatus() {
        return this;
    }
}

