/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.internal.zzai;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class zzaj
implements ServiceConnection {
    private final Set<ServiceConnection> zzgaq;
    private int mState;
    private boolean zzgar;
    private IBinder zzfzf;
    private final zzah zzgas;
    private ComponentName mComponentName;
    private /* synthetic */ zzai zzgat;

    public zzaj(zzai zzai2, zzah zzah2) {
        this.zzgat = zzai2;
        this.zzgas = zzah2;
        this.zzgaq = new HashSet<ServiceConnection>();
        this.mState = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        HashMap hashMap = zzai.zza(this.zzgat);
        synchronized (hashMap) {
            zzai.zzb(this.zzgat).removeMessages(1, (Object)this.zzgas);
            this.zzfzf = iBinder;
            this.mComponentName = componentName;
            Iterator<ServiceConnection> iterator = this.zzgaq.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceConnected(componentName, iBinder);
            }
            this.mState = 1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceDisconnected(ComponentName componentName) {
        HashMap hashMap = zzai.zza(this.zzgat);
        synchronized (hashMap) {
            zzai.zzb(this.zzgat).removeMessages(1, (Object)this.zzgas);
            this.zzfzf = null;
            this.mComponentName = componentName;
            Iterator<ServiceConnection> iterator = this.zzgaq.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceDisconnected(componentName);
            }
            this.mState = 2;
            return;
        }
    }

    public final void zzgi(String string2) {
        this.mState = 3;
        this.zzgar = zzai.zzd(this.zzgat).zza(zzai.zzc(this.zzgat), string2, this.zzgas.zzall(), this, this.zzgas.zzalk());
        if (this.zzgar) {
            Message message = zzai.zzb(this.zzgat).obtainMessage(1, (Object)this.zzgas);
            zzai.zzb(this.zzgat).sendMessageDelayed(message, zzai.zze(this.zzgat));
            return;
        }
        this.mState = 2;
        try {
            zzai.zzd(this.zzgat);
            zzaj zzaj2 = this;
            Context context = zzai.zzc(this.zzgat);
            context.unbindService((ServiceConnection)zzaj2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public final void zzgj(String string2) {
        zzai.zzb(this.zzgat).removeMessages(1, (Object)this.zzgas);
        zzai.zzd(this.zzgat);
        zzaj zzaj2 = this;
        Context context = zzai.zzc(this.zzgat);
        context.unbindService((ServiceConnection)zzaj2);
        this.zzgar = false;
        this.mState = 2;
    }

    public final void zza(ServiceConnection serviceConnection, String string2) {
        zzai.zzd(this.zzgat);
        zzai.zzc(this.zzgat);
        this.zzgas.zzall();
        this.zzgaq.add(serviceConnection);
    }

    public final void zzb(ServiceConnection serviceConnection, String string2) {
        zzai.zzd(this.zzgat);
        zzai.zzc(this.zzgat);
        this.zzgaq.remove(serviceConnection);
    }

    public final boolean isBound() {
        return this.zzgar;
    }

    public final int getState() {
        return this.mState;
    }

    public final boolean zza(ServiceConnection serviceConnection) {
        return this.zzgaq.contains(serviceConnection);
    }

    public final boolean zzalm() {
        return this.zzgaq.isEmpty();
    }

    public final IBinder getBinder() {
        return this.zzfzf;
    }

    public final ComponentName getComponentName() {
        return this.mComponentName;
    }
}

