/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.zzg;
import com.google.android.gms.common.zzh;
import com.google.android.gms.common.zzi;
import com.google.android.gms.common.zzk;
import com.google.android.gms.common.zzp;
import com.google.android.gms.internal.zzbhf;

public class zzq {
    private static zzq zzflp;
    private final Context mContext;

    private zzq(Context context) {
        this.mContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzq zzci(Context context) {
        zzbq.checkNotNull(context);
        Class<zzq> clazz = zzq.class;
        synchronized (zzq.class) {
            if (zzflp == null) {
                zzg.zzcg(context);
                zzflp = new zzq(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzflp;
        }
    }

    public final boolean zzbq(int n) {
        String[] stringArray = zzbhf.zzdb(this.mContext).getPackagesForUid(n);
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray2[i];
            if (!this.zzfy(string2)) continue;
            return true;
        }
        return false;
    }

    private final boolean zzfy(String string2) {
        try {
            PackageInfo packageInfo;
            PackageInfo packageInfo2 = packageInfo = zzbhf.zzdb(this.mContext).getPackageInfo(string2, 64);
            zzq zzq2 = this;
            if (packageInfo2 == null) {
                return false;
            }
            if (zzp.zzch(zzq2.mContext)) {
                return zzq.zzb(packageInfo2, true);
            }
            boolean bl = zzq.zzb(packageInfo2, false);
            if (!bl && zzq.zzb(packageInfo2, true)) {
                Log.w((String)"GoogleSignatureVerifier", (String)"Test-keys aren't accepted on this build.");
            }
            return bl;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private static boolean zza(PackageInfo packageInfo, boolean bl) {
        return packageInfo != null && packageInfo.signatures != null && (bl ? zzq.zza(packageInfo, zzk.zzflf) : zzq.zza(packageInfo, zzk.zzflf[0])) != null;
    }

    public final boolean zza(PackageInfo packageInfo) {
        if (packageInfo == null) {
            return false;
        }
        if (zzq.zza(packageInfo, false)) {
            return true;
        }
        if (zzq.zza(packageInfo, true)) {
            if (zzp.zzch(this.mContext)) {
                return true;
            }
            Log.w((String)"GoogleSignatureVerifier", (String)"Test-keys aren't accepted on this build.");
        }
        return false;
    }

    private static boolean zzb(PackageInfo packageInfo, boolean bl) {
        if (packageInfo.signatures.length != 1) {
            Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
            return false;
        }
        zzi zzi2 = new zzi(packageInfo.signatures[0].toByteArray());
        String string2 = packageInfo.packageName;
        boolean bl2 = bl ? zzg.zzb(string2, zzi2) : zzg.zza(string2, zzi2);
        if (!bl2) {
            Log.d((String)"GoogleSignatureVerifier", (String)new StringBuilder(27).append("Cert not in list. atk=").append(bl).toString());
        }
        return bl2;
    }

    static zzh zza(PackageInfo packageInfo, zzh ... zzhArray) {
        if (packageInfo.signatures == null) {
            return null;
        }
        if (packageInfo.signatures.length != 1) {
            Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
            return null;
        }
        zzi zzi2 = new zzi(packageInfo.signatures[0].toByteArray());
        for (int i = 0; i < zzhArray.length; ++i) {
            if (!zzhArray[i].equals(zzi2)) continue;
            return zzhArray[i];
        }
        return null;
    }
}

