/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfeo;
import com.google.android.gms.internal.zzffz;
import com.google.android.gms.internal.zzfgc;
import com.google.android.gms.internal.zzfgd;
import com.google.android.gms.internal.zzfhl;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzffy
extends zzfeo<Integer>
implements zzfgc,
zzfhl,
RandomAccess {
    private static final zzffy zzphs = new zzffy();
    private int[] zzpht;
    private int size;

    public static zzffy zzcxz() {
        return zzphs;
    }

    zzffy() {
        this(new int[10], 0);
    }

    private zzffy(int[] nArray, int n) {
        this.zzpht = nArray;
        this.size = n;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzffy)) {
            return super.equals(object);
        }
        zzffy zzffy2 = (zzffy)object;
        if (this.size != zzffy2.size) {
            return false;
        }
        int[] nArray = zzffy2.zzpht;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzpht[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzpht[i];
        }
        return n;
    }

    @Override
    public final zzfgc zzlu(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzffy(Arrays.copyOf(this.zzpht, n), this.size);
    }

    @Override
    public final int getInt(int n) {
        this.zzlw(n);
        return this.zzpht[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzlv(int n) {
        this.zzai(this.size, n);
    }

    private final void zzai(int n, int n2) {
        this.zzcvj();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzlx(n));
        }
        if (this.size < this.zzpht.length) {
            System.arraycopy(this.zzpht, n, this.zzpht, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzpht, 0, nArray, 0, n);
            System.arraycopy(this.zzpht, n, nArray, n + 1, this.size - n);
            this.zzpht = nArray;
        }
        this.zzpht[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzcvj();
        zzffz.checkNotNull(collection);
        if (!(collection instanceof zzffy)) {
            return super.addAll(collection);
        }
        zzffy zzffy2 = (zzffy)collection;
        if (zzffy2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzffy2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzffy2.size;
        if (n > this.zzpht.length) {
            this.zzpht = Arrays.copyOf(this.zzpht, n);
        }
        System.arraycopy(zzffy2.zzpht, 0, this.zzpht, this.size, zzffy2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcvj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzpht[i])) continue;
            System.arraycopy(this.zzpht, i + 1, this.zzpht, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzlw(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzlx(n));
        }
    }

    private final String zzlx(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzffy zzffy2 = this;
        zzffy2.zzcvj();
        zzffy2.zzlw(n);
        int n4 = zzffy2.zzpht[n];
        zzffy2.zzpht[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzffy zzffy2 = this;
        zzffy2.zzcvj();
        zzffy2.zzlw(n);
        int n2 = zzffy2.zzpht[n];
        System.arraycopy(zzffy2.zzpht, n + 1, zzffy2.zzpht, n, zzffy2.size - n);
        --zzffy2.size;
        ++zzffy2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzai(n, n2);
    }

    @Override
    public final /* synthetic */ zzfgd zzly(int n) {
        return this.zzlu(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzphs.zzbiy();
    }
}

