/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.internal.zzan;
import com.google.android.gms.common.internal.zzay;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zzf;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzd<T extends IInterface> {
    private int zzfyd;
    private long zzfye;
    private long zzfyf;
    private int zzfyg;
    private long zzfyh;
    private zzam zzfyi;
    private final Context mContext;
    private final Looper zzall;
    private final zzag zzfyj;
    private final zzf zzfqc;
    final Handler mHandler;
    private final Object mLock = new Object();
    private final Object zzfyk = new Object();
    private zzay zzfyl;
    protected zzj zzfym;
    private T zzfyn;
    private final ArrayList<zzi<?>> zzfyo = new ArrayList();
    private zzl zzfyp;
    private int zzfyq = 1;
    private final com.google.android.gms.common.internal.zzf zzfyr;
    private final zzg zzfys;
    private final int zzfyt;
    private final String zzfyu;
    private ConnectionResult zzfyv = null;
    private boolean zzfyw = false;
    protected AtomicInteger zzfyx = new AtomicInteger(0);
    private static String[] zzfyy = new String[]{"service_esmobile", "service_googleme"};

    protected zzd(Context context, Looper looper, int n, com.google.android.gms.common.internal.zzf zzf2, zzg zzg2, String string2) {
        this(context, looper, zzag.zzco(context), zzf.zzafy(), n, zzbq.checkNotNull(zzf2), zzbq.checkNotNull(zzg2), null);
    }

    protected zzd(Context context, Looper looper, zzag zzag2, zzf zzf2, int n, com.google.android.gms.common.internal.zzf zzf3, zzg zzg2, String string2) {
        this.mContext = zzbq.checkNotNull(context, "Context must not be null");
        this.zzall = zzbq.checkNotNull(looper, "Looper must not be null");
        this.zzfyj = zzbq.checkNotNull(zzag2, "Supervisor must not be null");
        this.zzfqc = zzbq.checkNotNull(zzf2, "API availability must not be null");
        this.mHandler = new zzh(this, looper);
        this.zzfyt = n;
        this.zzfyr = zzf3;
        this.zzfys = zzg2;
        this.zzfyu = string2;
    }

    @NonNull
    protected abstract String zzhi();

    protected String zzakh() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zzhj();

    @Nullable
    private final String zzaki() {
        if (this.zzfyu == null) {
            return this.mContext.getClass().getName();
        }
        return this.zzfyu;
    }

    @Nullable
    protected abstract T zzd(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.zzfyf = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionSuspended(int n) {
        this.zzfyd = n;
        this.zzfye = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzfyg = connectionResult.getErrorCode();
        this.zzfyh = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, T t) {
        zzbq.checkArgument(n == 4 == (t != null));
        Object object = this.mLock;
        synchronized (object) {
            this.zzfyq = n;
            this.zzfyn = t;
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    zzd zzd2 = this;
                    if (zzd2.zzfyp != null && zzd2.zzfyi != null) {
                        String string3 = zzd2.zzfyi.zzalo();
                        string2 = zzd2.zzfyi.getPackageName();
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        zzd2.zzfyj.zza(zzd2.zzfyi.zzalo(), zzd2.zzfyi.getPackageName(), zzd2.zzfyi.zzalk(), zzd2.zzfyp, zzd2.zzaki());
                        zzd2.zzfyx.incrementAndGet();
                    }
                    zzd2.zzfyp = new zzl(zzd2, zzd2.zzfyx.get());
                    zzd zzd3 = zzd2;
                    zzd2.zzfyi = new zzam(zzd3.zzakh(), zzd3.zzhi(), false, 129);
                    String string4 = zzd2.zzaki();
                    zzl zzl2 = zzd2.zzfyp;
                    int n2 = zzd2.zzfyi.zzalk();
                    String string5 = zzd2.zzfyi.getPackageName();
                    String string6 = zzd2.zzfyi.zzalo();
                    if (zzd2.zzfyj.zza(new zzah(string6, string5, n2), (ServiceConnection)zzl2, string4)) break;
                    string2 = zzd2.zzfyi.zzalo();
                    String string7 = zzd2.zzfyi.getPackageName();
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string7).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string7).toString());
                    zzd2.zza(16, null, zzd2.zzfyx.get());
                    break;
                }
                case 4: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    zzd zzd4 = this;
                    if (zzd4.zzfyp == null) break;
                    zzd4.zzfyj.zza(zzd4.zzhi(), zzd4.zzakh(), 129, zzd4.zzfyp, zzd4.zzaki());
                    zzd4.zzfyp = null;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzfyq != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    public final void zzakj() {
        int n = this.zzfqc.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zza(1, null);
            this.zza(new zzm(this), n, null);
            return;
        }
        this.zza(new zzm(this));
    }

    public void zza(@NonNull zzj zzj2) {
        this.zzfym = zzbq.checkNotNull(zzj2, "Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzfyq == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnecting() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzfyq == 2 || this.zzfyq == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzakk() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzfyq == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.zzfyx.incrementAndGet();
        Object object = this.zzfyo;
        synchronized (object) {
            int n = this.zzfyo.size();
            for (int i = 0; i < n; ++i) {
                this.zzfyo.get(i).removeListener();
            }
            this.zzfyo.clear();
        }
        object = this.zzfyk;
        synchronized (object) {
            this.zzfyl = null;
        }
        this.zza(1, null);
    }

    public final void zzce(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, this.zzfyx.get(), n));
    }

    private final void zzcf(int n) {
        int n2;
        if (this.zzakk()) {
            n2 = 5;
            this.zzfyw = true;
        } else {
            n2 = 4;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(n2, this.zzfyx.get(), 16));
    }

    protected final void zza(@NonNull zzj zzj2, int n, @Nullable PendingIntent pendingIntent) {
        this.zzfym = zzbq.checkNotNull(zzj2, "Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzfyx.get(), n, (Object)pendingIntent));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzall;
    }

    public Account getAccount() {
        return null;
    }

    public zzc[] zzakl() {
        return new zzc[0];
    }

    protected Bundle zzaap() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzn(this, n, iBinder, bundle)));
    }

    protected final void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n2, -1, (Object)new zzo(this, n, null)));
    }

    protected final void zzakm() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzafi() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzakn() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzfyq == 5) {
                throw new DeadObjectException();
            }
            this.zzakm();
            zzbq.zza(this.zzfyn != null, (Object)"Client is connected but service is null");
            return this.zzfyn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(zzan zzan2, Set<Scope> set) {
        Bundle bundle = this.zzaap();
        Object object = this.mContext.getPackageName();
        Object object2 = new zzz(this.zzfyt);
        new zzz(this.zzfyt).zzfzt = object;
        object = bundle;
        v0.zzfzw = object;
        zzz zzz2 = object2;
        if (set != null) {
            object = set;
            zzz2.zzfzv = object.toArray(new Scope[object.size()]);
        }
        if (this.zzaay()) {
            object2 = this;
            object = ((zzd)object2).getAccount() != null ? ((zzd)object2).getAccount() : new Account("<<default account>>", "com.google");
            object2 = zzz2;
            zzz2.zzfzx = object;
            object = zzan2;
            if (object != null) {
                ((zzz)object2).zzfzu = object.asBinder();
            }
        } else if (this.zzako()) {
            zzz2.zzfzx = object = this.getAccount();
        }
        object = this.zzakl();
        zzz2.zzfzy = object;
        try {
            Object object3 = this.zzfyk;
            synchronized (object3) {
                if (this.zzfyl != null) {
                    this.zzfyl.zza(new zzk(this, this.zzfyx.get()), zzz2);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.zzce(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.zza(8, null, null, this.zzfyx.get());
            return;
        }
    }

    public boolean zzaay() {
        return false;
    }

    public void zza(@NonNull zzp zzp2) {
        zzp2.zzajf();
    }

    public boolean zzako() {
        return false;
    }

    public boolean zzagg() {
        return true;
    }

    public boolean zzabj() {
        return false;
    }

    public Intent getSignInIntent() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzakp() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        zzay zzay2;
        T t;
        int n;
        Object object = this.mLock;
        synchronized (object) {
            n = this.zzfyq;
            t = this.zzfyn;
        }
        object = this.zzfyk;
        synchronized (object) {
            zzay2 = this.zzfyl;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.zzhj()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (zzay2 == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(zzay2.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzfyf > 0L) {
            l = this.zzfyf;
            string3 = ((DateFormat)object).format(new Date(this.zzfyf));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzfye > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzfyd) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzfyd));
                }
            }
            l = this.zzfye;
            string3 = ((DateFormat)object).format(new Date(this.zzfye));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzfyh > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzfyg));
            l = this.zzfyh;
            string3 = ((DateFormat)object).format(new Date(this.zzfyh));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IBinder zzagh() {
        Object object = this.zzfyk;
        synchronized (object) {
            if (this.zzfyl == null) {
                return null;
            }
            return this.zzfyl.asBinder();
        }
    }

    private final boolean zzakq() {
        if (this.zzfyw) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzhj())) {
            return false;
        }
        if (TextUtils.isEmpty(null)) {
            return false;
        }
        try {
            Class.forName(this.zzhj());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public final String zzagi() {
        if (this.isConnected() && this.zzfyi != null) {
            return this.zzfyi.getPackageName();
        }
        throw new RuntimeException("Failed to connect when checking package");
    }

    static /* synthetic */ void zza(zzd zzd2, int n) {
        zzd2.zzcf(16);
    }

    static /* synthetic */ Object zza(zzd zzd2) {
        return zzd2.zzfyk;
    }

    static /* synthetic */ zzay zza(zzd zzd2, zzay zzay2) {
        zzd2.zzfyl = zzay2;
        return zzd2.zzfyl;
    }

    static /* synthetic */ ConnectionResult zza(zzd zzd2, ConnectionResult connectionResult) {
        zzd2.zzfyv = connectionResult;
        return zzd2.zzfyv;
    }

    static /* synthetic */ boolean zzb(zzd zzd2) {
        return zzd2.zzakq();
    }

    static /* synthetic */ boolean zzc(zzd zzd2) {
        return zzd2.zzfyw;
    }

    static /* synthetic */ void zza(zzd zzd2, int n, IInterface iInterface) {
        zzd2.zza(n, null);
    }

    static /* synthetic */ ConnectionResult zzd(zzd zzd2) {
        return zzd2.zzfyv;
    }

    static /* synthetic */ com.google.android.gms.common.internal.zzf zze(zzd zzd2) {
        return zzd2.zzfyr;
    }

    static /* synthetic */ boolean zza(zzd zzd2, int n, int n2, IInterface iInterface) {
        return zzd2.zza(n, n2, iInterface);
    }

    static /* synthetic */ ArrayList zzf(zzd zzd2) {
        return zzd2.zzfyo;
    }

    static /* synthetic */ zzg zzg(zzd zzd2) {
        return zzd2.zzfys;
    }
}

