/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfer;
import com.google.android.gms.internal.zzfes;
import com.google.android.gms.internal.zzffh;
import com.google.android.gms.internal.zzffi;
import com.google.android.gms.internal.zzffz;
import com.google.android.gms.internal.zzfgk;
import com.google.android.gms.internal.zzfhe;
import com.google.android.gms.internal.zzfiq;
import com.google.android.gms.internal.zzfis;
import com.google.android.gms.internal.zzfiv;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzffg
extends zzfer {
    private static final Logger logger = Logger.getLogger(zzffg.class.getName());
    private static final boolean zzpfz = zzfiq.zzczx();
    zzffi zzpga;

    static int zzlb(int n) {
        if (n > 4096) {
            return 4096;
        }
        return n;
    }

    public static zzffg zzb(OutputStream outputStream, int n) {
        return new zzd(outputStream, n);
    }

    public static zzffg zzbc(byte[] byArray) {
        return zzffg.zzh(byArray, 0, byArray.length);
    }

    public static zzffg zzh(byte[] byArray, int n, int n2) {
        return new zzb(byArray, n, n2);
    }

    private zzffg() {
    }

    public abstract void zzz(int var1, int var2) throws IOException;

    public abstract void zzaa(int var1, int var2) throws IOException;

    public abstract void zzab(int var1, int var2) throws IOException;

    public abstract void zzac(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public abstract void zzb(int var1, long var2) throws IOException;

    public final void zza(int n, double d) throws IOException {
        this.zzb(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzl(int var1, boolean var2) throws IOException;

    public abstract void zzn(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzfes var2) throws IOException;

    public abstract void zza(int var1, zzfhe var2) throws IOException;

    public abstract void zzb(int var1, zzfhe var2) throws IOException;

    public abstract void zzb(int var1, zzfes var2) throws IOException;

    public abstract void zzlc(int var1) throws IOException;

    public abstract void zzld(int var1) throws IOException;

    public final void zzle(int n) throws IOException {
        this.zzld(zzffg.zzlo(n));
    }

    public abstract void zzlf(int var1) throws IOException;

    public abstract void zzct(long var1) throws IOException;

    public final void zzcu(long l) throws IOException {
        this.zzct(zzffg.zzdb(l));
    }

    public abstract void zzcv(long var1) throws IOException;

    public final void zzf(float f) throws IOException {
        this.zzlf(Float.floatToRawIntBits(f));
    }

    public final void zzn(double d) throws IOException {
        this.zzcv(Double.doubleToRawLongBits(d));
    }

    public final void zzdd(boolean bl) throws IOException {
        this.zzb((byte)(bl ? 1 : 0));
    }

    public abstract void zzts(String var1) throws IOException;

    public abstract void zzay(zzfes var1) throws IOException;

    public abstract void zze(zzfhe var1) throws IOException;

    public abstract void zzb(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzad(int n, int n2) {
        return zzffg.zzlg(n) + zzffg.zzlh(n2);
    }

    public static int zzae(int n, int n2) {
        return zzffg.zzlg(n) + zzffg.zzli(n2);
    }

    public static int zzaf(int n, int n2) {
        return zzffg.zzlg(n) + 4;
    }

    public static int zzc(int n, long l) {
        return zzffg.zzlg(n) + zzffg.zzcx(l);
    }

    public static int zzd(int n, long l) {
        return zzffg.zzlg(n) + zzffg.zzcx(l);
    }

    public static int zze(int n, long l) {
        return zzffg.zzlg(n) + 8;
    }

    public static int zzb(int n, double d) {
        return zzffg.zzlg(n) + 8;
    }

    public static int zzm(int n, boolean bl) {
        return zzffg.zzlg(n) + 1;
    }

    public static int zzag(int n, int n2) {
        return zzffg.zzlg(n) + zzffg.zzlh(n2);
    }

    public static int zzo(int n, String string2) {
        return zzffg.zzlg(n) + zzffg.zztt(string2);
    }

    public static int zzc(int n, zzfes zzfes2) {
        int n2 = zzfes2.size();
        return zzffg.zzlg(n) + (zzffg.zzli(n2) + n2);
    }

    public static int zza(int n, zzfgk zzfgk2) {
        int n2 = zzfgk2.zzho();
        return zzffg.zzlg(n) + (zzffg.zzli(n2) + n2);
    }

    public static int zzc(int n, zzfhe zzfhe2) {
        return zzffg.zzlg(n) + zzffg.zzf(zzfhe2);
    }

    public static int zzd(int n, zzfhe zzfhe2) {
        return (zzffg.zzlg(1) << 1) + zzffg.zzae(2, n) + zzffg.zzc(3, zzfhe2);
    }

    public static int zzd(int n, zzfes zzfes2) {
        return (zzffg.zzlg(1) << 1) + zzffg.zzae(2, n) + zzffg.zzc(3, zzfes2);
    }

    public static int zzb(int n, zzfgk zzfgk2) {
        return (zzffg.zzlg(1) << 1) + zzffg.zzae(2, n) + zzffg.zza(3, zzfgk2);
    }

    public static int zzlg(int n) {
        return zzffg.zzli(n << 3);
    }

    public static int zzlh(int n) {
        if (n >= 0) {
            return zzffg.zzli(n);
        }
        return 10;
    }

    public static int zzli(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzlj(int n) {
        return zzffg.zzli(zzffg.zzlo(n));
    }

    public static int zzlk(int n) {
        return 4;
    }

    public static int zzll(int n) {
        return 4;
    }

    public static int zzcw(long l) {
        return zzffg.zzcx(l);
    }

    public static int zzcx(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzcy(long l) {
        return zzffg.zzcx(zzffg.zzdb(l));
    }

    public static int zzcz(long l) {
        return 8;
    }

    public static int zzda(long l) {
        return 8;
    }

    public static int zzg(float f) {
        return 4;
    }

    public static int zzo(double d) {
        return 8;
    }

    public static int zzde(boolean bl) {
        return 1;
    }

    public static int zzlm(int n) {
        return zzffg.zzlh(n);
    }

    public static int zztt(String string2) {
        int n;
        try {
            n = zzfis.zzd(string2);
        }
        catch (zzfiv zzfiv2) {
            n = string2.getBytes(zzffz.UTF_8).length;
        }
        int n2 = n;
        return zzffg.zzli(n2) + n2;
    }

    public static int zza(zzfgk zzfgk2) {
        int n = zzfgk2.zzho();
        return zzffg.zzli(n) + n;
    }

    public static int zzaz(zzfes zzfes2) {
        int n = zzfes2.size();
        return zzffg.zzli(n) + n;
    }

    public static int zzbd(byte[] byArray) {
        int n = byArray.length;
        return zzffg.zzli(n) + n;
    }

    public static int zzf(zzfhe zzfhe2) {
        int n = zzfhe2.zzho();
        return zzffg.zzli(n) + n;
    }

    static int zzln(int n) {
        return zzffg.zzli(n) + n;
    }

    private static int zzlo(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzdb(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzcws();

    public final void zzcwt() {
        if (this.zzcws() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    abstract void zzi(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string2, zzfiv zzfiv2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzfiv2);
        byte[] byArray = string2.getBytes(zzffz.UTF_8);
        try {
            this.zzld(byArray.length);
            this.zzd(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    public final void zze(int n, zzfhe zzfhe2) throws IOException {
        this.zzz(n, 3);
        zzfhe zzfhe3 = zzfhe2;
        zzffg zzffg2 = this;
        zzfhe3.zza(zzffg2);
        this.zzz(n, 4);
    }

    @Deprecated
    public static int zzg(zzfhe zzfhe2) {
        return zzfhe2.zzho();
    }

    @Deprecated
    public static int zzlp(int n) {
        return zzffg.zzli(n);
    }

    /* synthetic */ zzffg(zzffh zzffh2) {
        this();
    }

    static final class zzd
    extends zza {
        private final OutputStream out;

        zzd(OutputStream outputStream, int n) {
            super(n);
            if (outputStream == null) {
                throw new NullPointerException("out");
            }
            this.out = outputStream;
        }

        @Override
        public final void zzz(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzffg)this).zzld(n << 3 | n3);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            this.zzls(20);
            this.zzah(n, 0);
            int n3 = n2;
            zzd zzd2 = this;
            if (n3 >= 0) {
                zzd2.zzlq(n3);
                return;
            }
            zzd2.zzdc(n3);
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            this.zzls(20);
            this.zzah(n, 0);
            this.zzlq(n2);
        }

        @Override
        public final void zzac(int n, int n2) throws IOException {
            this.zzls(14);
            this.zzah(n, 5);
            this.zzlr(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            this.zzls(20);
            this.zzah(n, 0);
            this.zzdc(l);
        }

        @Override
        public final void zzb(int n, long l) throws IOException {
            this.zzls(18);
            this.zzah(n, 1);
            this.zzdd(l);
        }

        @Override
        public final void zzl(int n, boolean bl) throws IOException {
            this.zzls(11);
            this.zzah(n, 0);
            this.zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzn(int n, String string2) throws IOException {
            ((zzffg)this).zzz(n, 2);
            ((zzffg)this).zzts(string2);
        }

        @Override
        public final void zza(int n, zzfes zzfes2) throws IOException {
            ((zzffg)this).zzz(n, 2);
            ((zzffg)this).zzay(zzfes2);
        }

        @Override
        public final void zzay(zzfes zzfes2) throws IOException {
            ((zzffg)this).zzld(zzfes2.size());
            zzfes2.zza(this);
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzffg)this).zzld(n2);
            ((zzffg)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzfhe zzfhe2) throws IOException {
            ((zzffg)this).zzz(n, 2);
            ((zzffg)this).zze(zzfhe2);
        }

        @Override
        public final void zzb(int n, zzfhe zzfhe2) throws IOException {
            ((zzffg)this).zzz(1, 3);
            ((zzffg)this).zzab(2, n);
            ((zzffg)this).zza(3, zzfhe2);
            ((zzffg)this).zzz(1, 4);
        }

        @Override
        public final void zzb(int n, zzfes zzfes2) throws IOException {
            ((zzffg)this).zzz(1, 3);
            ((zzffg)this).zzab(2, n);
            ((zzffg)this).zza(3, zzfes2);
            ((zzffg)this).zzz(1, 4);
        }

        @Override
        public final void zze(zzfhe zzfhe2) throws IOException {
            ((zzffg)this).zzld(zzfhe2.zzho());
            zzfhe2.zza(this);
        }

        @Override
        public final void zzb(byte by) throws IOException {
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.zzc(by);
        }

        @Override
        public final void zzlc(int n) throws IOException {
            if (n >= 0) {
                ((zzffg)this).zzld(n);
                return;
            }
            ((zzffg)this).zzct(n);
        }

        @Override
        public final void zzld(int n) throws IOException {
            this.zzls(10);
            this.zzlq(n);
        }

        @Override
        public final void zzlf(int n) throws IOException {
            this.zzls(4);
            this.zzlr(n);
        }

        @Override
        public final void zzct(long l) throws IOException {
            this.zzls(10);
            this.zzdc(l);
        }

        @Override
        public final void zzcv(long l) throws IOException {
            this.zzls(8);
            this.zzdd(l);
        }

        @Override
        public final void zzts(String string2) throws IOException {
            try {
                int n = string2.length() * 3;
                int n2 = zzd.zzli(n);
                if (n2 + n > this.limit) {
                    byte[] byArray = new byte[n];
                    int n3 = zzfis.zza(string2, byArray, 0, n);
                    ((zzffg)this).zzld(n3);
                    ((zzfer)this).zzd(byArray, 0, n3);
                    return;
                }
                if (n2 + n > this.limit - this.position) {
                    this.doFlush();
                }
                int n4 = zzd.zzli(string2.length());
                int n5 = this.position;
                try {
                    int n6;
                    if (n4 == n2) {
                        this.position = n5 + n4;
                        int n7 = zzfis.zza(string2, this.buffer, this.position, this.limit - this.position);
                        this.position = n5;
                        n6 = n7 - n5 - n4;
                        this.zzlq(n6);
                        this.position = n7;
                    } else {
                        n6 = zzfis.zzd(string2);
                        this.zzlq(n6);
                        this.position = zzfis.zza(string2, this.buffer, this.position, n6);
                    }
                    this.zzpgb += n6;
                    return;
                }
                catch (zzfiv zzfiv2) {
                    this.zzpgb -= this.position - n5;
                    this.position = n5;
                    throw zzfiv2;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new zzc(arrayIndexOutOfBoundsException);
                }
            }
            catch (zzfiv zzfiv3) {
                this.zza(string2, zzfiv3);
                return;
            }
        }

        @Override
        public final void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.limit - this.position >= n2) {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
            } else {
                int n3 = this.limit - this.position;
                System.arraycopy(byArray, n, this.buffer, this.position, n3);
                n += n3;
                this.position = this.limit;
                this.zzpgb += n3;
                this.doFlush();
                if ((n2 -= n3) <= this.limit) {
                    System.arraycopy(byArray, n, this.buffer, 0, n2);
                    this.position = n2;
                } else {
                    this.out.write(byArray, n, n2);
                }
            }
            this.zzpgb += n2;
        }

        @Override
        public final void zzd(byte[] byArray, int n, int n2) throws IOException {
            ((zzffg)this).write(byArray, n, n2);
        }

        private final void zzls(int n) throws IOException {
            if (this.limit - this.position < n) {
                this.doFlush();
            }
        }

        private final void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    static abstract class zza
    extends zzffg {
        final byte[] buffer;
        final int limit;
        int position;
        int zzpgb;

        zza(int n) {
            super(null);
            if (n < 0) {
                throw new IllegalArgumentException("bufferSize must be >= 0");
            }
            this.buffer = new byte[Math.max(n, 20)];
            this.limit = this.buffer.length;
        }

        @Override
        public final int zzcws() {
            throw new UnsupportedOperationException("spaceLeft() can only be called on CodedOutputStreams that are writing to a flat array or ByteBuffer.");
        }

        final void zzc(byte by) {
            this.buffer[this.position++] = by;
            ++this.zzpgb;
        }

        final void zzah(int n, int n2) {
            int n3 = n2;
            this.zzlq(n << 3 | n3);
        }

        final void zzlq(int n) {
            if (zzpfz) {
                long l = this.position;
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) break;
                    zzfiq.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
                zzfiq.zza(this.buffer, (long)this.position++, (byte)n);
                int n2 = (int)((long)this.position - l);
                this.zzpgb += n2;
                return;
            }
            while (true) {
                if ((n & 0xFFFFFF80) == 0) {
                    this.buffer[this.position++] = (byte)n;
                    ++this.zzpgb;
                    return;
                }
                this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                ++this.zzpgb;
                n >>>= 7;
            }
        }

        final void zzdc(long l) {
            if (zzpfz) {
                long l2 = this.position;
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) break;
                    zzfiq.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
                zzfiq.zza(this.buffer, (long)this.position++, (byte)l);
                int n = (int)((long)this.position - l2);
                this.zzpgb += n;
                return;
            }
            while (true) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    this.buffer[this.position++] = (byte)l;
                    ++this.zzpgb;
                    return;
                }
                this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                ++this.zzpgb;
                l >>>= 7;
            }
        }

        final void zzlr(int n) {
            this.buffer[this.position++] = (byte)n;
            this.buffer[this.position++] = (byte)(n >> 8);
            this.buffer[this.position++] = (byte)(n >> 16);
            this.buffer[this.position++] = n >> 24;
            this.zzpgb += 4;
        }

        final void zzdd(long l) {
            this.buffer[this.position++] = (byte)(l & 0xFFL);
            this.buffer[this.position++] = (byte)(l >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(l >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(l >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)(l >> 32);
            this.buffer[this.position++] = (byte)(l >> 40);
            this.buffer[this.position++] = (byte)(l >> 48);
            this.buffer[this.position++] = (byte)(l >> 56);
            this.zzpgb += 8;
        }
    }

    static class zzb
    extends zzffg {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zzb(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzz(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzffg)this).zzld(n << 3 | n3);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            ((zzffg)this).zzz(n, 0);
            ((zzffg)this).zzlc(n2);
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            ((zzffg)this).zzz(n, 0);
            ((zzffg)this).zzld(n2);
        }

        @Override
        public final void zzac(int n, int n2) throws IOException {
            ((zzffg)this).zzz(n, 5);
            ((zzffg)this).zzlf(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzffg)this).zzz(n, 0);
            ((zzffg)this).zzct(l);
        }

        @Override
        public final void zzb(int n, long l) throws IOException {
            ((zzffg)this).zzz(n, 1);
            ((zzffg)this).zzcv(l);
        }

        @Override
        public final void zzl(int n, boolean bl) throws IOException {
            ((zzffg)this).zzz(n, 0);
            ((zzffg)this).zzb((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzn(int n, String string2) throws IOException {
            ((zzffg)this).zzz(n, 2);
            ((zzffg)this).zzts(string2);
        }

        @Override
        public final void zza(int n, zzfes zzfes2) throws IOException {
            ((zzffg)this).zzz(n, 2);
            ((zzffg)this).zzay(zzfes2);
        }

        @Override
        public final void zzay(zzfes zzfes2) throws IOException {
            ((zzffg)this).zzld(zzfes2.size());
            zzfes2.zza(this);
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzffg)this).zzld(n2);
            ((zzffg)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzfhe zzfhe2) throws IOException {
            ((zzffg)this).zzz(n, 2);
            ((zzffg)this).zze(zzfhe2);
        }

        @Override
        public final void zzb(int n, zzfhe zzfhe2) throws IOException {
            ((zzffg)this).zzz(1, 3);
            ((zzffg)this).zzab(2, n);
            ((zzffg)this).zza(3, zzfhe2);
            ((zzffg)this).zzz(1, 4);
        }

        @Override
        public final void zzb(int n, zzfes zzfes2) throws IOException {
            ((zzffg)this).zzz(1, 3);
            ((zzffg)this).zzab(2, n);
            ((zzffg)this).zza(3, zzfes2);
            ((zzffg)this).zzz(1, 4);
        }

        @Override
        public final void zze(zzfhe zzfhe2) throws IOException {
            ((zzffg)this).zzld(zzfhe2.zzho());
            zzfhe2.zza(this);
        }

        @Override
        public final void zzb(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzlc(int n) throws IOException {
            if (n >= 0) {
                ((zzffg)this).zzld(n);
                return;
            }
            ((zzffg)this).zzct(n);
        }

        @Override
        public final void zzld(int n) throws IOException {
            if (zzpfz && ((zzffg)this).zzcws() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzfiq.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzfiq.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzlf(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = n >> 24;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzct(long l) throws IOException {
            if (zzpfz && ((zzffg)this).zzcws() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzfiq.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzfiq.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzcv(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzd(byte[] byArray, int n, int n2) throws IOException {
            ((zzffg)this).write(byArray, n, n2);
        }

        @Override
        public final void zzts(String string2) throws IOException {
            int n = this.position;
            try {
                int n2 = zzb.zzli(string2.length() * 3);
                int n3 = zzb.zzli(string2.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzfis.zza(string2, this.buffer, this.position, ((zzffg)this).zzcws());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzffg)this).zzld(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzfis.zzd(string2);
                ((zzffg)this).zzld(n6);
                this.position = zzfis.zza(string2, this.buffer, this.position, ((zzffg)this).zzcws());
                return;
            }
            catch (zzfiv zzfiv2) {
                this.position = n;
                this.zza(string2, zzfiv2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzcws() {
            return this.limit - this.position;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string2, Throwable throwable) {
            String string3 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string4 = String.valueOf(string2);
            super(string4.length() != 0 ? string3.concat(string4) : new String(string3), throwable);
        }
    }
}

