/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzch;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class zzcg
extends Fragment
implements zzcf {
    private static WeakHashMap<Activity, WeakReference<zzcg>> zza = new WeakHashMap();
    private Map<String, LifecycleCallback> zzb = new ArrayMap();
    private int zzc = 0;
    private Bundle zzd;

    public static zzcg zza(Activity activity) {
        zzcg zzcg2;
        WeakReference<zzcg> weakReference = zza.get(activity);
        if (weakReference != null && (zzcg2 = (zzcg)weakReference.get()) != null) {
            return zzcg2;
        }
        try {
            zzcg2 = (zzcg)activity.getFragmentManager().findFragmentByTag("LifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag LifecycleFragmentImpl is not a LifecycleFragmentImpl", classCastException);
        }
        if (zzcg2 == null || zzcg2.isRemoving()) {
            zzcg2 = new zzcg();
            activity.getFragmentManager().beginTransaction().add((Fragment)zzcg2, "LifecycleFragmentImpl").commitAllowingStateLoss();
        }
        zza.put(activity, new WeakReference<zzcg>(zzcg2));
        return zzcg2;
    }

    @Override
    public final <T extends LifecycleCallback> T zza(String string2, Class<T> clazz) {
        return (T)((LifecycleCallback)clazz.cast(this.zzb.get(string2)));
    }

    @Override
    public final void zza(String string2, @NonNull LifecycleCallback lifecycleCallback) {
        if (!this.zzb.containsKey(string2)) {
            this.zzb.put(string2, lifecycleCallback);
            LifecycleCallback lifecycleCallback2 = lifecycleCallback;
            String string3 = string2;
            zzcg zzcg2 = this;
            if (zzcg2.zzc > 0) {
                new Handler(Looper.getMainLooper()).post((Runnable)new zzch(zzcg2, lifecycleCallback2, string3));
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
    }

    @Override
    public final Activity zza() {
        return this.getActivity();
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzc = 1;
        this.zzd = bundle;
        for (Map.Entry<String, LifecycleCallback> entry : this.zzb.entrySet()) {
            entry.getValue().zza(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public final void onStart() {
        super.onStart();
        this.zzc = 2;
        Iterator<LifecycleCallback> iterator = this.zzb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().zza();
        }
    }

    public final void onResume() {
        super.onResume();
        this.zzc = 3;
        Iterator<LifecycleCallback> iterator = this.zzb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().zze();
        }
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        Iterator<LifecycleCallback> iterator = this.zzb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(n, n2, intent);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, LifecycleCallback> entry : this.zzb.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().zzb(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public final void onStop() {
        super.onStop();
        this.zzc = 4;
        Iterator<LifecycleCallback> iterator = this.zzb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().zzb();
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.zzc = 5;
        Iterator<LifecycleCallback> iterator = this.zzb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().zzh();
        }
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        Iterator<LifecycleCallback> iterator = this.zzb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ int zza(zzcg zzcg2) {
        return zzcg2.zzc;
    }

    static /* synthetic */ Bundle zzb(zzcg zzcg2) {
        return zzcg2.zzd;
    }
}

