/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfll;
import com.google.android.gms.internal.zzfls;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzflk {
    private final ByteBuffer zza;

    private zzflk(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzflk(ByteBuffer byteBuffer) {
        this.zza = byteBuffer;
        this.zza.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzflk zza(byte[] byArray) {
        return zzflk.zza(byArray, 0, byArray.length);
    }

    public static zzflk zza(byte[] byArray, int n, int n2) {
        return new zzflk(byArray, 0, n2);
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, 1);
        double d2 = d;
        this.zzc(Double.doubleToLongBits(d2));
    }

    public final void zza(int n, float f) throws IOException {
        this.zzc(n, 5);
        float f2 = f;
        int n2 = Float.floatToIntBits(f2);
        zzflk zzflk2 = this;
        if (zzflk2.zza.remaining() < 4) {
            throw new zzfll(zzflk2.zza.position(), zzflk2.zza.limit());
        }
        zzflk2.zza.putInt(n2);
    }

    public final void zza(int n, long l) throws IOException {
        this.zzc(n, 0);
        long l2 = l;
        this.zzb(l2);
    }

    public final void zzb(int n, long l) throws IOException {
        this.zzc(n, 0);
        long l2 = l;
        this.zzb(l2);
    }

    public final void zza(int n, int n2) throws IOException {
        this.zzc(n, 0);
        int n3 = n2;
        zzflk zzflk2 = this;
        if (n3 >= 0) {
            zzflk2.zzc(n3);
            return;
        }
        zzflk2.zzb(n3);
    }

    public final void zzc(int n, long l) throws IOException {
        this.zzc(n, 1);
        long l2 = l;
        this.zzc(l2);
    }

    public final void zza(int n, boolean bl) throws IOException {
        this.zzc(n, 0);
        boolean bl2 = bl;
        boolean bl3 = bl2;
        byte by = (byte)(bl3 ? 1 : 0);
        zzflk zzflk2 = this;
        if (!zzflk2.zza.hasRemaining()) {
            throw new zzfll(zzflk2.zza.position(), zzflk2.zza.limit());
        }
        zzflk2.zza.put(by);
    }

    public final void zza(int n, String string2) throws IOException {
        this.zzc(n, 2);
        String string3 = string2;
        zzflk zzflk2 = this;
        try {
            int n2 = zzflk.zzd(string3.length());
            int n3 = zzflk.zzd(string3.length() * 3);
            if (n2 == n3) {
                int n4 = zzflk2.zza.position();
                if (zzflk2.zza.remaining() < n2) {
                    throw new zzfll(n4 + n2, zzflk2.zza.limit());
                }
                zzflk2.zza.position(n4 + n2);
                zzflk.zza(string3, zzflk2.zza);
                int n5 = zzflk2.zza.position();
                zzflk2.zza.position(n4);
                zzflk2.zzc(n5 - n4 - n2);
                zzflk2.zza.position(n5);
                return;
            }
            zzflk2.zzc(zzflk.zza((CharSequence)string3));
            zzflk.zza(string3, zzflk2.zza);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzfll zzfll2 = new zzfll(zzflk2.zza.position(), zzflk2.zza.limit());
            zzfll2.initCause(bufferOverflowException);
            throw zzfll2;
        }
    }

    public final void zza(int n, zzfls zzfls2) throws IOException {
        this.zzc(n, 2);
        this.zza(zzfls2);
    }

    public final void zza(int n, byte[] byArray) throws IOException {
        this.zzc(n, 2);
        byte[] byArray2 = byArray;
        zzflk zzflk2 = this;
        zzflk2.zzc(byArray2.length);
        zzflk2.zzc(byArray2);
    }

    public final void zzd(int n, long l) throws IOException {
        this.zzc(n, 0);
        long l2 = l;
        this.zzb(zzflk.zzd(l2));
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zzflk.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        zzflk.zzb(charSequence, byteBuffer);
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                n2 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n2).toString());
            }
            n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n5 < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n5 + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n5 + n4;
        }
        n5 += n3;
        while (n3 < n4) {
            int n7;
            char c2;
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    n7 = n3 - 1;
                    throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                }
                n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                c2 = c;
                n7 = n5;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n7).toString());
            }
            ++n3;
        }
        return n5;
    }

    public final void zza(zzfls zzfls2) throws IOException {
        this.zzc(zzfls2.zze());
        zzfls2.zza(this);
    }

    public static int zze(int n, long l) {
        return zzflk.zzb(n) + zzflk.zza(l);
    }

    public static int zzb(int n, int n2) {
        return zzflk.zzb(n) + zzflk.zza(n2);
    }

    public static int zzb(int n, String string2) {
        return zzflk.zzb(n) + zzflk.zza(string2);
    }

    public static int zzb(int n, zzfls zzfls2) {
        int n2 = zzfls2.zzf();
        return zzflk.zzb(n) + (zzflk.zzd(n2) + n2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zzflk.zzb(n) + zzflk.zzb(byArray);
    }

    public static int zzf(int n, long l) {
        return zzflk.zzb(n) + zzflk.zza(zzflk.zzd(l));
    }

    public static int zza(int n) {
        if (n >= 0) {
            return zzflk.zzd(n);
        }
        return 10;
    }

    public static int zza(String string2) {
        int n = zzflk.zza((CharSequence)string2);
        return zzflk.zzd(n) + n;
    }

    public static int zzb(byte[] byArray) {
        return zzflk.zzd(byArray.length) + byArray.length;
    }

    public final void zza() {
        if (this.zza.remaining() != 0) {
            throw new IllegalStateException(String.format("Did not write as much data as expected, %s bytes remaining.", this.zza.remaining()));
        }
    }

    private final void zzf(int n) throws IOException {
        byte by = (byte)n;
        zzflk zzflk2 = this;
        if (!zzflk2.zza.hasRemaining()) {
            throw new zzfll(zzflk2.zza.position(), zzflk2.zza.limit());
        }
        zzflk2.zza.put(by);
    }

    public final void zzc(byte[] byArray) throws IOException {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        zzflk zzflk2 = this;
        if (zzflk2.zza.remaining() >= n) {
            zzflk2.zza.put(byArray2, 0, n);
            return;
        }
        throw new zzfll(zzflk2.zza.position(), zzflk2.zza.limit());
    }

    public final void zzc(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzc(n << 3 | n3);
    }

    public static int zzb(int n) {
        return zzflk.zzd(n << 3);
    }

    public final void zzc(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzf(n);
                return;
            }
            this.zzf(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzd(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private final void zzb(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzf((int)l);
                return;
            }
            this.zzf((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zza(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    private final void zzc(long l) throws IOException {
        if (this.zza.remaining() < 8) {
            throw new zzfll(this.zza.position(), this.zza.limit());
        }
        this.zza.putLong(l);
    }

    public static int zze(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzd(long l) {
        return l << 1 ^ l >> 63;
    }
}

