/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamite;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamite.zze;
import com.google.android.gms.dynamite.zzf;
import com.google.android.gms.dynamite.zzg;
import com.google.android.gms.dynamite.zzh;
import com.google.android.gms.dynamite.zzi;
import com.google.android.gms.dynamite.zzj;
import com.google.android.gms.dynamite.zzk;
import com.google.android.gms.dynamite.zzl;
import com.google.android.gms.dynamite.zzm;
import com.google.android.gms.dynamite.zzn;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

@Hide
public final class DynamiteModule {
    private static Boolean zzhdc;
    private static zzk zzhdd;
    private static zzm zzhde;
    private static String zzhdf;
    private static final ThreadLocal<zza> zzhdg;
    private static final zzi zzhdh;
    public static final zzd zzhdi;
    private static zzd zzhdj;
    public static final zzd zzhdk;
    public static final zzd zzhdl;
    public static final zzd zzhdm;
    public static final zzd zzhdn;
    private final Context zzhdo;

    /*
     * Loose catch block
     */
    public static DynamiteModule zza(Context context, zzd zzd2, String string2) throws zzc {
        zza zza2 = zzhdg.get();
        zza zza3 = new zza(null);
        zzhdg.set(zza3);
        try {
            zzj zzj2 = zzd2.zza(context, string2, zzhdh);
            int n = zzj2.zzhds;
            int n2 = zzj2.zzhdt;
            Log.i((String)"DynamiteModule", (String)new StringBuilder(68 + String.valueOf(string2).length() + String.valueOf(string2).length()).append("Considering local module ").append(string2).append(":").append(n).append(" and remote module ").append(string2).append(":").append(n2).toString());
            if (zzj2.zzhdu == 0 || zzj2.zzhdu == -1 && zzj2.zzhds == 0 || zzj2.zzhdu == 1 && zzj2.zzhdt == 0) {
                n = zzj2.zzhds;
                n2 = zzj2.zzhdt;
                throw new zzc(new StringBuilder(91).append("No acceptable module found. Local version is ").append(n).append(" and remote version is ").append(n2).append(".").toString(), null);
            }
            if (zzj2.zzhdu == -1) {
                DynamiteModule dynamiteModule = DynamiteModule.zzz(context, string2);
                return dynamiteModule;
            }
            if (zzj2.zzhdu == 1) {
                try {
                    DynamiteModule dynamiteModule = DynamiteModule.zza(context, string2, zzj2.zzhdt);
                    return dynamiteModule;
                }
                catch (zzc zzc2) {
                    block12: {
                        DynamiteModule dynamiteModule;
                        block13: {
                            String string3 = String.valueOf(zzc2.getMessage());
                            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load remote module: ".concat(string3) : new String("Failed to load remote module: ")));
                            if (zzj2.zzhds == 0 || zzd2.zza((Context)context, (String)string2, (zzi)new zzb((int)zzj2.zzhds, (int)0)).zzhdu != -1) break block12;
                            dynamiteModule = DynamiteModule.zzz(context, string2);
                            if (zza3.zzhdp == null) break block13;
                            zza3.zzhdp.close();
                        }
                        zzhdg.set(zza2);
                        return dynamiteModule;
                    }
                    throw new zzc("Remote load failed. No local fallback found.", zzc2, null);
                }
            }
            n = zzj2.zzhdu;
            throw new zzc(new StringBuilder(47).append("VersionPolicy returned invalid code:").append(n).toString(), null);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (zza3.zzhdp != null) {
                zza3.zzhdp.close();
            }
            zzhdg.set(zza2);
        }
    }

    public static int zzx(Context context, String string2) {
        try {
            Class<?> clazz = context.getApplicationContext().getClassLoader().loadClass(new StringBuilder(61 + String.valueOf(string2).length()).append("com.google.android.gms.dynamite.descriptors.").append(string2).append(".ModuleDescriptor").toString());
            Field field = clazz.getDeclaredField("MODULE_ID");
            Field field2 = clazz.getDeclaredField("MODULE_VERSION");
            if (!field.get(null).equals(string2)) {
                String string3 = String.valueOf(field.get(null));
                Log.e((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Module descriptor id '").append(string3).append("' didn't match expected id '").append(string2).append("'").toString());
                return 0;
            }
            return field2.getInt(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)"DynamiteModule", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("Local module descriptor class for ").append(string2).append(" not found.").toString());
        }
        catch (Exception exception) {
            String string4 = String.valueOf(exception.getMessage());
            Log.e((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to load module descriptor class: ".concat(string4) : new String("Failed to load module descriptor class: ")));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int zzc(Context context, String string2, boolean bl) {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            Boolean bl2 = zzhdc;
            if (bl2 == null) {
                try {
                    Class<?> clazz2 = context.getApplicationContext().getClassLoader().loadClass(DynamiteLoaderClassLoader.class.getName());
                    Field field = clazz2.getDeclaredField("sClassLoader");
                    Class<?> clazz3 = clazz2;
                    synchronized (clazz3) {
                        Object object = (ClassLoader)field.get(null);
                        if (object != null) {
                            if (object == ClassLoader.getSystemClassLoader()) {
                                bl2 = Boolean.FALSE;
                            } else {
                                try {
                                    DynamiteModule.zza(object);
                                }
                                catch (zzc zzc2) {}
                                bl2 = Boolean.TRUE;
                            }
                        } else if ("com.google.android.gms".equals(context.getApplicationContext().getPackageName())) {
                            field.set(null, ClassLoader.getSystemClassLoader());
                            bl2 = Boolean.FALSE;
                        } else {
                            try {
                                int n = DynamiteModule.zze(context, string2, bl);
                                if (zzhdf == null || zzhdf.isEmpty()) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 16, 1, 2, 20, 4, 22, 6, 7, 15] lbl30 : MonitorExitStatement: MONITOREXIT : var8_9
                                    // ** MonitorExit[var4_3] (shouldn't be in output)
                                    return n;
                                }
                                object = new zzh(zzhdf, ClassLoader.getSystemClassLoader());
                                DynamiteModule.zza(object);
                                field.set(null, object);
                                zzhdc = Boolean.TRUE;
                                // MONITOREXIT @DISABLED, blocks:[0, 16, 1, 2, 20, 4, 22, 6, 7] lbl37 : MonitorExitStatement: MONITOREXIT : var8_9
                                // ** MonitorExit[var4_3] (shouldn't be in output)
                                return n;
                            }
                            catch (zzc zzc3) {
                                field.set(null, ClassLoader.getSystemClassLoader());
                                bl2 = Boolean.FALSE;
                            }
                        }
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    String string3 = String.valueOf(reflectiveOperationException);
                    Log.w((String)"DynamiteModule", (String)new StringBuilder(30 + String.valueOf(string3).length()).append("Failed to load module via V2: ").append(string3).toString());
                    bl2 = Boolean.FALSE;
                }
                zzhdc = bl2;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (bl2.booleanValue()) {
                try {
                    return DynamiteModule.zze(context, string2, bl);
                }
                catch (zzc zzc4) {
                    String string4 = String.valueOf(zzc4.getMessage());
                    Log.w((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to retrieve remote module version: ".concat(string4) : new String("Failed to retrieve remote module version: ")));
                    return 0;
                }
            }
            return DynamiteModule.zzd(context, string2, bl);
        }
    }

    private static int zzd(Context context, String string2, boolean bl) {
        zzk zzk2 = DynamiteModule.zzdh(context);
        if (zzk2 == null) {
            return 0;
        }
        try {
            return zzk2.zza(com.google.android.gms.dynamic.zzn.zzz(context), string2, bl);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(remoteException.getMessage());
            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to retrieve remote module version: ".concat(string3) : new String("Failed to retrieve remote module version: ")));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int zze(Context context, String string2, boolean bl) throws zzc {
        try (Cursor cursor = null;){
            boolean bl2 = bl;
            String string3 = string2;
            boolean bl3 = bl2;
            String string4 = string3;
            String string5 = bl3 ? "api_force_staging" : "api";
            cursor = context.getContentResolver().query(Uri.parse((String)new StringBuilder(42 + String.valueOf(string5).length() + String.valueOf(string4).length()).append("content://com.google.android.gms.chimera/").append(string5).append("/").append(string4).toString()), null, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                Log.w((String)"DynamiteModule", (String)"Failed to retrieve remote module version.");
                throw new zzc("Failed to connect to dynamite module ContentResolver.", null);
            }
            int n = cursor.getInt(0);
            if (n <= 0) return n;
            Object object = DynamiteModule.class;
            synchronized (DynamiteModule.class) {
                zzhdf = cursor.getString(2);
                // ** MonitorExit[var5_11] (shouldn't be in output)
                object = zzhdg.get();
                if (object == null || ((zza)object).zzhdp != null) return n;
                ((zza)object).zzhdp = cursor;
                cursor = null;
                return n;
            }
        }
    }

    public static int zzy(Context context, String string2) {
        return DynamiteModule.zzc(context, string2, false);
    }

    private static DynamiteModule zzz(Context context, String string2) {
        String string3 = String.valueOf(string2);
        Log.i((String)"DynamiteModule", (String)(string3.length() != 0 ? "Selected local version of ".concat(string3) : new String("Selected local version of ")));
        return new DynamiteModule(context.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamiteModule zza(Context context, String string2, int n) throws zzc {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            Boolean bl = zzhdc;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (bl == null) {
                throw new zzc("Failed to determine which loading route to use.", null);
            }
            if (bl.booleanValue()) {
                return DynamiteModule.zzc(context, string2, n);
            }
            return DynamiteModule.zzb(context, string2, n);
        }
    }

    private static DynamiteModule zzb(Context context, String string2, int n) throws zzc {
        IObjectWrapper iObjectWrapper;
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        zzk zzk2 = DynamiteModule.zzdh(context);
        if (zzk2 == null) {
            throw new zzc("Failed to create IDynamiteLoader.", null);
        }
        try {
            iObjectWrapper = zzk2.zza(com.google.android.gms.dynamic.zzn.zzz(context), string2, n);
        }
        catch (RemoteException remoteException) {
            throw new zzc("Failed to load remote module.", remoteException, null);
        }
        if (com.google.android.gms.dynamic.zzn.zzy(iObjectWrapper) == null) {
            throw new zzc("Failed to load remote module.", null);
        }
        return new DynamiteModule((Context)com.google.android.gms.dynamic.zzn.zzy(iObjectWrapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static zzk zzdh(Context context) {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            if (zzhdd != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return zzhdd;
            }
            if (com.google.android.gms.common.zzf.zzahf().isGooglePlayServicesAvailable(context) != 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            try {
                IInterface iInterface;
                zzk zzk2;
                IBinder iBinder = (IBinder)context.createPackageContext("com.google.android.gms", 3).getClassLoader().loadClass("com.google.android.gms.chimera.container.DynamiteLoaderImpl").newInstance();
                if ((iBinder == null ? null : (zzk2 = (iInterface = iBinder.queryLocalInterface("com.google.android.gms.dynamite.IDynamiteLoader")) instanceof zzk ? (zzk)iInterface : new zzl(iBinder))) != null) {
                    zzhdd = zzk2;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return zzk2;
                }
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.e((String)"DynamiteModule", (String)(string2.length() != 0 ? "Failed to load IDynamiteLoader from GmsCore: ".concat(string2) : new String("Failed to load IDynamiteLoader from GmsCore: ")));
            }
            return null;
        }
    }

    public final Context zzarl() {
        return this.zzhdo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamiteModule zzc(Context context, String string2, int n) throws zzc {
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        Object object = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            zzm zzm2 = zzhde;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (zzm2 == null) {
                throw new zzc("DynamiteLoaderV2 was not cached.", null);
            }
            object = zzhdg.get();
            if (object == null || ((zza)object).zzhdp == null) {
                throw new zzc("No result cursor", null);
            }
            Context context2 = DynamiteModule.zza(context.getApplicationContext(), string2, n, ((zza)object).zzhdp, zzm2);
            if (context2 == null) {
                throw new zzc("Failed to get module context", null);
            }
            return new DynamiteModule(context2);
        }
    }

    private static Context zza(Context context, String string2, int n, Cursor cursor, zzm zzm2) {
        try {
            return (Context)com.google.android.gms.dynamic.zzn.zzy(zzm2.zza(com.google.android.gms.dynamic.zzn.zzz(context), string2, n, com.google.android.gms.dynamic.zzn.zzz(cursor)));
        }
        catch (Exception exception) {
            String string3 = String.valueOf(exception.toString());
            Log.e((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load DynamiteLoader: ".concat(string3) : new String("Failed to load DynamiteLoader: ")));
            return null;
        }
    }

    private static void zza(ClassLoader classLoader) throws zzc {
        try {
            IInterface iInterface;
            IBinder iBinder = (IBinder)classLoader.loadClass("com.google.android.gms.dynamiteloader.DynamiteLoaderV2").getConstructor(new Class[0]).newInstance(new Object[0]);
            zzhde = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.android.gms.dynamite.IDynamiteLoaderV2")) instanceof zzm ? (zzm)iInterface : new zzn(iBinder));
            return;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new zzc("Failed to instantiate dynamite loader", reflectiveOperationException, null);
        }
    }

    public final IBinder zzhk(String string2) throws zzc {
        try {
            return (IBinder)this.zzhdo.getClassLoader().loadClass(string2).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            String string3 = String.valueOf(string2);
            throw new zzc(string3.length() != 0 ? "Failed to instantiate module class: ".concat(string3) : new String("Failed to instantiate module class: "), reflectiveOperationException, null);
        }
    }

    private DynamiteModule(Context context) {
        this.zzhdo = zzbq.checkNotNull(context);
    }

    static {
        zzhdg = new ThreadLocal();
        zzhdh = new com.google.android.gms.dynamite.zza();
        zzhdi = new com.google.android.gms.dynamite.zzb();
        zzhdj = new com.google.android.gms.dynamite.zzc();
        zzhdk = new com.google.android.gms.dynamite.zzd();
        zzhdl = new zze();
        zzhdm = new zzf();
        zzhdn = new zzg();
    }

    @DynamiteApi
    public static class DynamiteLoaderClassLoader {
        public static ClassLoader sClassLoader;

        public DynamiteLoaderClassLoader() {
        }
    }

    static final class zza {
        public Cursor zzhdp;

        private zza() {
        }

        /* synthetic */ zza(com.google.android.gms.dynamite.zza zza2) {
            this();
        }
    }

    public static final class zzc
    extends Exception {
        private zzc(String string2) {
            super(string2);
        }

        private zzc(String string2, Throwable throwable) {
            super(string2, throwable);
        }

        /* synthetic */ zzc(String string2, com.google.android.gms.dynamite.zza zza2) {
            this(string2);
        }

        /* synthetic */ zzc(String string2, Throwable throwable, com.google.android.gms.dynamite.zza zza2) {
            this(string2, throwable);
        }
    }

    static final class zzb
    implements zzi {
        private final int zzhdq;
        private final int zzhdr;

        public zzb(int n, int n2) {
            this.zzhdq = n;
            this.zzhdr = 0;
        }

        @Override
        public final int zzc(Context context, String string2, boolean bl) {
            return 0;
        }

        @Override
        public final int zzx(Context context, String string2) {
            return this.zzhdq;
        }
    }

    public static interface zzd {
        public zzj zza(Context var1, String var2, zzi var3) throws zzc;
    }
}

