/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfgn;
import com.google.android.gms.internal.zzfhz;
import com.google.android.gms.internal.zzfic;
import com.google.android.gms.internal.zzfid;
import com.google.android.gms.internal.zzfjm;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfhy
extends zzfgn<Integer>
implements zzfic,
zzfjm,
RandomAccess {
    private static final zzfhy zzpqk = new zzfhy();
    private int[] zzpql;
    private int size;

    public static zzfhy zzdad() {
        return zzpqk;
    }

    zzfhy() {
        this(new int[10], 0);
    }

    private zzfhy(int[] nArray, int n) {
        this.zzpql = nArray;
        this.size = n;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfhy)) {
            return super.equals(object);
        }
        zzfhy zzfhy2 = (zzfhy)object;
        if (this.size != zzfhy2.size) {
            return false;
        }
        int[] nArray = zzfhy2.zzpql;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzpql[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzpql[i];
        }
        return n;
    }

    @Override
    public final zzfic zzmk(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzfhy(Arrays.copyOf(this.zzpql, n), this.size);
    }

    @Override
    public final int getInt(int n) {
        this.zzmm(n);
        return this.zzpql[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzml(int n) {
        this.zzal(this.size, n);
    }

    private final void zzal(int n, int n2) {
        this.zzcxl();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzmn(n));
        }
        if (this.size < this.zzpql.length) {
            System.arraycopy(this.zzpql, n, this.zzpql, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzpql, 0, nArray, 0, n);
            System.arraycopy(this.zzpql, n, nArray, n + 1, this.size - n);
            this.zzpql = nArray;
        }
        this.zzpql[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzcxl();
        zzfhz.checkNotNull(collection);
        if (!(collection instanceof zzfhy)) {
            return super.addAll(collection);
        }
        zzfhy zzfhy2 = (zzfhy)collection;
        if (zzfhy2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfhy2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfhy2.size;
        if (n > this.zzpql.length) {
            this.zzpql = Arrays.copyOf(this.zzpql, n);
        }
        System.arraycopy(zzfhy2.zzpql, 0, this.zzpql, this.size, zzfhy2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcxl();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzpql[i])) continue;
            System.arraycopy(this.zzpql, i + 1, this.zzpql, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzmm(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzmn(n));
        }
    }

    private final String zzmn(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzfhy zzfhy2 = this;
        zzfhy2.zzcxl();
        zzfhy2.zzmm(n);
        int n4 = zzfhy2.zzpql[n];
        zzfhy2.zzpql[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfhy zzfhy2 = this;
        zzfhy2.zzcxl();
        zzfhy2.zzmm(n);
        int n2 = zzfhy2.zzpql[n];
        System.arraycopy(zzfhy2.zzpql, n + 1, zzfhy2.zzpql, n, zzfhy2.size - n);
        --zzfhy2.size;
        ++zzfhy2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzal(n, n2);
    }

    @Override
    public final /* synthetic */ zzfid zzmo(int n) {
        return this.zzmk(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzpqk.zzbkr();
    }
}

