/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GoogleCertificatesQuery;
import com.google.android.gms.common.internal.ICertData;
import com.google.android.gms.common.internal.IGoogleCertificatesApi;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.zzg;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.concurrent.GuardedBy;

@CheckReturnValue
final class GoogleCertificates {
    private static volatile IGoogleCertificatesApi zzax;
    private static final Object zzay;
    private static Context zzaz;
    @GuardedBy(value="GoogleCertificates.class")
    private static Set<ICertData> zzba;
    @GuardedBy(value="GoogleCertificates.class")
    private static Set<ICertData> zzbb;

    static synchronized void init(Context context) {
        if (zzaz == null) {
            if (context != null) {
                zzaz = context.getApplicationContext();
                return;
            }
        } else {
            Log.w((String)"GoogleCertificates", (String)"GoogleCertificates has been initialized already");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzc() throws DynamiteModule.LoadingException {
        if (zzax != null) {
            return;
        }
        Preconditions.checkNotNull(zzaz);
        Object object = zzay;
        synchronized (object) {
            if (zzax == null) {
                zzax = IGoogleCertificatesApi.Stub.asInterface(DynamiteModule.load(zzaz, DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING, "com.google.android.gms.googlecertificates").instantiate("com.google.android.gms.common.GoogleCertificatesImpl"));
            }
            return;
        }
    }

    private static Set<ICertData> zza(IBinder[] iBinderArray) throws RemoteException {
        int n = iBinderArray.length;
        HashSet<ICertData> hashSet = new HashSet<ICertData>(n);
        for (int i = 0; i < n; ++i) {
            ICertData iCertData = ICertData.Stub.asInterface(iBinderArray[i]);
            if (iCertData == null) continue;
            hashSet.add(iCertData);
        }
        return hashSet;
    }

    static synchronized Set<ICertData> zzd() {
        if (zzba != null) {
            return zzba;
        }
        try {
            GoogleCertificates.zzc();
        }
        catch (DynamiteModule.LoadingException loadingException) {
            Log.e((String)"GoogleCertificates", (String)"Failed to load com.google.android.gms.googlecertificates", (Throwable)loadingException);
            return Collections.emptySet();
        }
        try {
            IObjectWrapper iObjectWrapper = zzax.getGoogleCertificates();
            if (iObjectWrapper == null) {
                Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote");
                return Collections.emptySet();
            }
            zzba = GoogleCertificates.zza((IBinder[])ObjectWrapper.unwrap(iObjectWrapper));
        }
        catch (RemoteException remoteException) {
            Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote", (Throwable)remoteException);
            return Collections.emptySet();
        }
        return zzba;
    }

    static synchronized Set<ICertData> zze() {
        if (zzbb != null) {
            return zzbb;
        }
        try {
            GoogleCertificates.zzc();
        }
        catch (DynamiteModule.LoadingException loadingException) {
            Log.e((String)"GoogleCertificates", (String)"Failed to load com.google.android.gms.googlecertificates", (Throwable)loadingException);
            return Collections.emptySet();
        }
        try {
            IObjectWrapper iObjectWrapper = zzax.getGoogleReleaseCertificates();
            if (iObjectWrapper == null) {
                Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote");
                return Collections.emptySet();
            }
            zzbb = GoogleCertificates.zza((IBinder[])ObjectWrapper.unwrap(iObjectWrapper));
        }
        catch (RemoteException remoteException) {
            Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote", (Throwable)remoteException);
            return Collections.emptySet();
        }
        return zzbb;
    }

    static zzg zza(String string2, CertData certData, boolean bl) {
        boolean bl2;
        try {
            GoogleCertificates.zzc();
        }
        catch (DynamiteModule.LoadingException loadingException) {
            return zzg.zza("module init", loadingException);
        }
        Preconditions.checkNotNull(zzaz);
        GoogleCertificatesQuery googleCertificatesQuery = new GoogleCertificatesQuery(string2, certData, bl);
        try {
            bl2 = zzax.isGoogleOrPlatformSigned(googleCertificatesQuery, ObjectWrapper.wrap(zzaz.getPackageManager()));
        }
        catch (RemoteException remoteException) {
            Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote", (Throwable)remoteException);
            return zzg.zza("module call", remoteException);
        }
        if (bl2) {
            return zzg.zzg();
        }
        boolean bl3 = !bl && GoogleCertificates.zza((String)string2, (CertData)certData, (boolean)true).zzbl;
        return zzg.zza(string2, certData, bl, bl3);
    }

    static {
        zzay = new Object();
    }

    static abstract class CertData
    extends ICertData.Stub {
        private int zzbc;

        protected CertData(byte[] byArray) {
            Preconditions.checkArgument(byArray.length == 25);
            this.zzbc = Arrays.hashCode(byArray);
        }

        public int hashCode() {
            return this.zzbc;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ICertData)) {
                return false;
            }
            try {
                ICertData iCertData = (ICertData)object;
                if (iCertData.getHashCode() != this.hashCode()) {
                    return false;
                }
                IObjectWrapper iObjectWrapper = iCertData.getBytesWrapped();
                if (iObjectWrapper == null) {
                    return false;
                }
                byte[] byArray = (byte[])ObjectWrapper.unwrap(iObjectWrapper);
                return Arrays.equals(this.getBytes(), byArray);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote", (Throwable)remoteException);
                return false;
            }
        }

        abstract byte[] getBytes();

        @Override
        public IObjectWrapper getBytesWrapped() {
            return ObjectWrapper.wrap(this.getBytes());
        }

        @Override
        public int getHashCode() {
            return this.hashCode();
        }

        protected static byte[] zzd(String string2) {
            try {
                return string2.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
        }
    }
}

