/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import com.google.android.gms.common.R;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.MetadataValueReader;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.util.VisibleForTesting;
import javax.annotation.concurrent.GuardedBy;

@Deprecated
@KeepForSdk
public final class GoogleServices {
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static GoogleServices zzku;
    private final String zzkv;
    private final Status zzkw;
    private final boolean zzkx;
    private final boolean zzky;

    @VisibleForTesting
    @KeepForSdk
    GoogleServices(Context context) {
        Resources resources = context.getResources();
        String string2 = resources.getResourcePackageName(R.string.common_google_play_services_unknown_issue);
        boolean bl = true;
        int n = resources.getIdentifier("google_app_measurement_enable", "integer", string2);
        if (n != 0) {
            bl = resources.getInteger(n) != 0;
            this.zzky = !bl;
        } else {
            this.zzky = false;
        }
        this.zzkx = bl;
        String string3 = MetadataValueReader.getGoogleAppId(context);
        if (string3 == null) {
            string3 = new StringResourceValueReader(context).getString("google_app_id");
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            this.zzkw = new Status(10, "Missing google app id value from from string resources with name google_app_id.");
            this.zzkv = null;
            return;
        }
        this.zzkv = string3;
        this.zzkw = Status.RESULT_SUCCESS;
    }

    @VisibleForTesting
    @KeepForSdk
    GoogleServices(String string2, boolean bl) {
        this.zzkv = string2;
        this.zzkw = Status.RESULT_SUCCESS;
        this.zzkx = bl;
        this.zzky = !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static Status initialize(Context context, String string2, boolean bl) {
        Preconditions.checkNotNull(context, "Context must not be null.");
        Preconditions.checkNotEmpty(string2, "App ID must be nonempty.");
        Object object = sLock;
        synchronized (object) {
            if (zzku != null) {
                return zzku.checkGoogleAppId(string2);
            }
            zzku = new GoogleServices(string2, bl);
            return GoogleServices.zzku.zzkw;
        }
    }

    @VisibleForTesting
    @KeepForSdk
    final Status checkGoogleAppId(String string2) {
        if (this.zzkv != null && !this.zzkv.equals(string2)) {
            String string3 = this.zzkv;
            return new Status(10, new StringBuilder(97 + String.valueOf(string3).length()).append("Initialize was called with two different Google App IDs.  Only the first app ID will be used: '").append(string3).append("'.").toString());
        }
        return Status.RESULT_SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static Status initialize(Context context) {
        Preconditions.checkNotNull(context, "Context must not be null.");
        Object object = sLock;
        synchronized (object) {
            if (zzku == null) {
                zzku = new GoogleServices(context);
            }
            return GoogleServices.zzku.zzkw;
        }
    }

    @KeepForSdk
    public static String getGoogleAppId() {
        return GoogleServices.checkInitialized((String)"getGoogleAppId").zzkv;
    }

    @KeepForSdk
    public static boolean isMeasurementEnabled() {
        GoogleServices googleServices = GoogleServices.checkInitialized("isMeasurementEnabled");
        return googleServices.zzkw.isSuccess() && googleServices.zzkx;
    }

    @KeepForSdk
    public static boolean isMeasurementExplicitlyDisabled() {
        return GoogleServices.checkInitialized((String)"isMeasurementExplicitlyDisabled").zzky;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @KeepForSdk
    static void clearInstanceForTest() {
        Object object = sLock;
        synchronized (object) {
            zzku = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    private static GoogleServices checkInitialized(String string2) {
        Object object = sLock;
        synchronized (object) {
            if (zzku == null) {
                throw new IllegalStateException(new StringBuilder(34 + String.valueOf(string2).length()).append("Initialize must be called before ").append(string2).append(".").toString());
            }
            return zzku;
        }
    }
}

