/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.collect;

import com.google.android.gms.common.internal.Preconditions;
import java.util.HashSet;
import java.util.Set;

public class Sets {
    public Sets() {
    }

    public static <E> Set<E> union(Set<? extends E> set, Set<? extends E> set2) {
        Preconditions.checkNotNull(set);
        Preconditions.checkNotNull(set2);
        HashSet<? extends E> hashSet = new HashSet<E>(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    public static <E> Set<E> union(Iterable<Set<E>> iterable) {
        Preconditions.checkNotNull(iterable);
        HashSet<E> hashSet = new HashSet<E>();
        for (Set<E> set : iterable) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public static <E> Set<E> difference(Set<? extends E> set, Set<? extends E> set2) {
        Preconditions.checkNotNull(set);
        Preconditions.checkNotNull(set2);
        HashSet<E> hashSet = new HashSet<E>();
        for (E e : set) {
            if (set2.contains(e)) continue;
            hashSet.add(e);
        }
        return hashSet;
    }
}

