/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Debug;
import android.os.DropBoxManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.annotation.concurrent.GuardedBy;

public final class CrashUtils {
    private static final String[] zzzc = new String[]{"android.", "com.android.", "dalvik.", "java.", "javax."};
    private static DropBoxManager zzzd = null;
    private static boolean zzze = false;
    private static boolean zzzf;
    private static boolean zzzg;
    private static int zzzh;
    @GuardedBy(value="CrashUtils.class")
    private static int zzzi;
    @GuardedBy(value="CrashUtils.class")
    private static int zzzj;

    public CrashUtils() {
    }

    public static boolean addDynamiteErrorToDropBox(Context context, Throwable throwable) {
        return CrashUtils.addErrorToDropBoxInternal(context, throwable, 0x20000000);
    }

    @Deprecated
    public static boolean addErrorToDropBox(Context context, Throwable throwable) {
        return CrashUtils.addDynamiteErrorToDropBox(context, throwable);
    }

    public static boolean addErrorToDropBoxInternal(Context context, Throwable throwable, int n) {
        try {
            Preconditions.checkNotNull(context);
            Preconditions.checkNotNull(throwable);
            if (!CrashUtils.isPackageSide()) {
                return false;
            }
            if (!CrashUtils.zzdb() && (throwable = CrashUtils.zza(throwable)) == null) {
                return false;
            }
            String string2 = Log.getStackTraceString((Throwable)throwable);
            String string3 = ProcessUtils.getMyProcessName();
            return CrashUtils.zza(context, string2, string3, n, throwable);
        }
        catch (Exception exception) {
            boolean bl = false;
            try {
                bl = CrashUtils.zzdb();
            }
            catch (Exception exception2) {
                Log.e((String)"CrashUtils", (String)"Error determining which process we're running in!", (Throwable)exception2);
            }
            if (bl) {
                throw exception;
            }
            Log.e((String)"CrashUtils", (String)"Error adding exception to DropBox!", (Throwable)exception);
            return false;
        }
    }

    public static boolean addErrorToDropBoxInternal(Context context, String string2, String string3, int n) {
        return CrashUtils.zza(context, string2, string3, n, null);
    }

    private static synchronized boolean zza(Context context, String string2, String string3, int n, Throwable throwable) {
        int n2;
        Preconditions.checkNotNull(context);
        if (!CrashUtils.isPackageSide() || Strings.isEmptyOrWhitespace(string2)) {
            return false;
        }
        int n3 = string2.hashCode();
        int n4 = n2 = throwable == null ? zzzj : throwable.hashCode();
        if (zzzi == n3 && zzzj == n2) {
            return false;
        }
        zzzi = n3;
        zzzj = n2;
        DropBoxManager dropBoxManager = zzzd != null ? zzzd : (DropBoxManager)context.getSystemService("dropbox");
        if (dropBoxManager == null || !dropBoxManager.isTagEnabled("system_app_crash")) {
            return false;
        }
        String string4 = CrashUtils.zza(context, string2, string3, n);
        dropBoxManager.addText("system_app_crash", string4);
        return true;
    }

    public static boolean isSystemClassPrefixInternal(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        String[] stringArray = zzzc;
        int n = zzzc.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray[i];
            if (!string2.startsWith(string3)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public static synchronized void setTestVariables(DropBoxManager dropBoxManager, boolean bl, boolean bl2, int n) {
        zzze = true;
        zzzd = dropBoxManager;
        zzzg = bl;
        zzzf = bl2;
        zzzh = n;
        zzzi = 0;
        zzzj = 0;
    }

    @VisibleForTesting
    private static synchronized Throwable zza(Throwable throwable) {
        Throwable throwable2;
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            linkedList.push(throwable2);
        }
        Throwable throwable3 = null;
        boolean bl = false;
        while (!linkedList.isEmpty()) {
            throwable2 = (Throwable)linkedList.pop();
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            arrayList.add(new StackTraceElement(throwable2.getClass().getName(), "<filtered>", "<filtered>", 1));
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[i];
                String string2 = stackTraceElement.getClassName();
                String string3 = stackTraceElement.getFileName();
                boolean bl2 = !TextUtils.isEmpty((CharSequence)string3) && string3.startsWith(":com.google.android.gms");
                bl |= bl2;
                if (!bl2 && !CrashUtils.isSystemClassPrefixInternal(string2)) {
                    stackTraceElement = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                }
                arrayList.add(stackTraceElement);
            }
            throwable3 = throwable3 == null ? new Throwable("<filtered>") : new Throwable("<filtered>", throwable3);
            throwable3.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
        }
        if (!bl) {
            return null;
        }
        return throwable3;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    private static synchronized String zza(Context context, String string2, String string3, int n) {
        int n2;
        Object object;
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("Process: ").append(Strings.nullToEmpty(string3)).append("\n");
        stringBuilder.append("Package: com.google.android.gms");
        int n3 = 12451009;
        String string4 = "12.4.51 (020308-{{cl}})";
        if (CrashUtils.zzdb()) {
            try {
                PackageInfo packageInfo = Wrappers.packageManager(context).getPackageInfo(context.getPackageName(), 0);
                n3 = packageInfo.versionCode;
                if (packageInfo.versionName != null) {
                    string4 = packageInfo.versionName;
                }
            }
            catch (Exception exception) {
                Log.w((String)"CrashUtils", (String)"Error while trying to get the package information! Using static version.", (Throwable)exception);
            }
        }
        stringBuilder.append(" v").append(n3);
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            if (string4.contains("(") && !string4.contains(")")) {
                if (string4.endsWith("-")) {
                    string4 = String.valueOf(string4).concat("111111111");
                }
                string4 = String.valueOf(string4).concat(")");
            }
            stringBuilder.append(" (").append(string4).append(")");
        }
        stringBuilder.append("\n");
        stringBuilder.append("Build: ").append(Build.FINGERPRINT).append("\n");
        if (Debug.isDebuggerConnected()) {
            stringBuilder.append("Debugger: Connected\n");
        }
        if (n != 0) {
            stringBuilder.append("DD-EDD: ").append(n).append("\n");
        }
        stringBuilder.append("\n");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string2);
        }
        int n4 = 0;
        if (CrashUtils.zzdb()) {
            object = "logcat_for_system_app_crash";
            int n5 = n4 = zzzh >= 0 ? zzzh : Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)object, (int)0);
        }
        if (n4 <= 0) return stringBuilder.toString();
        stringBuilder.append("\n");
        object = null;
        Process process = new ProcessBuilder("/system/bin/logcat", "-v", "time", "-b", "events", "-b", "system", "-b", "main", "-b", "crash", "-t", String.valueOf(n4)).redirectErrorStream(true).start();
        try {
            process.getOutputStream().close();
        }
        catch (IOException iOException) {}
        try {
            process.getErrorStream().close();
        }
        catch (IOException iOException) {}
        object = new InputStreamReader(process.getInputStream());
        char[] cArray = new char[8192];
        while ((n2 = ((Reader)object).read(cArray)) > 0) {
            stringBuilder.append(cArray, 0, n2);
        }
        try {
            ((InputStreamReader)object).close();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {}
        return stringBuilder.toString();
        catch (IOException iOException) {
            try {
                Log.e((String)"CrashUtils", (String)"Error running logcat", (Throwable)iOException);
                if (object == null) return stringBuilder.toString();
            }
            catch (Throwable throwable) {
                if (object == null) throw throwable;
                try {
                    ((InputStreamReader)object).close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ((InputStreamReader)object).close();
                return stringBuilder.toString();
            }
            catch (IOException iOException3) {}
            return stringBuilder.toString();
        }
    }

    private static boolean isPackageSide() {
        if (zzze) {
            return zzzf;
        }
        return false;
    }

    private static boolean zzdb() {
        if (zzze) {
            return zzzg;
        }
        return false;
    }

    static {
        zzzh = -1;
        zzzi = 0;
        zzzj = 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorDialogData {
        public static final int NONE = 0;
        public static final int SUPPRESSED = 0x40000000;
        public static final int DYNAMITE_CRASH = 0x20000000;
        public static final int BINDER_CRASH = 0x10000000;
        public static final int POPUP_FREQ = 1;
        public static final int AVG_CRASH_FREQ = 2;
        public static final int FORCED_SHUSHED_BY_WRAPPER = 4;
    }
}

