/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;

public final class DeviceProperties {
    private static Boolean zzzl;
    private static Boolean zzzm;
    private static Boolean zzzn;
    private static Boolean zzzo;
    private static Boolean zzzp;
    private static Boolean zzzq;
    private static Boolean zzzr;
    private static Boolean zzzs;
    private static Boolean zzzt;
    private static Boolean zzzu;
    private static Boolean zzzv;
    public static final String FEATURE_SIDEWINDER = "cn.google";
    public static final String FEATURE_LATCHSKY = "cn.google.services";
    public static final String FEATURE_CHROME_OS = "org.chromium.arc";
    public static final String FEATURE_IOT = "android.hardware.type.iot";
    public static final String FEATURE_EMBEDDED = "android.hardware.type.embedded";
    public static final String FEATURE_AUTO = "android.hardware.type.automotive";
    public static final String FEATURE_PIXEL = "com.google.android.feature.PIXEL_EXPERIENCE";
    public static final String FEATURE_TV_1 = "com.google.android.tv";
    public static final String FEATURE_TV_2 = "android.hardware.type.television";
    public static final String FEATURE_TV_3 = "android.software.leanback";

    private DeviceProperties() {
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isTablet(Resources var0) {
        block4: {
            if (var0 == null) {
                return false;
            }
            if (DeviceProperties.zzzl != null) break block4;
            if ((var0.getConfiguration().screenLayout & 15) > 3) ** GOTO lbl-1000
            var1_1 = var0;
            if (DeviceProperties.zzzm == null) {
                var2_2 = var1_1.getConfiguration();
                DeviceProperties.zzzm = (var2_2.screenLayout & 15) <= 3 && var2_2.smallestScreenWidthDp >= 600;
            }
            if (DeviceProperties.zzzm.booleanValue()) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            DeviceProperties.zzzl = v0;
        }
        return DeviceProperties.zzzl;
    }

    @TargetApi(value=20)
    public static boolean isWearable(Context context) {
        if (zzzn == null) {
            zzzn = PlatformVersion.isAtLeastKitKatWatch() && context.getPackageManager().hasSystemFeature("android.hardware.type.watch");
        }
        return zzzn;
    }

    @TargetApi(value=24)
    public static boolean isWearableWithoutPlayStore(Context context) {
        return (!PlatformVersion.isAtLeastN() || DeviceProperties.isSidewinder(context)) && DeviceProperties.isWearable(context);
    }

    @TargetApi(value=21)
    public static boolean isSidewinder(Context context) {
        if (zzzo == null) {
            zzzo = PlatformVersion.isAtLeastLollipop() && context.getPackageManager().hasSystemFeature(FEATURE_SIDEWINDER);
        }
        return zzzo;
    }

    public static boolean isLatchsky(Context context) {
        if (zzzp == null) {
            zzzp = PlatformVersion.isAtLeastM() && context.getPackageManager().hasSystemFeature(FEATURE_LATCHSKY);
        }
        return zzzp;
    }

    public static boolean isIoT(Context context) {
        if (zzzr == null) {
            zzzr = context.getPackageManager().hasSystemFeature(FEATURE_IOT) || context.getPackageManager().hasSystemFeature(FEATURE_EMBEDDED);
        }
        return zzzr;
    }

    public static boolean isAuto(Context context) {
        if (zzzt == null) {
            zzzt = PlatformVersion.isAtLeastO() && context.getPackageManager().hasSystemFeature(FEATURE_AUTO);
        }
        return zzzt;
    }

    public static boolean isTv(Context context) {
        if (zzzu == null) {
            PackageManager packageManager = context.getPackageManager();
            zzzu = packageManager.hasSystemFeature(FEATURE_TV_1) || packageManager.hasSystemFeature(FEATURE_TV_2) || packageManager.hasSystemFeature(FEATURE_TV_3);
        }
        return zzzu;
    }

    public static boolean isUserBuild() {
        if (GooglePlayServicesUtilLight.sIsTestMode) {
            return GooglePlayServicesUtilLight.sTestIsUserBuild;
        }
        return "user".equals(Build.TYPE);
    }

    public static boolean isLowRamOrPreKitKat(Context context) {
        ActivityManager activityManager;
        if (Build.VERSION.SDK_INT < 19) {
            return true;
        }
        if (zzzq == null && (activityManager = (ActivityManager)context.getSystemService("activity")) != null) {
            zzzq = activityManager.isLowRamDevice();
        }
        return Objects.equal(zzzq, Boolean.TRUE);
    }

    public static boolean isChromeOsDevice(Context context) {
        if (zzzs == null) {
            zzzs = context.getPackageManager().hasSystemFeature(FEATURE_CHROME_OS);
        }
        return zzzs;
    }

    public static boolean isPixelDevice(Context context) {
        if (zzzv == null) {
            zzzv = context.getPackageManager().hasSystemFeature(FEATURE_PIXEL);
        }
        return zzzv;
    }

    @VisibleForTesting
    public static void setIsWearableForTest(boolean bl) {
        zzzn = bl;
    }

    @VisibleForTesting
    public static void setIsSideWinderForTest(boolean bl) {
        zzzo = bl;
    }

    @VisibleForTesting
    public static void setIsLatchskyForTest(boolean bl) {
        zzzp = bl;
    }

    @VisibleForTesting
    public static void setIsIoTForTest(boolean bl) {
        zzzr = bl;
    }

    @VisibleForTesting
    public static void setIsAutoForTest(boolean bl) {
        zzzt = bl;
    }

    @VisibleForTesting
    public static void setIsTvForTest(boolean bl) {
        zzzu = bl;
    }

    @VisibleForTesting
    public static void setIsLowRamForTest(boolean bl) {
        zzzq = bl;
    }

    @VisibleForTesting
    public static void setIsPixelForTest(boolean bl) {
        zzzv = bl;
    }

    @VisibleForTesting
    public static void resetForTest() {
        zzzm = null;
        zzzl = null;
        zzzn = null;
        zzzo = null;
        zzzp = null;
        zzzq = null;
        zzzr = null;
        zzzs = null;
        zzzt = null;
        zzzu = null;
        zzzv = null;
    }
}

