/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import com.google.android.gms.common.internal.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ListUtils {
    public static <T> ArrayList<T> copyAndRemoveElementFromListIfPresent(List<T> list, T t) {
        int n = list.size();
        ArrayList<T> arrayList = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            T t2 = list.get(i);
            if (t != null && t.equals(t2)) continue;
            arrayList.add(t2);
        }
        return arrayList;
    }

    public static <T> ArrayList<T> copyAndRemoveElementsFromListIfPresent(List<T> list, Collection<T> collection) {
        Preconditions.checkNotNull(collection);
        int n = list.size();
        ArrayList<T> arrayList = new ArrayList<T>(n);
        for (T t : list) {
            if (collection.contains(t)) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    private ListUtils() {
    }
}

