/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.WorkSource;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.wrappers.Wrappers;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WorkSourceUtil {
    private static final int zzaam = Process.myUid();
    public static final String TAG = "WorkSourceUtil";
    private static final Method zzaan = WorkSourceUtil.zzdf();
    private static final Method zzaao = WorkSourceUtil.zzdg();
    private static final Method zzaap = WorkSourceUtil.zzdh();
    private static final Method zzaaq = WorkSourceUtil.zzdi();
    private static final Method zzaar = WorkSourceUtil.zzdj();
    private static final Method zzaas = WorkSourceUtil.zzdk();
    private static final Method zzaat = WorkSourceUtil.zzdl();

    private WorkSourceUtil() {
    }

    public static WorkSource fromUidAndPackage(int n, String string2) {
        WorkSource workSource = new WorkSource();
        WorkSourceUtil.add(workSource, n, string2);
        return workSource;
    }

    @Nullable
    public static WorkSource fromPackage(Context context, @Nullable String string2) {
        ApplicationInfo applicationInfo;
        if (context == null || context.getPackageManager() == null || string2 == null) {
            return null;
        }
        try {
            applicationInfo = Wrappers.packageManager(context).getApplicationInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(string2);
            Log.e((String)TAG, (String)(string3.length() != 0 ? "Could not find package: ".concat(string3) : new String("Could not find package: ")));
            return null;
        }
        if (applicationInfo == null) {
            String string4 = String.valueOf(string2);
            Log.e((String)TAG, (String)(string4.length() != 0 ? "Could not get applicationInfo from package: ".concat(string4) : new String("Could not get applicationInfo from package: ")));
            return null;
        }
        return WorkSourceUtil.fromUidAndPackage(applicationInfo.uid, string2);
    }

    public static void add(WorkSource workSource, int n, @Nullable String string2) {
        if (zzaao != null) {
            if (string2 == null) {
                string2 = "";
            }
            try {
                zzaao.invoke((Object)workSource, n, string2);
                return;
            }
            catch (Exception exception) {
                Log.wtf((String)TAG, (String)"Unable to assign blame through WorkSource", (Throwable)exception);
                return;
            }
        }
        if (zzaan != null) {
            try {
                zzaan.invoke((Object)workSource, n);
                return;
            }
            catch (Exception exception) {
                Log.wtf((String)TAG, (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
    }

    public static WorkSource fromPackageAndModuleExperimentalPi(Context context, String string2, String string3) {
        if (context == null || context.getPackageManager() == null || string3 == null || string2 == null) {
            Log.w((String)TAG, (String)"Unexpected null arguments");
            return null;
        }
        int n = WorkSourceUtil.zzc(context, string2);
        if (n < 0) {
            return null;
        }
        WorkSource workSource = new WorkSource();
        String string4 = string3;
        String string5 = string2;
        int n2 = n;
        WorkSource workSource2 = workSource;
        if (zzaas == null || zzaat == null) {
            WorkSourceUtil.add(workSource2, n2, string5);
        } else {
            try {
                Object object = zzaas.invoke((Object)workSource2, new Object[0]);
                if (n2 != zzaam) {
                    zzaat.invoke(object, n2, string5);
                }
                zzaat.invoke(object, zzaam, string4);
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"Unable to assign chained blame through WorkSource", (Throwable)exception);
            }
        }
        return workSource;
    }

    public static int size(WorkSource workSource) {
        if (zzaap != null) {
            try {
                return (Integer)zzaap.invoke((Object)workSource, new Object[0]);
            }
            catch (Exception exception) {
                Log.wtf((String)TAG, (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return 0;
    }

    public static int get(WorkSource workSource, int n) {
        if (zzaaq != null) {
            try {
                return (Integer)zzaaq.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)TAG, (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return 0;
    }

    @Nullable
    public static String getName(WorkSource workSource, int n) {
        if (zzaar != null) {
            try {
                return (String)zzaar.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)TAG, (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return null;
    }

    public static List<String> getNames(@Nullable WorkSource workSource) {
        int n = workSource == null ? 0 : WorkSourceUtil.size(workSource);
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String string2 = WorkSourceUtil.getName(workSource, i);
            if (Strings.isEmptyOrWhitespace(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean hasWorkSourcePermission(Context context) {
        if (context == null) {
            return false;
        }
        if (context.getPackageManager() == null) {
            return false;
        }
        return Wrappers.packageManager(context).checkPermission("android.permission.UPDATE_DEVICE_STATS", context.getPackageName()) == 0;
    }

    private static int zzc(Context context, String string2) {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = Wrappers.packageManager(context).getApplicationInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(string2);
            Log.e((String)TAG, (String)(string3.length() != 0 ? "Could not find package: ".concat(string3) : new String("Could not find package: ")));
            return -1;
        }
        if (applicationInfo == null) {
            String string4 = String.valueOf(string2);
            Log.e((String)TAG, (String)(string4.length() != 0 ? "Could not get applicationInfo from package: ".concat(string4) : new String("Could not get applicationInfo from package: ")));
            return -1;
        }
        return applicationInfo.uid;
    }

    private static Method zzdf() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("add", Integer.TYPE);
        }
        catch (Exception exception) {}
        return method;
    }

    private static Method zzdg() {
        Method method = null;
        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
            try {
                method = WorkSource.class.getMethod("add", Integer.TYPE, String.class);
            }
            catch (Exception exception) {}
        }
        return method;
    }

    private static Method zzdh() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("size", new Class[0]);
        }
        catch (Exception exception) {}
        return method;
    }

    private static Method zzdi() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("get", Integer.TYPE);
        }
        catch (Exception exception) {}
        return method;
    }

    private static Method zzdj() {
        Method method = null;
        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
            try {
                method = WorkSource.class.getMethod("getName", Integer.TYPE);
            }
            catch (Exception exception) {}
        }
        return method;
    }

    private static final Method zzdk() {
        Method method = null;
        if (PlatformVersion.isAtLeastP()) {
            try {
                method = WorkSource.class.getMethod("createWorkChain", new Class[0]);
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"Missing WorkChain API createWorkChain", (Throwable)exception);
            }
        }
        return method;
    }

    @SuppressLint(value={"PrivateApi"})
    private static final Method zzdl() {
        Method method = null;
        if (PlatformVersion.isAtLeastP()) {
            try {
                method = Class.forName("android.os.WorkSource$WorkChain").getMethod("addNode", Integer.TYPE, String.class);
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"Missing WorkChain class", (Throwable)exception);
            }
        }
        return method;
    }
}

