/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamite;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.IDynamiteLoader;
import com.google.android.gms.dynamite.IDynamiteLoaderV2;
import com.google.android.gms.dynamite.zzc;
import com.google.android.gms.dynamite.zzd;
import com.google.android.gms.dynamite.zze;
import com.google.android.gms.dynamite.zzf;
import com.google.android.gms.dynamite.zzg;
import com.google.android.gms.dynamite.zzh;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.concurrent.GuardedBy;

public final class DynamiteModule {
    @GuardedBy(value="DynamiteModule.class")
    private static Boolean zzabr;
    @GuardedBy(value="DynamiteModule.class")
    private static IDynamiteLoader zzabs;
    @GuardedBy(value="DynamiteModule.class")
    private static IDynamiteLoaderV2 zzabt;
    @GuardedBy(value="DynamiteModule.class")
    private static String zzabu;
    private static final ThreadLocal<zza> zzabv;
    private static final VersionPolicy.IVersions zzabw;
    public static final VersionPolicy PREFER_REMOTE;
    public static final VersionPolicy PREFER_LOCAL;
    public static final VersionPolicy PREFER_HIGHEST_OR_LOCAL_VERSION;
    public static final VersionPolicy PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING;
    public static final VersionPolicy PREFER_HIGHEST_OR_REMOTE_VERSION;
    public static final VersionPolicy PREFER_HIGHEST_OR_REMOTE_VERSION_NO_FORCE_STAGING;
    private final Context zzabx;

    /*
     * Loose catch block
     */
    public static DynamiteModule load(Context context, VersionPolicy versionPolicy, String string2) throws LoadingException {
        zza zza2 = zzabv.get();
        zza zza3 = new zza(null);
        zzabv.set(zza3);
        try {
            VersionPolicy.SelectionResult selectionResult = versionPolicy.selectModule(context, string2, zzabw);
            int n = selectionResult.localVersion;
            int n2 = selectionResult.remoteVersion;
            Log.i((String)"DynamiteModule", (String)new StringBuilder(68 + String.valueOf(string2).length() + String.valueOf(string2).length()).append("Considering local module ").append(string2).append(":").append(n).append(" and remote module ").append(string2).append(":").append(n2).toString());
            if (selectionResult.selection == 0 || selectionResult.selection == -1 && selectionResult.localVersion == 0 || selectionResult.selection == 1 && selectionResult.remoteVersion == 0) {
                n = selectionResult.localVersion;
                n2 = selectionResult.remoteVersion;
                throw new LoadingException(new StringBuilder(91).append("No acceptable module found. Local version is ").append(n).append(" and remote version is ").append(n2).append(".").toString(), null);
            }
            if (selectionResult.selection == -1) {
                DynamiteModule dynamiteModule = DynamiteModule.zzd(context, string2);
                return dynamiteModule;
            }
            if (selectionResult.selection == 1) {
                try {
                    DynamiteModule dynamiteModule = DynamiteModule.zza(context, string2, selectionResult.remoteVersion);
                    return dynamiteModule;
                }
                catch (LoadingException loadingException) {
                    block12: {
                        DynamiteModule dynamiteModule;
                        block13: {
                            String string3 = String.valueOf(loadingException.getMessage());
                            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load remote module: ".concat(string3) : new String("Failed to load remote module: ")));
                            if (selectionResult.localVersion == 0 || versionPolicy.selectModule((Context)context, (String)string2, (VersionPolicy.IVersions)new zzb((int)selectionResult.localVersion, (int)0)).selection != -1) break block12;
                            dynamiteModule = DynamiteModule.zzd(context, string2);
                            if (zza3.zzaby == null) break block13;
                            zza3.zzaby.close();
                        }
                        zzabv.set(zza2);
                        return dynamiteModule;
                    }
                    throw new LoadingException("Remote load failed. No local fallback found.", loadingException, null);
                }
            }
            n = selectionResult.selection;
            throw new LoadingException(new StringBuilder(47).append("VersionPolicy returned invalid code:").append(n).toString(), null);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (zza3.zzaby != null) {
                zza3.zzaby.close();
            }
            zzabv.set(zza2);
        }
    }

    public static int getLocalVersion(Context context, String string2) {
        try {
            Class<?> clazz = context.getApplicationContext().getClassLoader().loadClass(new StringBuilder(61 + String.valueOf(string2).length()).append("com.google.android.gms.dynamite.descriptors.").append(string2).append(".ModuleDescriptor").toString());
            Field field = clazz.getDeclaredField("MODULE_ID");
            Field field2 = clazz.getDeclaredField("MODULE_VERSION");
            if (!field.get(null).equals(string2)) {
                String string3 = String.valueOf(field.get(null));
                Log.e((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Module descriptor id '").append(string3).append("' didn't match expected id '").append(string2).append("'").toString());
                return 0;
            }
            return field2.getInt(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)"DynamiteModule", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("Local module descriptor class for ").append(string2).append(" not found.").toString());
        }
        catch (Exception exception) {
            String string4 = String.valueOf(exception.getMessage());
            Log.e((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to load module descriptor class: ".concat(string4) : new String("Failed to load module descriptor class: ")));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRemoteVersion(Context context, String string2, boolean bl) {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            Boolean bl2 = zzabr;
            if (bl2 == null) {
                try {
                    Class<?> clazz2 = context.getApplicationContext().getClassLoader().loadClass(DynamiteLoaderClassLoader.class.getName());
                    Field field = clazz2.getDeclaredField("sClassLoader");
                    Class<?> clazz3 = clazz2;
                    synchronized (clazz3) {
                        Object object = (ClassLoader)field.get(null);
                        if (object != null) {
                            if (object == ClassLoader.getSystemClassLoader()) {
                                bl2 = Boolean.FALSE;
                            } else {
                                try {
                                    DynamiteModule.zza(object);
                                }
                                catch (LoadingException loadingException) {}
                                bl2 = Boolean.TRUE;
                            }
                        } else if ("com.google.android.gms".equals(context.getApplicationContext().getPackageName())) {
                            field.set(null, ClassLoader.getSystemClassLoader());
                            bl2 = Boolean.FALSE;
                        } else {
                            try {
                                int n = DynamiteModule.zzb(context, string2, bl);
                                if (zzabu == null || zzabu.isEmpty()) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 16, 1, 2, 4, 20, 6, 22, 7, 15] lbl30 : MonitorExitStatement: MONITOREXIT : var8_9
                                    // ** MonitorExit[var4_3] (shouldn't be in output)
                                    return n;
                                }
                                object = new zzh(zzabu, ClassLoader.getSystemClassLoader());
                                DynamiteModule.zza(object);
                                field.set(null, object);
                                zzabr = Boolean.TRUE;
                                // MONITOREXIT @DISABLED, blocks:[0, 16, 1, 2, 4, 20, 6, 22, 7] lbl37 : MonitorExitStatement: MONITOREXIT : var8_9
                                // ** MonitorExit[var4_3] (shouldn't be in output)
                                return n;
                            }
                            catch (LoadingException loadingException) {
                                field.set(null, ClassLoader.getSystemClassLoader());
                                bl2 = Boolean.FALSE;
                            }
                        }
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    String string3 = String.valueOf(reflectiveOperationException);
                    Log.w((String)"DynamiteModule", (String)new StringBuilder(30 + String.valueOf(string3).length()).append("Failed to load module via V2: ").append(string3).toString());
                    bl2 = Boolean.FALSE;
                }
                zzabr = bl2;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (bl2.booleanValue()) {
                try {
                    return DynamiteModule.zzb(context, string2, bl);
                }
                catch (LoadingException loadingException) {
                    String string4 = String.valueOf(loadingException.getMessage());
                    Log.w((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to retrieve remote module version: ".concat(string4) : new String("Failed to retrieve remote module version: ")));
                    return 0;
                }
            }
            return DynamiteModule.zza(context, string2, bl);
        }
    }

    private static int zza(Context context, String string2, boolean bl) {
        IDynamiteLoader iDynamiteLoader = DynamiteModule.zzg(context);
        if (iDynamiteLoader == null) {
            return 0;
        }
        try {
            return iDynamiteLoader.getModuleVersion2(ObjectWrapper.wrap(context), string2, bl);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(remoteException.getMessage());
            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to retrieve remote module version: ".concat(string3) : new String("Failed to retrieve remote module version: ")));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int zzb(Context context, String string2, boolean bl) throws LoadingException {
        try (Cursor cursor = null;){
            cursor = DynamiteModule.queryForDynamiteModule(context, string2, bl);
            if (cursor == null || !cursor.moveToFirst()) {
                Log.w((String)"DynamiteModule", (String)"Failed to retrieve remote module version.");
                throw new LoadingException("Failed to connect to dynamite module ContentResolver.", null);
            }
            int n = cursor.getInt(0);
            if (n <= 0) return n;
            Object object = DynamiteModule.class;
            synchronized (DynamiteModule.class) {
                zzabu = cursor.getString(2);
                // ** MonitorExit[var5_6] (shouldn't be in output)
                object = zzabv.get();
                if (object == null || ((zza)object).zzaby != null) return n;
                ((zza)object).zzaby = cursor;
                cursor = null;
                return n;
            }
        }
    }

    public static int getRemoteVersion(Context context, String string2) {
        return DynamiteModule.getRemoteVersion(context, string2, false);
    }

    public static Cursor queryForDynamiteModule(Context context, String string2, boolean bl) {
        return context.getContentResolver().query(DynamiteModule.getQueryUri(string2, bl), null, null, null, null);
    }

    public static Uri getQueryUri(String string2, boolean bl) {
        String string3 = bl ? "api_force_staging" : "api";
        return Uri.parse((String)new StringBuilder(42 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("content://com.google.android.gms.chimera/").append(string3).append("/").append(string2).toString());
    }

    private static DynamiteModule zzd(Context context, String string2) {
        String string3 = String.valueOf(string2);
        Log.i((String)"DynamiteModule", (String)(string3.length() != 0 ? "Selected local version of ".concat(string3) : new String("Selected local version of ")));
        return new DynamiteModule(context.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamiteModule zza(Context context, String string2, int n) throws LoadingException {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            Boolean bl = zzabr;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (bl == null) {
                throw new LoadingException("Failed to determine which loading route to use.", null);
            }
            if (bl.booleanValue()) {
                return DynamiteModule.zzc(context, string2, n);
            }
            return DynamiteModule.zzb(context, string2, n);
        }
    }

    private static DynamiteModule zzb(Context context, String string2, int n) throws LoadingException {
        IObjectWrapper iObjectWrapper;
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        IDynamiteLoader iDynamiteLoader = DynamiteModule.zzg(context);
        if (iDynamiteLoader == null) {
            throw new LoadingException("Failed to create IDynamiteLoader.", null);
        }
        try {
            iObjectWrapper = iDynamiteLoader.createModuleContext(ObjectWrapper.wrap(context), string2, n);
        }
        catch (RemoteException remoteException) {
            throw new LoadingException("Failed to load remote module.", remoteException, null);
        }
        if (ObjectWrapper.unwrap(iObjectWrapper) == null) {
            throw new LoadingException("Failed to load remote module.", null);
        }
        return new DynamiteModule((Context)ObjectWrapper.unwrap(iObjectWrapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDynamiteLoader zzg(Context context) {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            if (zzabs != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return zzabs;
            }
            if (GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context) != 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            try {
                IDynamiteLoader iDynamiteLoader = IDynamiteLoader.Stub.asInterface((IBinder)context.createPackageContext("com.google.android.gms", 3).getClassLoader().loadClass("com.google.android.gms.chimera.container.DynamiteLoaderImpl").newInstance());
                if (iDynamiteLoader != null) {
                    zzabs = iDynamiteLoader;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return iDynamiteLoader;
                }
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.e((String)"DynamiteModule", (String)(string2.length() != 0 ? "Failed to load IDynamiteLoader from GmsCore: ".concat(string2) : new String("Failed to load IDynamiteLoader from GmsCore: ")));
            }
            return null;
        }
    }

    public final Context getModuleContext() {
        return this.zzabx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamiteModule zzc(Context context, String string2, int n) throws LoadingException {
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        Object object = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            IDynamiteLoaderV2 iDynamiteLoaderV2 = zzabt;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (iDynamiteLoaderV2 == null) {
                throw new LoadingException("DynamiteLoaderV2 was not cached.", null);
            }
            object = zzabv.get();
            if (object == null || ((zza)object).zzaby == null) {
                throw new LoadingException("No result cursor", null);
            }
            Context context2 = DynamiteModule.zza(context.getApplicationContext(), string2, n, ((zza)object).zzaby, iDynamiteLoaderV2);
            if (context2 == null) {
                throw new LoadingException("Failed to get module context", null);
            }
            return new DynamiteModule(context2);
        }
    }

    private static Context zza(Context context, String string2, int n, Cursor cursor, IDynamiteLoaderV2 iDynamiteLoaderV2) {
        try {
            return (Context)ObjectWrapper.unwrap(iDynamiteLoaderV2.loadModule2(ObjectWrapper.wrap(context), string2, n, ObjectWrapper.wrap(cursor)));
        }
        catch (Exception exception) {
            String string3 = String.valueOf(exception.toString());
            Log.e((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load DynamiteLoader: ".concat(string3) : new String("Failed to load DynamiteLoader: ")));
            return null;
        }
    }

    @GuardedBy(value="DynamiteModule.class")
    private static void zza(ClassLoader classLoader) throws LoadingException {
        try {
            zzabt = IDynamiteLoaderV2.Stub.asInterface((IBinder)classLoader.loadClass("com.google.android.gms.dynamiteloader.DynamiteLoaderV2").getConstructor(new Class[0]).newInstance(new Object[0]));
            return;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new LoadingException("Failed to instantiate dynamite loader", reflectiveOperationException, null);
        }
    }

    public final IBinder instantiate(String string2) throws LoadingException {
        try {
            return (IBinder)this.zzabx.getClassLoader().loadClass(string2).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            String string3 = String.valueOf(string2);
            throw new LoadingException(string3.length() != 0 ? "Failed to instantiate module class: ".concat(string3) : new String("Failed to instantiate module class: "), reflectiveOperationException, null);
        }
    }

    private DynamiteModule(Context context) {
        this.zzabx = Preconditions.checkNotNull(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static synchronized void resetInternalStateForTesting() {
        zzabs = null;
        zzabt = null;
        zzabu = null;
        zzabr = null;
        Class<DynamiteLoaderClassLoader> clazz = DynamiteLoaderClassLoader.class;
        synchronized (DynamiteLoaderClassLoader.class) {
            DynamiteLoaderClassLoader.sClassLoader = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @VisibleForTesting
    public static synchronized void setUseV2ForTesting(Boolean bl) {
        zzabr = bl;
    }

    @VisibleForTesting
    public static synchronized Boolean getUseV2ForTesting() {
        return zzabr;
    }

    static {
        zzabv = new ThreadLocal();
        zzabw = new com.google.android.gms.dynamite.zza();
        PREFER_REMOTE = new com.google.android.gms.dynamite.zzb();
        PREFER_LOCAL = new zzc();
        PREFER_HIGHEST_OR_LOCAL_VERSION = new zzd();
        PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING = new zze();
        PREFER_HIGHEST_OR_REMOTE_VERSION = new zzf();
        PREFER_HIGHEST_OR_REMOTE_VERSION_NO_FORCE_STAGING = new zzg();
    }

    @DynamiteApi
    public static class DynamiteLoaderClassLoader {
        @GuardedBy(value="DynamiteLoaderClassLoader.class")
        public static ClassLoader sClassLoader;

        public DynamiteLoaderClassLoader() {
        }
    }

    private static final class zza {
        public Cursor zzaby;

        private zza() {
        }

        /* synthetic */ zza(com.google.android.gms.dynamite.zza zza2) {
            this();
        }
    }

    public static class LoadingException
    extends Exception {
        private LoadingException(String string2) {
            super(string2);
        }

        private LoadingException(String string2, Throwable throwable) {
            super(string2, throwable);
        }

        /* synthetic */ LoadingException(String string2, com.google.android.gms.dynamite.zza zza2) {
            this(string2);
        }

        /* synthetic */ LoadingException(String string2, Throwable throwable, com.google.android.gms.dynamite.zza zza2) {
            this(string2, throwable);
        }
    }

    private static final class zzb
    implements VersionPolicy.IVersions {
        private final int zzabz;
        private final int zzaca;

        public zzb(int n, int n2) {
            this.zzabz = n;
            this.zzaca = 0;
        }

        @Override
        public final int getRemoteVersion(Context context, String string2, boolean bl) {
            return 0;
        }

        @Override
        public final int getLocalVersion(Context context, String string2) {
            return this.zzabz;
        }
    }

    public static interface VersionPolicy {
        public SelectionResult selectModule(Context var1, String var2, IVersions var3) throws LoadingException;

        public static class SelectionResult {
            public int localVersion = 0;
            public int remoteVersion = 0;
            public int selection = 0;

            public SelectionResult() {
            }
        }

        public static interface IVersions {
            public int getRemoteVersion(Context var1, String var2, boolean var3) throws LoadingException;

            public int getLocalVersion(Context var1, String var2);
        }
    }
}

