/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.BinderThread;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ConnectionInfo;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.GmsServiceEndpoint;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.IGmsCallbacks;
import com.google.android.gms.common.internal.IGmsServiceBroker;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

public abstract class BaseGmsClient<T extends IInterface> {
    public static final int CONNECT_STATE_DISCONNECTED = 1;
    public static final int CONNECT_STATE_REMOTE_CONNECTING = 2;
    public static final int CONNECT_STATE_LOCAL_CONNECTING = 3;
    public static final int CONNECT_STATE_CONNECTED = 4;
    public static final int CONNECT_STATE_DISCONNECTING = 5;
    private static final Feature[] zzqz = new Feature[0];
    public static final String KEY_PENDING_INTENT = "pendingIntent";
    private int zzra;
    private long zzrb;
    private long zzrc;
    private int zzrd;
    private long zzre;
    @VisibleForTesting
    private GmsServiceEndpoint zzrf;
    public static final String DEFAULT_ACCOUNT = "<<default account>>";
    private final Context mContext;
    private final Looper zzcn;
    private final GmsClientSupervisor zzrg;
    private final GoogleApiAvailabilityLight zzgk;
    final Handler mHandler;
    private final Object mLock = new Object();
    private final Object zzrh = new Object();
    @GuardedBy(value="mServiceBrokerLock")
    private IGmsServiceBroker zzri;
    @VisibleForTesting
    protected ConnectionProgressReportCallbacks mConnectionProgressReportCallbacks;
    @GuardedBy(value="mLock")
    private T zzrj;
    private final ArrayList<CallbackProxy<?>> zzrk = new ArrayList();
    @GuardedBy(value="mLock")
    private GmsServiceConnection zzrl;
    @GuardedBy(value="mLock")
    private int zzrm = 1;
    private final BaseConnectionCallbacks zzrn;
    private final BaseOnConnectionFailedListener zzro;
    private final int zzrp;
    private final String zzrq;
    private ConnectionResult zzrr = null;
    private boolean zzrs = false;
    private volatile ConnectionInfo zzrt = null;
    @VisibleForTesting
    protected AtomicInteger mDisconnectCount = new AtomicInteger(0);
    public static final String FEATURE_GOOGLE_ME = "service_googleme";
    public static final String[] GOOGLE_PLUS_REQUIRED_FEATURES = new String[]{"service_esmobile", "service_googleme"};

    protected BaseGmsClient(Context context, Looper looper, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener, String string2) {
        this(context, looper, GmsClientSupervisor.getInstance(context), GoogleApiAvailabilityLight.getInstance(), n, Preconditions.checkNotNull(baseConnectionCallbacks), Preconditions.checkNotNull(baseOnConnectionFailedListener), string2);
    }

    @VisibleForTesting
    protected BaseGmsClient(Context context, Looper looper, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener, String string2) {
        this.mContext = Preconditions.checkNotNull(context, "Context must not be null");
        this.zzcn = Preconditions.checkNotNull(looper, "Looper must not be null");
        this.zzrg = Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzgk = Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.mHandler = new zzb(looper);
        this.zzrp = n;
        this.zzrn = baseConnectionCallbacks;
        this.zzro = baseOnConnectionFailedListener;
        this.zzrq = string2;
    }

    @VisibleForTesting
    protected BaseGmsClient(Context context, Handler handler, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener) {
        this.mContext = Preconditions.checkNotNull(context, "Context must not be null");
        this.mHandler = Preconditions.checkNotNull(handler, "Handler must not be null");
        this.zzcn = handler.getLooper();
        this.zzrg = Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzgk = Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.zzrp = n;
        this.zzrn = baseConnectionCallbacks;
        this.zzro = baseOnConnectionFailedListener;
        this.zzrq = null;
    }

    @NonNull
    protected abstract String getStartServiceAction();

    protected String getStartServicePackage() {
        return "com.google.android.gms";
    }

    protected int getServiceBindFlags() {
        return 129;
    }

    @NonNull
    protected abstract String getServiceDescriptor();

    @Nullable
    protected final String getRealClientName() {
        if (this.zzrq == null) {
            return this.mContext.getClass().getName();
        }
        return this.zzrq;
    }

    @Nullable
    protected String getLocalStartServiceAction() {
        return null;
    }

    private final void zza(ConnectionInfo connectionInfo) {
        this.zzrt = connectionInfo;
    }

    @VisibleForTesting
    public void setConnectionInfoForTesting(ConnectionInfo connectionInfo) {
        ConnectionInfo connectionInfo2;
        this.zzrt = connectionInfo2 = connectionInfo;
    }

    @Nullable
    public final Feature[] getAvailableFeatures() {
        ConnectionInfo connectionInfo = this.zzrt;
        if (connectionInfo == null) {
            return null;
        }
        return connectionInfo.getAvailableFeatures();
    }

    @Nullable
    protected abstract T createServiceInterface(IBinder var1);

    @CallSuper
    protected void onConnectedLocked(@NonNull T t) {
        this.zzrc = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionSuspended(int n) {
        this.zzra = n;
        this.zzrb = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzrd = connectionResult.getErrorCode();
        this.zzre = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, T t) {
        Preconditions.checkArgument(n == 4 == (t != null));
        Object object = this.mLock;
        synchronized (object) {
            this.zzrm = n;
            this.zzrj = t;
            this.onSetConnectState(n, t);
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    BaseGmsClient baseGmsClient = this;
                    if (baseGmsClient.zzrl != null && baseGmsClient.zzrf != null) {
                        String string3 = baseGmsClient.zzrf.zzcw();
                        string2 = baseGmsClient.zzrf.getPackageName();
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        baseGmsClient.zzrg.unbindService(baseGmsClient.zzrf.zzcw(), baseGmsClient.zzrf.getPackageName(), baseGmsClient.zzrf.getBindFlags(), baseGmsClient.zzrl, baseGmsClient.getRealClientName());
                        baseGmsClient.mDisconnectCount.incrementAndGet();
                    }
                    baseGmsClient.zzrl = baseGmsClient.new GmsServiceConnection(baseGmsClient.mDisconnectCount.get());
                    BaseGmsClient baseGmsClient2 = baseGmsClient;
                    GmsServiceEndpoint gmsServiceEndpoint = baseGmsClient.zzrf = baseGmsClient2.zzrm == 3 && baseGmsClient2.getLocalStartServiceAction() != null ? new GmsServiceEndpoint(baseGmsClient2.getContext().getPackageName(), baseGmsClient2.getLocalStartServiceAction(), true, baseGmsClient2.getServiceBindFlags()) : new GmsServiceEndpoint(baseGmsClient2.getStartServicePackage(), baseGmsClient2.getStartServiceAction(), false, baseGmsClient2.getServiceBindFlags());
                    if (baseGmsClient.zzrg.bindService(baseGmsClient.zzrf.zzcw(), baseGmsClient.zzrf.getPackageName(), baseGmsClient.zzrf.getBindFlags(), baseGmsClient.zzrl, baseGmsClient.getRealClientName())) break;
                    string2 = baseGmsClient.zzrf.zzcw();
                    String string4 = baseGmsClient.zzrf.getPackageName();
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string4).toString());
                    baseGmsClient.onPostServiceBindingHandler(16, null, baseGmsClient.mDisconnectCount.get());
                    break;
                }
                case 4: {
                    this.onConnectedLocked(t);
                    break;
                }
                case 1: {
                    BaseGmsClient baseGmsClient = this;
                    if (baseGmsClient.zzrl == null) break;
                    baseGmsClient.zzrg.unbindService(baseGmsClient.getStartServiceAction(), baseGmsClient.getStartServicePackage(), baseGmsClient.getServiceBindFlags(), baseGmsClient.zzrl, baseGmsClient.getRealClientName());
                    baseGmsClient.zzrl = null;
                }
            }
            return;
        }
    }

    void onSetConnectState(int n, T t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzrm != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    public void checkAvailabilityAndConnect() {
        int n = this.zzgk.isGooglePlayServicesAvailable(this.mContext, this.getMinApkVersion());
        if (n != 0) {
            this.zza(1, null);
            this.triggerNotAvailable(new LegacyClientCallbackAdapter(), n, null);
            return;
        }
        this.connect(new LegacyClientCallbackAdapter());
    }

    public void connect(@NonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        this.mConnectionProgressReportCallbacks = Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzrm == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzrm == 2 || this.zzrm == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzcq() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzrm == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.mDisconnectCount.incrementAndGet();
        Object object = this.zzrk;
        synchronized (object) {
            int n = this.zzrk.size();
            for (int i = 0; i < n; ++i) {
                this.zzrk.get(i).removeListener();
            }
            this.zzrk.clear();
        }
        object = this.zzrh;
        synchronized (object) {
            this.zzri = null;
        }
        this.zza(1, null);
    }

    public void triggerConnectionSuspended(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, this.mDisconnectCount.get(), n));
    }

    private final void zzj(int n) {
        int n2;
        if (this.zzcq()) {
            n2 = 5;
            this.zzrs = true;
        } else {
            n2 = 4;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(n2, this.mDisconnectCount.get(), 16));
    }

    @VisibleForTesting
    protected void triggerNotAvailable(@NonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks, int n, @Nullable PendingIntent pendingIntent) {
        this.mConnectionProgressReportCallbacks = Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.mDisconnectCount.get(), n, (Object)pendingIntent));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzcn;
    }

    public Account getAccount() {
        return null;
    }

    public Feature[] getRequiredFeatures() {
        return zzqz;
    }

    public Feature[] getApiFeatures() {
        return zzqz;
    }

    public final Account getAccountOrDefault() {
        if (this.getAccount() != null) {
            return this.getAccount();
        }
        return new Account(DEFAULT_ACCOUNT, "com.google");
    }

    protected Bundle getGetServiceRequestExtraArgs() {
        return new Bundle();
    }

    protected void onPostInitHandler(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new PostInitCallback(n, iBinder, bundle)));
    }

    protected void onPostServiceBindingHandler(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n2, -1, (Object)new PostServiceBindingCallback(n, bundle)));
    }

    protected final void checkConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @VisibleForTesting
    public final Handler getHandlerForTesting() {
        return this.mHandler;
    }

    public Bundle getConnectionHint() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getService() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzrm == 5) {
                throw new DeadObjectException();
            }
            this.checkConnected();
            Preconditions.checkState(this.zzrj != null, "Client is connected but service is null");
            return this.zzrj;
        }
    }

    @VisibleForTesting
    public final void setServiceForTesting(T t) {
        this.zza(t != null ? 4 : 1, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void setServiceBrokerForTesting(IGmsServiceBroker iGmsServiceBroker) {
        Object object = this.zzrh;
        synchronized (object) {
            this.zzri = iGmsServiceBroker;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final IGmsServiceBroker getServiceBrokerForTesting() {
        Object object = this.zzrh;
        synchronized (object) {
            return this.zzri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void doCallbackDEPRECATED(CallbackProxy<?> callbackProxy) {
        ArrayList<CallbackProxy<?>> arrayList = this.zzrk;
        synchronized (arrayList) {
            this.zzrk.add(callbackProxy);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, this.mDisconnectCount.get(), -1, callbackProxy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void getRemoteService(IAccountAccessor iAccountAccessor, Set<Scope> set) {
        Bundle bundle = this.getGetServiceRequestExtraArgs();
        GetServiceRequest getServiceRequest = new GetServiceRequest(this.zzrp).setCallingPackage(this.mContext.getPackageName()).setExtraArgs(bundle);
        if (set != null) {
            getServiceRequest.setScopes(set);
        }
        if (this.requiresSignIn()) {
            getServiceRequest.setClientRequestedAccount(this.getAccountOrDefault()).setAuthenticatedAccount(iAccountAccessor);
        } else if (this.requiresAccount()) {
            getServiceRequest.setClientRequestedAccount(this.getAccount());
        }
        getServiceRequest.setClientRequiredFeatures(this.getRequiredFeatures());
        getServiceRequest.setClientApiFeatures(this.getApiFeatures());
        try {
            Object object = this.zzrh;
            synchronized (object) {
                if (this.zzri != null) {
                    this.zzri.getService(new GmsCallbacks(this, this.mDisconnectCount.get()), getServiceRequest);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.triggerConnectionSuspended(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.onPostInitHandler(8, null, null, this.mDisconnectCount.get());
            return;
        }
    }

    public boolean requiresSignIn() {
        return false;
    }

    public void onUserSignOut(@NonNull SignOutCallbacks signOutCallbacks) {
        signOutCallbacks.onSignOutComplete();
    }

    public boolean requiresAccount() {
        return false;
    }

    public boolean requiresGooglePlayServices() {
        return true;
    }

    public boolean providesSignIn() {
        return false;
    }

    public Intent getSignInIntent() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> getScopes() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        IGmsServiceBroker iGmsServiceBroker;
        T t;
        int n;
        Object object = this.mLock;
        synchronized (object) {
            n = this.zzrm;
            t = this.zzrj;
        }
        object = this.zzrh;
        synchronized (object) {
            iGmsServiceBroker = this.zzri;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.getServiceDescriptor()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (iGmsServiceBroker == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(iGmsServiceBroker.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzrc > 0L) {
            l = this.zzrc;
            string3 = ((DateFormat)object).format(new Date(this.zzrc));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzrb > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzra) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzra));
                }
            }
            l = this.zzrb;
            string3 = ((DateFormat)object).format(new Date(this.zzrb));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzre > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzrd));
            l = this.zzre;
            string3 = ((DateFormat)object).format(new Date(this.zzre));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IBinder getServiceBrokerBinder() {
        Object object = this.zzrh;
        synchronized (object) {
            if (this.zzri == null) {
                return null;
            }
            return this.zzri.asBinder();
        }
    }

    private final boolean zzcr() {
        if (this.zzrs) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getServiceDescriptor())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getLocalStartServiceAction())) {
            return false;
        }
        try {
            Class.forName(this.getServiceDescriptor());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public String getEndpointPackageName() {
        if (this.isConnected() && this.zzrf != null) {
            return this.zzrf.getPackageName();
        }
        throw new RuntimeException("Failed to connect when checking package");
    }

    public int getMinApkVersion() {
        return GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    @VisibleForTesting
    public static final class GmsCallbacks
    extends IGmsCallbacks.Stub {
        private BaseGmsClient zzrw;
        private final int zzrx;

        public GmsCallbacks(@NonNull BaseGmsClient baseGmsClient, int n) {
            this.zzrw = baseGmsClient;
            this.zzrx = n;
        }

        @Override
        @BinderThread
        public final void onAccountValidationComplete(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public final void onPostInitComplete(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            Preconditions.checkNotNull(this.zzrw, "onPostInitComplete can be called only once per call to getRemoteService");
            this.zzrw.onPostInitHandler(n, iBinder, bundle, this.zzrx);
            this.zzrw = null;
        }

        @Override
        @BinderThread
        public final void onPostInitCompleteWithConnectionInfo(int n, @NonNull IBinder iBinder, @NonNull ConnectionInfo connectionInfo) {
            Preconditions.checkNotNull(this.zzrw, "onPostInitCompleteWithConnectionInfo can be called only once per call togetRemoteService");
            Preconditions.checkNotNull(connectionInfo);
            this.zzrw.zza(connectionInfo);
            this.onPostInitComplete(n, iBinder, connectionInfo.getResolutionBundle());
        }
    }

    private abstract class zza
    extends CallbackProxy<Boolean> {
        public final int statusCode;
        public final Bundle resolution;

        @BinderThread
        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.resolution = bundle;
        }

        protected abstract boolean handleServiceSuccess();

        protected abstract void handleServiceFailure(ConnectionResult var1);

        @Override
        protected void deliverCallback(Boolean bl) {
            if (bl == null) {
                BaseGmsClient.this.zza(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.handleServiceSuccess()) break;
                    BaseGmsClient.this.zza(1, null);
                    this.handleServiceFailure(new ConnectionResult(8, null));
                    return;
                }
                case 10: {
                    BaseGmsClient.this.zza(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    BaseGmsClient.this.zza(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.resolution != null) {
                        pendingIntent = (PendingIntent)this.resolution.getParcelable(BaseGmsClient.KEY_PENDING_INTENT);
                    }
                    this.handleServiceFailure(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void onDeliverCallbackFailed() {
        }
    }

    protected final class PostInitCallback
    extends zza {
        public final IBinder service;

        @BinderThread
        public PostInitCallback(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.service = iBinder;
        }

        @Override
        protected final void handleServiceFailure(ConnectionResult connectionResult) {
            if (BaseGmsClient.this.zzro != null) {
                BaseGmsClient.this.zzro.onConnectionFailed(connectionResult);
            }
            BaseGmsClient.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected final boolean handleServiceSuccess() {
            String string2;
            try {
                string2 = this.service.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!BaseGmsClient.this.getServiceDescriptor().equals(string2)) {
                String string3 = BaseGmsClient.this.getServiceDescriptor();
                Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("service descriptor mismatch: ").append(string3).append(" vs. ").append(string2).toString());
                return false;
            }
            Object t = BaseGmsClient.this.createServiceInterface(this.service);
            if (t != null && (BaseGmsClient.this.zza(2, 4, t) || BaseGmsClient.this.zza(3, 4, t))) {
                BaseGmsClient.this.zzrr = null;
                Bundle bundle = BaseGmsClient.this.getConnectionHint();
                if (BaseGmsClient.this.zzrn != null) {
                    BaseGmsClient.this.zzrn.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class PostServiceBindingCallback
    extends zza {
        @BinderThread
        public PostServiceBindingCallback(@Nullable int n, Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected final void handleServiceFailure(ConnectionResult connectionResult) {
            BaseGmsClient.this.mConnectionProgressReportCallbacks.onReportServiceBinding(connectionResult);
            BaseGmsClient.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected final boolean handleServiceSuccess() {
            BaseGmsClient.this.mConnectionProgressReportCallbacks.onReportServiceBinding(ConnectionResult.RESULT_SUCCESS);
            return true;
        }
    }

    protected class LegacyClientCallbackAdapter
    implements ConnectionProgressReportCallbacks {
        public LegacyClientCallbackAdapter() {
        }

        @Override
        public void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                BaseGmsClient.this.getRemoteService(null, BaseGmsClient.this.getScopes());
                return;
            }
            if (BaseGmsClient.this.zzro != null) {
                BaseGmsClient.this.zzro.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class CallbackProxy<TListener> {
        private TListener zzli;
        private boolean zzrv;

        public CallbackProxy(TListener TListener) {
            this.zzli = TListener;
            this.zzrv = false;
        }

        protected abstract void deliverCallback(TListener var1);

        protected abstract void onDeliverCallbackFailed();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deliverCallback() {
            TListener TListener;
            CallbackProxy callbackProxy = this;
            synchronized (callbackProxy) {
                TListener = this.zzli;
                if (this.zzrv) {
                    String string2 = String.valueOf(this);
                    Log.w((String)"GmsClient", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Callback proxy ").append(string2).append(" being reused. This is not safe.").toString());
                }
            }
            if (TListener != null) {
                try {
                    this.deliverCallback(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.onDeliverCallbackFailed();
                    throw runtimeException;
                }
            } else {
                this.onDeliverCallbackFailed();
            }
            callbackProxy = this;
            synchronized (callbackProxy) {
                this.zzrv = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.removeListener();
            ArrayList arrayList = BaseGmsClient.this.zzrk;
            synchronized (arrayList) {
                BaseGmsClient.this.zzrk.remove(this);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener() {
            CallbackProxy callbackProxy = this;
            synchronized (callbackProxy) {
                this.zzli = null;
                return;
            }
        }
    }

    final class zzb
    extends Handler {
        public zzb(Looper looper) {
            super(looper);
        }

        public final void handleMessage(Message message) {
            if (BaseGmsClient.this.mDisconnectCount.get() != message.arg1) {
                if (zzb.zzb(message)) {
                    zzb.zza(message);
                }
                return;
            }
            if (!(message.what != 1 && message.what != 7 && message.what != 4 && message.what != 5 || BaseGmsClient.this.isConnecting())) {
                zzb.zza(message);
                return;
            }
            if (message.what == 4) {
                BaseGmsClient.this.zzrr = new ConnectionResult(message.arg2);
                if (BaseGmsClient.this.zzcr() && !BaseGmsClient.this.zzrs) {
                    BaseGmsClient.this.zza(3, null);
                    return;
                }
                ConnectionResult connectionResult = BaseGmsClient.this.zzrr != null ? BaseGmsClient.this.zzrr : new ConnectionResult(8);
                BaseGmsClient.this.mConnectionProgressReportCallbacks.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 5) {
                ConnectionResult connectionResult = BaseGmsClient.this.zzrr != null ? BaseGmsClient.this.zzrr : new ConnectionResult(8);
                BaseGmsClient.this.mConnectionProgressReportCallbacks.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 3) {
                PendingIntent pendingIntent = message.obj instanceof PendingIntent ? (PendingIntent)message.obj : null;
                ConnectionResult connectionResult = new ConnectionResult(message.arg2, pendingIntent);
                BaseGmsClient.this.mConnectionProgressReportCallbacks.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 6) {
                BaseGmsClient.this.zza(5, null);
                if (BaseGmsClient.this.zzrn != null) {
                    BaseGmsClient.this.zzrn.onConnectionSuspended(message.arg2);
                }
                BaseGmsClient.this.onConnectionSuspended(message.arg2);
                BaseGmsClient.this.zza(5, 1, null);
                return;
            }
            if (message.what == 2 && !BaseGmsClient.this.isConnected()) {
                zzb.zza(message);
                return;
            }
            if (zzb.zzb(message)) {
                ((CallbackProxy)message.obj).deliverCallback();
                return;
            }
            int n = message.what;
            Log.wtf((String)"GmsClient", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        private static void zza(Message message) {
            CallbackProxy callbackProxy = (CallbackProxy)message.obj;
            callbackProxy.onDeliverCallbackFailed();
            callbackProxy.unregister();
        }

        private static boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 7;
        }
    }

    public static interface SignOutCallbacks {
        public void onSignOutComplete();
    }

    public static interface ConnectionProgressReportCallbacks {
        public void onReportServiceBinding(@NonNull ConnectionResult var1);
    }

    public static interface BaseOnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface BaseConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }

    @VisibleForTesting
    public final class GmsServiceConnection
    implements ServiceConnection {
        private final int zzrx;

        public GmsServiceConnection(int n) {
            this.zzrx = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (iBinder == null) {
                BaseGmsClient.this.zzj(16);
                return;
            }
            Object object = BaseGmsClient.this.zzrh;
            synchronized (object) {
                BaseGmsClient.this.zzri = IGmsServiceBroker.Stub.asInterface(iBinder);
            }
            BaseGmsClient.this.onPostServiceBindingHandler(0, null, this.zzrx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceDisconnected(ComponentName componentName) {
            Object object = BaseGmsClient.this.zzrh;
            synchronized (object) {
                BaseGmsClient.this.zzri = null;
            }
            BaseGmsClient.this.mHandler.sendMessage(BaseGmsClient.this.mHandler.obtainMessage(6, this.zzrx, 1));
        }
    }
}

