/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.google.android.gms.common.wrappers.Wrappers;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AndroidUtilsLight {
    public static final String DIGEST_ALGORITHM_SHA1 = "SHA1";
    public static final String DIGEST_ALGORITHM_SHA512 = "SHA-512";

    public AndroidUtilsLight() {
    }

    public static byte[] getPackageCertificateHashBytes(Context context, String string2, String string3) throws PackageManager.NameNotFoundException {
        MessageDigest messageDigest;
        String string4 = string3;
        PackageInfo packageInfo = Wrappers.packageManager(context).getPackageInfo(string2, 64);
        if (packageInfo.signatures != null && packageInfo.signatures.length == 1 && (messageDigest = AndroidUtilsLight.getMessageDigest(string4)) != null) {
            return messageDigest.digest(packageInfo.signatures[0].toByteArray());
        }
        return null;
    }

    public static byte[] getPackageCertificateHashBytes(Context context, String string2) throws PackageManager.NameNotFoundException {
        return AndroidUtilsLight.getPackageCertificateHashBytes(context, string2, DIGEST_ALGORITHM_SHA1);
    }

    public static MessageDigest getMessageDigest(String string2) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string2);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }
}

