/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

public class Hex {
    private static final char[] zzzz = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] zzaaa = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public Hex() {
    }

    public static String bytesToStringUppercase(byte[] byArray) {
        return Hex.bytesToStringUppercase(byArray, false);
    }

    public static String bytesToStringUppercase(byte[] byArray, boolean bl) {
        int n = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(n << 1);
        for (int i = 0; !(i >= n || bl && i == n - 1 && (byArray[i] & 0xFF) == 0); ++i) {
            stringBuilder.append(zzzz[(byArray[i] & 0xF0) >>> 4]);
            stringBuilder.append(zzzz[byArray[i] & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String bytesToStringLowercase(byte[] byArray) {
        char[] cArray = new char[byArray.length << 1];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            cArray[n++] = zzaaa[n2 >>> 4];
            cArray[n++] = zzaaa[n2 & 0xF];
        }
        return new String(cArray);
    }

    public static String bytesToColonDelimitedStringUppercase(byte[] byArray) {
        int n;
        if (byArray.length == 0) {
            return new String();
        }
        char[] cArray = new char[byArray.length * 3 - 1];
        int n2 = 0;
        for (n = 0; n < byArray.length - 1; ++n) {
            int n3 = byArray[n] & 0xFF;
            cArray[n2++] = zzzz[n3 >>> 4];
            cArray[n2++] = zzzz[n3 & 0xF];
            cArray[n2++] = 58;
        }
        n = byArray[byArray.length - 1] & 0xFF;
        cArray[n2++] = zzzz[n >>> 4];
        cArray[n2] = zzzz[n & 0xF];
        return new String(cArray);
    }

    public static String bytesToColonDelimitedStringLowercase(byte[] byArray) {
        int n;
        if (byArray.length == 0) {
            return new String();
        }
        char[] cArray = new char[byArray.length * 3 - 1];
        int n2 = 0;
        for (n = 0; n < byArray.length - 1; ++n) {
            int n3 = byArray[n] & 0xFF;
            cArray[n2++] = zzaaa[n3 >>> 4];
            cArray[n2++] = zzaaa[n3 & 0xF];
            cArray[n2++] = 58;
        }
        n = byArray[byArray.length - 1] & 0xFF;
        cArray[n2++] = zzaaa[n >>> 4];
        cArray[n2] = zzaaa[n & 0xF];
        return new String(cArray);
    }

    public static byte[] colonDelimitedStringToBytes(String string2) {
        return Hex.stringToBytes(string2.replace(":", ""));
    }

    public static byte[] stringToBytes(String string2) throws IllegalArgumentException {
        int n = string2.length();
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Hex string has odd number of characters");
        }
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)Integer.parseInt(string2.substring(i, i + 2), 16);
        }
        return byArray;
    }
}

