/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import com.google.android.gms.common.util.VisibleForTesting;

@VisibleForTesting
public class NumberUtils {
    public static long parseHexLong(String string2) {
        if (string2.length() > 16) {
            throw new NumberFormatException(new StringBuilder(37 + String.valueOf(string2).length()).append("Invalid input: ").append(string2).append(" exceeds 16 characters").toString());
        }
        if (string2.length() == 16) {
            long l = Long.parseLong(string2.substring(8), 16);
            long l2 = Long.parseLong(string2.substring(0, 8), 16);
            return l | l2 << 32;
        }
        return Long.parseLong(string2, 16);
    }

    public static boolean isNumeric(String string2) {
        try {
            Long.parseLong(string2);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static int compare(long l, long l2) {
        if (l < l2) {
            return -1;
        }
        if (l == l2) {
            return 0;
        }
        return 1;
    }

    public static int compare(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n == n2) {
            return 0;
        }
        return 1;
    }

    private NumberUtils() {
    }
}

