/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.BinderThread;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.IGmsCallbacks;
import com.google.android.gms.common.internal.IGmsServiceBroker;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public abstract class BaseGmsClient<T extends IInterface> {
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTED = 1;
    @KeepForSdk
    public static final int CONNECT_STATE_CONNECTED = 4;
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTING = 5;
    private static final Feature[] zzbs = new Feature[0];
    @KeepForSdk
    public static final String KEY_PENDING_INTENT = "pendingIntent";
    private int zzbt;
    private long zzbu;
    private long zzbv;
    private int zzbw;
    private long zzbx;
    @VisibleForTesting
    private zzh zzby;
    @KeepForSdk
    public static final String DEFAULT_ACCOUNT = "<<default account>>";
    private final Context mContext;
    private final Looper zzbz;
    private final GmsClientSupervisor zzca;
    private final GoogleApiAvailabilityLight zzcb;
    final Handler mHandler;
    private final Object mLock = new Object();
    private final Object zzcc = new Object();
    @GuardedBy(value="mServiceBrokerLock")
    private IGmsServiceBroker zzcd;
    @VisibleForTesting
    protected ConnectionProgressReportCallbacks zzce;
    @GuardedBy(value="mLock")
    private T zzcf;
    private final ArrayList<zzc<?>> zzcg = new ArrayList();
    @GuardedBy(value="mLock")
    private zze zzch;
    @GuardedBy(value="mLock")
    private int zzci = 1;
    private final BaseConnectionCallbacks zzcj;
    private final BaseOnConnectionFailedListener zzck;
    private final int zzcl;
    private final String zzcm;
    private ConnectionResult zzcn = null;
    private boolean zzco = false;
    private volatile com.google.android.gms.common.internal.zzb zzcp = null;
    @VisibleForTesting
    protected AtomicInteger zzcq = new AtomicInteger(0);
    @KeepForSdk
    public static final String[] GOOGLE_PLUS_REQUIRED_FEATURES = new String[]{"service_esmobile", "service_googleme"};

    @KeepForSdk
    protected BaseGmsClient(Context context, Looper looper, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener, String string2) {
        this(context, looper, GmsClientSupervisor.getInstance(context), GoogleApiAvailabilityLight.getInstance(), n, Preconditions.checkNotNull(baseConnectionCallbacks), Preconditions.checkNotNull(baseOnConnectionFailedListener), string2);
    }

    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(Context context, Looper looper, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener, String string2) {
        this.mContext = Preconditions.checkNotNull(context, "Context must not be null");
        this.zzbz = Preconditions.checkNotNull(looper, "Looper must not be null");
        this.zzca = Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzcb = Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.mHandler = new zzb(looper);
        this.zzcl = n;
        this.zzcj = baseConnectionCallbacks;
        this.zzck = baseOnConnectionFailedListener;
        this.zzcm = string2;
    }

    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(Context context, Handler handler, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener) {
        this.mContext = Preconditions.checkNotNull(context, "Context must not be null");
        this.mHandler = Preconditions.checkNotNull(handler, "Handler must not be null");
        this.zzbz = handler.getLooper();
        this.zzca = Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzcb = Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.zzcl = n;
        this.zzcj = baseConnectionCallbacks;
        this.zzck = baseOnConnectionFailedListener;
        this.zzcm = null;
    }

    @NonNull
    @KeepForSdk
    protected abstract String getStartServiceAction();

    @KeepForSdk
    protected String getStartServicePackage() {
        return "com.google.android.gms";
    }

    @NonNull
    @KeepForSdk
    protected abstract String getServiceDescriptor();

    @Nullable
    private final String zzj() {
        if (this.zzcm == null) {
            return this.mContext.getClass().getName();
        }
        return this.zzcm;
    }

    @Nullable
    @KeepForSdk
    protected String getLocalStartServiceAction() {
        return null;
    }

    private final void zza(com.google.android.gms.common.internal.zzb zzb2) {
        this.zzcp = zzb2;
    }

    @Nullable
    @KeepForSdk
    public final Feature[] getAvailableFeatures() {
        com.google.android.gms.common.internal.zzb zzb2 = this.zzcp;
        if (zzb2 == null) {
            return null;
        }
        return zzb2.zzda;
    }

    @Nullable
    @KeepForSdk
    protected abstract T createServiceInterface(IBinder var1);

    @CallSuper
    @KeepForSdk
    protected void onConnectedLocked(@NonNull T t) {
        this.zzbv = System.currentTimeMillis();
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectionSuspended(int n) {
        this.zzbt = n;
        this.zzbu = System.currentTimeMillis();
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzbw = connectionResult.getErrorCode();
        this.zzbx = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, T t) {
        Preconditions.checkArgument(n == 4 == (t != null));
        Object object = this.mLock;
        synchronized (object) {
            this.zzci = n;
            this.zzcf = t;
            this.onSetConnectState(n, t);
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    BaseGmsClient baseGmsClient = this;
                    if (baseGmsClient.zzch != null && baseGmsClient.zzby != null) {
                        String string3 = baseGmsClient.zzby.zzt();
                        string2 = baseGmsClient.zzby.getPackageName();
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        baseGmsClient.zzca.zza(baseGmsClient.zzby.zzt(), baseGmsClient.zzby.getPackageName(), baseGmsClient.zzby.zzq(), baseGmsClient.zzch, baseGmsClient.zzj());
                        baseGmsClient.zzcq.incrementAndGet();
                    }
                    baseGmsClient.zzch = baseGmsClient.new zze(baseGmsClient.zzcq.get());
                    BaseGmsClient baseGmsClient2 = baseGmsClient;
                    baseGmsClient.zzby = baseGmsClient2.zzci == 3 && baseGmsClient2.getLocalStartServiceAction() != null ? new zzh(baseGmsClient2.getContext().getPackageName(), baseGmsClient2.getLocalStartServiceAction(), true, 129) : new zzh(baseGmsClient2.getStartServicePackage(), baseGmsClient2.getStartServiceAction(), false, 129);
                    String string4 = baseGmsClient.zzj();
                    zze zze2 = baseGmsClient.zzch;
                    int n2 = baseGmsClient.zzby.zzq();
                    String string5 = baseGmsClient.zzby.getPackageName();
                    String string6 = baseGmsClient.zzby.zzt();
                    if (baseGmsClient.zzca.zza(new GmsClientSupervisor.zza(string6, string5, n2), zze2, string4)) break;
                    string2 = baseGmsClient.zzby.zzt();
                    String string7 = baseGmsClient.zzby.getPackageName();
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string7).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string7).toString());
                    baseGmsClient.zza(16, null, baseGmsClient.zzcq.get());
                    break;
                }
                case 4: {
                    this.onConnectedLocked(t);
                    break;
                }
                case 1: {
                    BaseGmsClient baseGmsClient = this;
                    if (baseGmsClient.zzch == null) break;
                    baseGmsClient.zzca.zza(baseGmsClient.getStartServiceAction(), baseGmsClient.getStartServicePackage(), 129, baseGmsClient.zzch, baseGmsClient.zzj());
                    baseGmsClient.zzch = null;
                }
            }
            return;
        }
    }

    @KeepForSdk
    void onSetConnectState(int n, T t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzci != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    @KeepForSdk
    public void checkAvailabilityAndConnect() {
        int n = this.zzcb.isGooglePlayServicesAvailable(this.mContext, this.getMinApkVersion());
        if (n != 0) {
            this.zza(1, null);
            this.triggerNotAvailable(new LegacyClientCallbackAdapter(), n, null);
            return;
        }
        this.connect(new LegacyClientCallbackAdapter());
    }

    @KeepForSdk
    public void connect(@NonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        this.zzce = Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzci == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public boolean isConnecting() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzci == 2 || this.zzci == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzk() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzci == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public void disconnect() {
        this.zzcq.incrementAndGet();
        Object object = this.zzcg;
        synchronized (object) {
            int n = this.zzcg.size();
            for (int i = 0; i < n; ++i) {
                this.zzcg.get(i).removeListener();
            }
            this.zzcg.clear();
        }
        object = this.zzcc;
        synchronized (object) {
            this.zzcd = null;
        }
        this.zza(1, null);
    }

    @KeepForSdk
    public void triggerConnectionSuspended(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, this.zzcq.get(), n));
    }

    private final void zzb(int n) {
        int n2;
        if (this.zzk()) {
            n2 = 5;
            this.zzco = true;
        } else {
            n2 = 4;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(n2, this.zzcq.get(), 16));
    }

    @VisibleForTesting
    @KeepForSdk
    protected void triggerNotAvailable(@NonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks, int n, @Nullable PendingIntent pendingIntent) {
        this.zzce = Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzcq.get(), n, (Object)pendingIntent));
    }

    @KeepForSdk
    public final Context getContext() {
        return this.mContext;
    }

    @KeepForSdk
    public final Looper getLooper() {
        return this.zzbz;
    }

    @KeepForSdk
    public Account getAccount() {
        return null;
    }

    @KeepForSdk
    public Feature[] getApiFeatures() {
        return zzbs;
    }

    @KeepForSdk
    protected Bundle getGetServiceRequestExtraArgs() {
        return new Bundle();
    }

    @KeepForSdk
    protected void onPostInitHandler(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzf(n, iBinder, bundle)));
    }

    protected final void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n2, -1, (Object)new zzg(n, null)));
    }

    @KeepForSdk
    protected final void checkConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @KeepForSdk
    public Bundle getConnectionHint() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final T getService() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzci == 5) {
                throw new DeadObjectException();
            }
            this.checkConnected();
            Preconditions.checkState(this.zzcf != null, "Client is connected but service is null");
            return this.zzcf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @KeepForSdk
    public void getRemoteService(IAccountAccessor iAccountAccessor, Set<Scope> set) {
        Bundle bundle = this.getGetServiceRequestExtraArgs();
        Object object = this.mContext.getPackageName();
        Object object2 = new GetServiceRequest(this.zzcl);
        new GetServiceRequest(this.zzcl).zzdh = object;
        object = bundle;
        v0.zzdk = object;
        GetServiceRequest getServiceRequest = object2;
        if (set != null) {
            object = set;
            getServiceRequest.zzdj = object.toArray(new Scope[object.size()]);
        }
        if (this.requiresSignIn()) {
            object2 = this;
            object = ((BaseGmsClient)object2).getAccount() != null ? ((BaseGmsClient)object2).getAccount() : new Account(DEFAULT_ACCOUNT, "com.google");
            object2 = getServiceRequest;
            getServiceRequest.zzdl = object;
            object = iAccountAccessor;
            if (object != null) {
                ((GetServiceRequest)object2).zzdi = object.asBinder();
            }
        } else if (this.requiresAccount()) {
            object = this.getAccount();
            getServiceRequest.zzdl = object;
        }
        object = zzbs;
        getServiceRequest.zzdm = zzbs;
        object = this.getApiFeatures();
        getServiceRequest.zzdn = object;
        try {
            Object object3 = this.zzcc;
            synchronized (object3) {
                if (this.zzcd != null) {
                    this.zzcd.getService(new zzd(this, this.zzcq.get()), getServiceRequest);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.triggerConnectionSuspended(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.onPostInitHandler(8, null, null, this.zzcq.get());
            return;
        }
    }

    @KeepForSdk
    public boolean requiresSignIn() {
        return false;
    }

    @KeepForSdk
    public void onUserSignOut(@NonNull SignOutCallbacks signOutCallbacks) {
        signOutCallbacks.onSignOutComplete();
    }

    @KeepForSdk
    public boolean requiresAccount() {
        return false;
    }

    @KeepForSdk
    public boolean requiresGooglePlayServices() {
        return true;
    }

    @KeepForSdk
    public boolean providesSignIn() {
        return false;
    }

    @KeepForSdk
    public Intent getSignInIntent() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    @KeepForSdk
    protected Set<Scope> getScopes() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        IGmsServiceBroker iGmsServiceBroker;
        T t;
        int n;
        Object object = this.mLock;
        synchronized (object) {
            n = this.zzci;
            t = this.zzcf;
        }
        object = this.zzcc;
        synchronized (object) {
            iGmsServiceBroker = this.zzcd;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.getServiceDescriptor()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (iGmsServiceBroker == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(iGmsServiceBroker.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzbv > 0L) {
            l = this.zzbv;
            string3 = ((DateFormat)object).format(new Date(this.zzbv));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzbu > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzbt) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzbt));
                }
            }
            l = this.zzbu;
            string3 = ((DateFormat)object).format(new Date(this.zzbu));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzbx > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzbw));
            l = this.zzbx;
            string3 = ((DateFormat)object).format(new Date(this.zzbx));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @KeepForSdk
    public IBinder getServiceBrokerBinder() {
        Object object = this.zzcc;
        synchronized (object) {
            if (this.zzcd == null) {
                return null;
            }
            return this.zzcd.asBinder();
        }
    }

    private final boolean zzl() {
        if (this.zzco) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getServiceDescriptor())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getLocalStartServiceAction())) {
            return false;
        }
        try {
            Class.forName(this.getServiceDescriptor());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @KeepForSdk
    public String getEndpointPackageName() {
        if (this.isConnected() && this.zzby != null) {
            return this.zzby.getPackageName();
        }
        throw new RuntimeException("Failed to connect when checking package");
    }

    @KeepForSdk
    public int getMinApkVersion() {
        return GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    @VisibleForTesting
    public static final class zzd
    extends IGmsCallbacks.zza {
        private BaseGmsClient zzcv;
        private final int zzcw;

        public zzd(@NonNull BaseGmsClient baseGmsClient, int n) {
            this.zzcv = baseGmsClient;
            this.zzcw = n;
        }

        @Override
        @BinderThread
        public final void zza(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public final void onPostInitComplete(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            Preconditions.checkNotNull(this.zzcv, "onPostInitComplete can be called only once per call to getRemoteService");
            this.zzcv.onPostInitHandler(n, iBinder, bundle, this.zzcw);
            this.zzcv = null;
        }

        @Override
        @BinderThread
        public final void zza(int n, @NonNull IBinder iBinder, @NonNull com.google.android.gms.common.internal.zzb zzb2) {
            Preconditions.checkNotNull(this.zzcv, "onPostInitCompleteWithConnectionInfo can be called only once per call togetRemoteService");
            Preconditions.checkNotNull(zzb2);
            this.zzcv.zza(zzb2);
            this.onPostInitComplete(n, iBinder, zzb2.zzcz);
        }
    }

    private abstract class zza
    extends zzc<Boolean> {
        private final int statusCode;
        private final Bundle zzcr;

        @BinderThread
        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzcr = bundle;
        }

        protected abstract boolean zzm();

        @Override
        protected abstract void zza(ConnectionResult var1);

        @Override
        protected final void zzn() {
        }

        @Override
        protected final /* synthetic */ void zza(Object object) {
            Boolean bl = (Boolean)object;
            zza zza2 = this;
            if (bl == null) {
                zza2.BaseGmsClient.this.zza(1, null);
                return;
            }
            switch (zza2.statusCode) {
                case 0: {
                    if (zza2.zzm()) break;
                    zza2.BaseGmsClient.this.zza(1, null);
                    zza2.zza(new ConnectionResult(8, null));
                    return;
                }
                case 10: {
                    zza2.BaseGmsClient.this.zza(1, null);
                    throw new IllegalStateException(String.format("A fatal developer error has occurred. Class name: %s. Start service action: %s. Service Descriptor: %s. ", zza2.getClass().getSimpleName(), zza2.BaseGmsClient.this.getStartServiceAction(), zza2.BaseGmsClient.this.getServiceDescriptor()));
                }
                default: {
                    zza2.BaseGmsClient.this.zza(1, null);
                    PendingIntent pendingIntent = null;
                    if (zza2.zzcr != null) {
                        pendingIntent = (PendingIntent)zza2.zzcr.getParcelable(BaseGmsClient.KEY_PENDING_INTENT);
                    }
                    zza2.zza(new ConnectionResult(zza2.statusCode, pendingIntent));
                }
            }
        }
    }

    protected final class zzf
    extends zza {
        private final IBinder zzcx;

        @BinderThread
        public zzf(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzcx = iBinder;
        }

        @Override
        protected final void zza(ConnectionResult connectionResult) {
            if (BaseGmsClient.this.zzck != null) {
                BaseGmsClient.this.zzck.onConnectionFailed(connectionResult);
            }
            BaseGmsClient.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected final boolean zzm() {
            String string2;
            try {
                string2 = this.zzcx.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!BaseGmsClient.this.getServiceDescriptor().equals(string2)) {
                String string3 = BaseGmsClient.this.getServiceDescriptor();
                Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("service descriptor mismatch: ").append(string3).append(" vs. ").append(string2).toString());
                return false;
            }
            Object t = BaseGmsClient.this.createServiceInterface(this.zzcx);
            if (t != null && (BaseGmsClient.this.zza(2, 4, t) || BaseGmsClient.this.zza(3, 4, t))) {
                BaseGmsClient.this.zzcn = null;
                Bundle bundle = BaseGmsClient.this.getConnectionHint();
                if (BaseGmsClient.this.zzcj != null) {
                    BaseGmsClient.this.zzcj.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzg
    extends zza {
        @BinderThread
        public zzg(@Nullable int n, Bundle bundle) {
            super(n, null);
        }

        @Override
        protected final void zza(ConnectionResult connectionResult) {
            BaseGmsClient.this.zzce.onReportServiceBinding(connectionResult);
            BaseGmsClient.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected final boolean zzm() {
            BaseGmsClient.this.zzce.onReportServiceBinding(ConnectionResult.RESULT_SUCCESS);
            return true;
        }
    }

    protected class LegacyClientCallbackAdapter
    implements ConnectionProgressReportCallbacks {
        @KeepForSdk
        public LegacyClientCallbackAdapter() {
        }

        @Override
        public void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                BaseGmsClient.this.getRemoteService(null, BaseGmsClient.this.getScopes());
                return;
            }
            if (BaseGmsClient.this.zzck != null) {
                BaseGmsClient.this.zzck.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class zzc<TListener> {
        private TListener zzct;
        private boolean zzcu;

        public zzc(TListener TListener) {
            this.zzct = TListener;
            this.zzcu = false;
        }

        protected abstract void zza(TListener var1);

        protected abstract void zzn();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zzo() {
            TListener TListener;
            zzc zzc2 = this;
            synchronized (zzc2) {
                TListener = this.zzct;
                if (this.zzcu) {
                    String string2 = String.valueOf(this);
                    Log.w((String)"GmsClient", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Callback proxy ").append(string2).append(" being reused. This is not safe.").toString());
                }
            }
            if (TListener != null) {
                try {
                    this.zza(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzn();
                    throw runtimeException;
                }
            } else {
                this.zzn();
            }
            zzc2 = this;
            synchronized (zzc2) {
                this.zzcu = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void unregister() {
            this.removeListener();
            ArrayList arrayList = BaseGmsClient.this.zzcg;
            synchronized (arrayList) {
                BaseGmsClient.this.zzcg.remove(this);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeListener() {
            zzc zzc2 = this;
            synchronized (zzc2) {
                this.zzct = null;
                return;
            }
        }
    }

    final class zzb
    extends com.google.android.gms.internal.common.zze {
        public zzb(Looper looper) {
            super(looper);
        }

        public final void handleMessage(Message message) {
            if (BaseGmsClient.this.zzcq.get() != message.arg1) {
                if (zzb.zzb(message)) {
                    zzb.zza(message);
                }
                return;
            }
            if (!(message.what != 1 && message.what != 7 && message.what != 4 && message.what != 5 || BaseGmsClient.this.isConnecting())) {
                zzb.zza(message);
                return;
            }
            if (message.what == 4) {
                BaseGmsClient.this.zzcn = new ConnectionResult(message.arg2);
                if (BaseGmsClient.this.zzl() && !BaseGmsClient.this.zzco) {
                    BaseGmsClient.this.zza(3, null);
                    return;
                }
                ConnectionResult connectionResult = BaseGmsClient.this.zzcn != null ? BaseGmsClient.this.zzcn : new ConnectionResult(8);
                BaseGmsClient.this.zzce.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 5) {
                ConnectionResult connectionResult = BaseGmsClient.this.zzcn != null ? BaseGmsClient.this.zzcn : new ConnectionResult(8);
                BaseGmsClient.this.zzce.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 3) {
                PendingIntent pendingIntent = message.obj instanceof PendingIntent ? (PendingIntent)message.obj : null;
                ConnectionResult connectionResult = new ConnectionResult(message.arg2, pendingIntent);
                BaseGmsClient.this.zzce.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 6) {
                BaseGmsClient.this.zza(5, null);
                if (BaseGmsClient.this.zzcj != null) {
                    BaseGmsClient.this.zzcj.onConnectionSuspended(message.arg2);
                }
                BaseGmsClient.this.onConnectionSuspended(message.arg2);
                BaseGmsClient.this.zza(5, 1, null);
                return;
            }
            if (message.what == 2 && !BaseGmsClient.this.isConnected()) {
                zzb.zza(message);
                return;
            }
            if (zzb.zzb(message)) {
                ((zzc)message.obj).zzo();
                return;
            }
            int n = message.what;
            Log.wtf((String)"GmsClient", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        private static void zza(Message message) {
            zzc zzc2 = (zzc)message.obj;
            zzc2.zzn();
            zzc2.unregister();
        }

        private static boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 7;
        }
    }

    @KeepForSdk
    public static interface SignOutCallbacks {
        @KeepForSdk
        public void onSignOutComplete();
    }

    @KeepForSdk
    public static interface ConnectionProgressReportCallbacks {
        @KeepForSdk
        public void onReportServiceBinding(@NonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface BaseOnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface BaseConnectionCallbacks {
        @KeepForSdk
        public void onConnected(@Nullable Bundle var1);

        @KeepForSdk
        public void onConnectionSuspended(int var1);
    }

    @VisibleForTesting
    public final class zze
    implements ServiceConnection {
        private final int zzcw;

        public zze(int n) {
            this.zzcw = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (iBinder == null) {
                BaseGmsClient.this.zzb(16);
                return;
            }
            Object object = BaseGmsClient.this.zzcc;
            synchronized (object) {
                IInterface iInterface;
                IBinder iBinder2 = iBinder;
                BaseGmsClient.this.zzcd = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.common.internal.IGmsServiceBroker")) != null && iInterface instanceof IGmsServiceBroker ? (IGmsServiceBroker)iInterface : new IGmsServiceBroker.Stub.zza(iBinder2));
            }
            BaseGmsClient.this.zza(0, null, this.zzcw);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceDisconnected(ComponentName componentName) {
            Object object = BaseGmsClient.this.zzcc;
            synchronized (object) {
                BaseGmsClient.this.zzcd = null;
            }
            BaseGmsClient.this.mHandler.sendMessage(BaseGmsClient.this.mHandler.obtainMessage(6, this.zzcw, 1));
        }
    }
}

