/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zze;

@KeepForSdk
public abstract class GmsClientSupervisor {
    private static final Object zzdp = new Object();
    private static GmsClientSupervisor zzdq;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static GmsClientSupervisor getInstance(Context context) {
        Object object = zzdp;
        synchronized (object) {
            if (zzdq == null) {
                zzdq = new zze(context.getApplicationContext());
            }
        }
        return zzdq;
    }

    @KeepForSdk
    public boolean bindService(String string2, ServiceConnection serviceConnection, String string3) {
        return this.zza(new zza(string2, 129), serviceConnection, string3);
    }

    @KeepForSdk
    public boolean bindService(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName, 129), serviceConnection, string2);
    }

    @KeepForSdk
    public void unbindService(String string2, ServiceConnection serviceConnection, String string3) {
        this.zzb(new zza(string2, 129), serviceConnection, string3);
    }

    public final void zza(String string2, String string3, int n, ServiceConnection serviceConnection, String string4) {
        this.zzb(new zza(string2, string3, n), serviceConnection, string4);
    }

    @KeepForSdk
    public void unbindService(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName, 129), serviceConnection, string2);
    }

    protected abstract boolean zza(zza var1, ServiceConnection var2, String var3);

    protected abstract void zzb(zza var1, ServiceConnection var2, String var3);

    protected static final class zza {
        private final String zzdr;
        private final String zzds;
        private final ComponentName mComponentName;
        private final int zzdt;

        public zza(String string2, int n) {
            this.zzdr = Preconditions.checkNotEmpty(string2);
            this.zzds = "com.google.android.gms";
            this.mComponentName = null;
            this.zzdt = 129;
        }

        public zza(String string2, String string3, int n) {
            this.zzdr = Preconditions.checkNotEmpty(string2);
            this.zzds = Preconditions.checkNotEmpty(string3);
            this.mComponentName = null;
            this.zzdt = n;
        }

        public zza(ComponentName componentName, int n) {
            this.zzdr = null;
            this.zzds = null;
            this.mComponentName = Preconditions.checkNotNull(componentName);
            this.zzdt = 129;
        }

        public final String toString() {
            if (this.zzdr == null) {
                return this.mComponentName.flattenToString();
            }
            return this.zzdr;
        }

        public final String getPackage() {
            return this.zzds;
        }

        public final ComponentName getComponentName() {
            return this.mComponentName;
        }

        public final int zzq() {
            return this.zzdt;
        }

        public final Intent zzb(Context context) {
            Intent intent = this.zzdr != null ? new Intent(this.zzdr).setPackage(this.zzds) : new Intent().setComponent(this.mComponentName);
            return intent;
        }

        public final int hashCode() {
            return Objects.hashCode(this.zzdr, this.zzds, this.mComponentName, this.zzdt);
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return Objects.equal(this.zzdr, zza2.zzdr) && Objects.equal(this.zzds, zza2.zzds) && Objects.equal(this.mComponentName, zza2.mComponentName) && this.zzdt == zza2.zzdt;
        }
    }
}

