/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal.safeparcel;

import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class SafeParcelReader {
    private SafeParcelReader() {
    }

    public static int readHeader(Parcel parcel) {
        return parcel.readInt();
    }

    public static int getFieldId(int n) {
        return n & 0xFFFF;
    }

    public static int readSize(Parcel parcel, int n) {
        if ((n & 0xFFFF0000) != -65536) {
            return n >> 16 & 0xFFFF;
        }
        return parcel.readInt();
    }

    public static void skipUnknownField(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        parcel.setDataPosition(parcel.dataPosition() + n2);
    }

    private static void zza(Parcel parcel, int n, int n2) {
        int n3 = SafeParcelReader.readSize(parcel, n);
        if (n3 != n2) {
            String string2 = Integer.toHexString(n3);
            throw new ParseException(new StringBuilder(46 + String.valueOf(string2).length()).append("Expected size ").append(n2).append(" got ").append(n3).append(" (0x").append(string2).append(")").toString(), parcel);
        }
    }

    private static void zza(Parcel parcel, int n, int n2, int n3) {
        if (n2 != n3) {
            String string2 = Integer.toHexString(n2);
            throw new ParseException(new StringBuilder(46 + String.valueOf(string2).length()).append("Expected size ").append(n3).append(" got ").append(n2).append(" (0x").append(string2).append(")").toString(), parcel);
        }
    }

    public static int validateObjectHeader(Parcel parcel) {
        int n = SafeParcelReader.readHeader(parcel);
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (SafeParcelReader.getFieldId(n) != 20293) {
            String string2 = String.valueOf(Integer.toHexString(n));
            throw new ParseException(string2.length() != 0 ? "Expected object header. Got 0x".concat(string2) : new String("Expected object header. Got 0x"), parcel);
        }
        int n4 = n3 + n2;
        if (n4 < n3 || n4 > parcel.dataSize()) {
            throw new ParseException(new StringBuilder(54).append("Size read is invalid start=").append(n3).append(" end=").append(n4).toString(), parcel);
        }
        return n4;
    }

    public static boolean readBoolean(Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return parcel.readInt() != 0;
    }

    public static Boolean readBooleanObject(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zza(parcel, n, n2, 4);
        return parcel.readInt() != 0;
    }

    public static byte readByte(Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return (byte)parcel.readInt();
    }

    public static char readChar(Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return (char)parcel.readInt();
    }

    public static short readShort(Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return (short)parcel.readInt();
    }

    public static int readInt(Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return parcel.readInt();
    }

    public static Integer readIntegerObject(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zza(parcel, n, n2, 4);
        return parcel.readInt();
    }

    public static long readLong(Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 8);
        return parcel.readLong();
    }

    public static Long readLongObject(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zza(parcel, n, n2, 8);
        return parcel.readLong();
    }

    public static BigInteger createBigInteger(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = parcel.createByteArray();
        parcel.setDataPosition(n3 + n2);
        return new BigInteger(byArray);
    }

    public static float readFloat(Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return parcel.readFloat();
    }

    public static Float readFloatObject(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zza(parcel, n, n2, 4);
        return Float.valueOf(parcel.readFloat());
    }

    public static double readDouble(Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 8);
        return parcel.readDouble();
    }

    public static Double readDoubleObject(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zza(parcel, n, n2, 8);
        return parcel.readDouble();
    }

    public static BigDecimal createBigDecimal(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = parcel.createByteArray();
        int n4 = parcel.readInt();
        parcel.setDataPosition(n3 + n2);
        return new BigDecimal(new BigInteger(byArray), n4);
    }

    public static String createString(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        String string2 = parcel.readString();
        parcel.setDataPosition(n3 + n2);
        return string2;
    }

    public static IBinder readIBinder(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        IBinder iBinder = parcel.readStrongBinder();
        parcel.setDataPosition(n3 + n2);
        return iBinder;
    }

    public static <T extends Parcelable> T createParcelable(Parcel parcel, int n, Parcelable.Creator<T> creator) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
        parcel.setDataPosition(n3 + n2);
        return (T)parcelable;
    }

    public static Bundle createBundle(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        Bundle bundle = parcel.readBundle();
        parcel.setDataPosition(n3 + n2);
        return bundle;
    }

    public static byte[] createByteArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = parcel.createByteArray();
        parcel.setDataPosition(n3 + n2);
        return byArray;
    }

    public static byte[][] createByteArrayArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        byte[][] byArrayArray = new byte[n4][];
        for (int i = 0; i < n4; ++i) {
            byArrayArray[i] = parcel.createByteArray();
        }
        parcel.setDataPosition(n3 + n2);
        return byArrayArray;
    }

    public static boolean[] createBooleanArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        boolean[] blArray = parcel.createBooleanArray();
        parcel.setDataPosition(n3 + n2);
        return blArray;
    }

    public static char[] createCharArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        char[] cArray = parcel.createCharArray();
        parcel.setDataPosition(n3 + n2);
        return cArray;
    }

    public static int[] createIntArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int[] nArray = parcel.createIntArray();
        parcel.setDataPosition(n3 + n2);
        return nArray;
    }

    public static long[] createLongArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        long[] lArray = parcel.createLongArray();
        parcel.setDataPosition(n3 + n2);
        return lArray;
    }

    public static BigInteger[] createBigIntegerArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        BigInteger[] bigIntegerArray = new BigInteger[n4];
        for (int i = 0; i < n4; ++i) {
            bigIntegerArray[i] = new BigInteger(parcel.createByteArray());
        }
        parcel.setDataPosition(n3 + n2);
        return bigIntegerArray;
    }

    public static float[] createFloatArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        float[] fArray = parcel.createFloatArray();
        parcel.setDataPosition(n3 + n2);
        return fArray;
    }

    public static double[] createDoubleArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        double[] dArray = parcel.createDoubleArray();
        parcel.setDataPosition(n3 + n2);
        return dArray;
    }

    public static BigDecimal[] createBigDecimalArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        BigDecimal[] bigDecimalArray = new BigDecimal[n4];
        for (int i = 0; i < n4; ++i) {
            byte[] byArray = parcel.createByteArray();
            int n5 = parcel.readInt();
            bigDecimalArray[i] = new BigDecimal(new BigInteger(byArray), n5);
        }
        parcel.setDataPosition(n3 + n2);
        return bigDecimalArray;
    }

    public static String[] createStringArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = parcel.createStringArray();
        parcel.setDataPosition(n3 + n2);
        return stringArray;
    }

    public static IBinder[] createIBinderArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        IBinder[] iBinderArray = parcel.createBinderArray();
        parcel.setDataPosition(n3 + n2);
        return iBinderArray;
    }

    public static ArrayList<Boolean> createBooleanList(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            arrayList.add(parcel.readInt() != 0);
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    public static ArrayList<Integer> createIntegerList(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            arrayList.add(parcel.readInt());
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    public static SparseBooleanArray createSparseBooleanArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseBooleanArray sparseBooleanArray = parcel.readSparseBooleanArray();
        parcel.setDataPosition(n3 + n2);
        return sparseBooleanArray;
    }

    public static SparseIntArray createSparseIntArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseIntArray sparseIntArray = new SparseIntArray();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            int n6 = parcel.readInt();
            sparseIntArray.append(n5, n6);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseIntArray;
    }

    public static SparseArray<Float> createFloatSparseArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            float f = parcel.readFloat();
            sparseArray.append(n5, (Object)Float.valueOf(f));
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    public static SparseArray<Double> createDoubleSparseArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            double d = parcel.readDouble();
            sparseArray.append(n5, (Object)d);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    public static SparseLongArray createSparseLongArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseLongArray sparseLongArray = new SparseLongArray();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            long l = parcel.readLong();
            sparseLongArray.append(n5, l);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseLongArray;
    }

    public static SparseArray<String> createStringSparseArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            String string2 = parcel.readString();
            sparseArray.append(n5, (Object)string2);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    public static SparseArray<Parcel> createParcelSparseArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            int n6 = parcel.readInt();
            if (n6 != 0) {
                int n7 = parcel.dataPosition();
                Parcel parcel2 = Parcel.obtain();
                parcel2.appendFrom(parcel, n7, n6);
                sparseArray.append(n5, (Object)parcel2);
                parcel.setDataPosition(n7 + n6);
                continue;
            }
            sparseArray.append(n5, null);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    public static <T> SparseArray<T> createTypedSparseArray(Parcel parcel, int n, Parcelable.Creator<T> creator) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            Object object = parcel.readInt() != 0 ? creator.createFromParcel(parcel) : null;
            sparseArray.append(n5, object);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    public static SparseArray<IBinder> createIBinderSparseArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray(n4);
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            IBinder iBinder = parcel.readStrongBinder();
            sparseArray.append(n5, (Object)iBinder);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    public static SparseArray<byte[]> createByteArraySparseArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray(n4);
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            byte[] byArray = parcel.createByteArray();
            sparseArray.append(n5, (Object)byArray);
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    public static ArrayList<Long> createLongList(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            arrayList.add(parcel.readLong());
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    public static ArrayList<Float> createFloatList(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            arrayList.add(Float.valueOf(parcel.readFloat()));
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    public static ArrayList<Double> createDoubleList(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n4 = parcel.readInt();
        for (int i = 0; i < n4; ++i) {
            arrayList.add(parcel.readDouble());
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    public static ArrayList<String> createStringList(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList arrayList = parcel.createStringArrayList();
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    public static ArrayList<IBinder> createIBinderList(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList arrayList = parcel.createBinderArrayList();
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    public static <T> T[] createTypedArray(Parcel parcel, int n, Parcelable.Creator<T> creator) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        Object[] objectArray = parcel.createTypedArray(creator);
        parcel.setDataPosition(n3 + n2);
        return objectArray;
    }

    public static <T> ArrayList<T> createTypedList(Parcel parcel, int n, Parcelable.Creator<T> creator) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList arrayList = parcel.createTypedArrayList(creator);
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    public static Parcel createParcel(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        Parcel parcel2 = Parcel.obtain();
        parcel2.appendFrom(parcel, n3, n2);
        parcel.setDataPosition(n3 + n2);
        return parcel2;
    }

    public static Parcel[] createParcelArray(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        Parcel[] parcelArray = new Parcel[n4];
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            if (n5 != 0) {
                int n6 = parcel.dataPosition();
                Parcel parcel2 = Parcel.obtain();
                parcel2.appendFrom(parcel, n6, n5);
                parcelArray[i] = parcel2;
                parcel.setDataPosition(n6 + n5);
                continue;
            }
            parcelArray[i] = null;
        }
        parcel.setDataPosition(n3 + n2);
        return parcelArray;
    }

    public static ArrayList<Parcel> createParcelList(Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        ArrayList<Parcel> arrayList = new ArrayList<Parcel>();
        for (int i = 0; i < n4; ++i) {
            int n5 = parcel.readInt();
            if (n5 != 0) {
                int n6 = parcel.dataPosition();
                Parcel parcel2 = Parcel.obtain();
                parcel2.appendFrom(parcel, n6, n5);
                arrayList.add(parcel2);
                parcel.setDataPosition(n6 + n5);
                continue;
            }
            arrayList.add(null);
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    public static void readList(Parcel parcel, int n, List list, ClassLoader classLoader) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return;
        }
        parcel.readList(list, classLoader);
        parcel.setDataPosition(n3 + n2);
    }

    public static void ensureAtEnd(Parcel parcel, int n) {
        if (parcel.dataPosition() != n) {
            throw new ParseException(new StringBuilder(37).append("Overread allowed size end=").append(n).toString(), parcel);
        }
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String string2, Parcel parcel) {
            int n = parcel.dataPosition();
            int n2 = parcel.dataSize();
            super(new StringBuilder(41 + String.valueOf(string2).length()).append(string2).append(" Parcel: pos=").append(n).append(" size=").append(n2).toString());
        }
    }
}

