/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.common.zzi;
import java.util.HashMap;
import javax.annotation.concurrent.GuardedBy;

final class zze
extends GmsClientSupervisor
implements Handler.Callback {
    @GuardedBy(value="mConnectionStatus")
    private final HashMap<GmsClientSupervisor.zza, zzg> zzee = new HashMap();
    private final Context zzef;
    private final Handler mHandler;
    private final ConnectionTracker zzeg;
    private final long zzeh;
    private final long zzei;

    zze(Context context) {
        this.zzef = context.getApplicationContext();
        this.mHandler = new zzi(context.getMainLooper(), this);
        this.zzeg = ConnectionTracker.getInstance();
        this.zzeh = 5000L;
        this.zzei = 300000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zza(GmsClientSupervisor.zza zza2, ServiceConnection serviceConnection, String string2) {
        ServiceConnection serviceConnection2;
        Preconditions.checkNotNull(serviceConnection, "ServiceConnection must not be null");
        ServiceConnection serviceConnection3 = serviceConnection2 = serviceConnection;
        HashMap<GmsClientSupervisor.zza, zzg> hashMap = this.zzee;
        synchronized (hashMap) {
            zzg zzg2 = this.zzee.get(zza2);
            if (zzg2 == null) {
                zzg2 = new zzg(this, zza2);
                zzg2.zza(serviceConnection, serviceConnection3, string2);
                zzg2.zzf(string2);
                this.zzee.put(zza2, zzg2);
            } else {
                this.mHandler.removeMessages(0, (Object)zza2);
                if (zzg2.zza(serviceConnection)) {
                    String string3 = String.valueOf(zza2);
                    throw new IllegalStateException(new StringBuilder(81 + String.valueOf(string3).length()).append("Trying to bind a GmsServiceConnection that was already connected before.  config=").append(string3).toString());
                }
                zzg2.zza(serviceConnection, serviceConnection3, string2);
                switch (zzg2.getState()) {
                    case 1: {
                        serviceConnection3.onServiceConnected(zzg2.getComponentName(), zzg2.getBinder());
                        break;
                    }
                    case 2: {
                        zzg2.zzf(string2);
                    }
                }
            }
            return zzg2.isBound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void zzb(GmsClientSupervisor.zza zza2, ServiceConnection serviceConnection, String string2) {
        Preconditions.checkNotNull(serviceConnection, "ServiceConnection must not be null");
        HashMap<GmsClientSupervisor.zza, zzg> hashMap = this.zzee;
        synchronized (hashMap) {
            zzg zzg2 = this.zzee.get(zza2);
            if (zzg2 == null) {
                String string3 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(50 + String.valueOf(string3).length()).append("Nonexistent connection status for service config: ").append(string3).toString());
            }
            if (!zzg2.zza(serviceConnection)) {
                String string4 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(76 + String.valueOf(string4).length()).append("Trying to unbind a GmsServiceConnection  that was not bound before.  config=").append(string4).toString());
            }
            zzg2.zza(serviceConnection, string2);
            if (zzg2.zzs()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zza2);
                this.mHandler.sendMessageDelayed(message, this.zzeh);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                HashMap<GmsClientSupervisor.zza, zzg> hashMap = this.zzee;
                synchronized (hashMap) {
                    GmsClientSupervisor.zza zza2 = (GmsClientSupervisor.zza)message.obj;
                    zzg zzg2 = this.zzee.get(zza2);
                    if (zzg2 != null && zzg2.zzs()) {
                        if (zzg2.isBound()) {
                            zzg2.zzg("GmsClientSupervisor");
                        }
                        this.zzee.remove(zza2);
                    }
                }
                return true;
            }
            case 1: {
                HashMap<GmsClientSupervisor.zza, zzg> hashMap = this.zzee;
                synchronized (hashMap) {
                    GmsClientSupervisor.zza zza3 = (GmsClientSupervisor.zza)message.obj;
                    zzg zzg3 = this.zzee.get(zza3);
                    if (zzg3 != null && zzg3.getState() == 3) {
                        String string2 = String.valueOf(zza3);
                        Log.e((String)"GmsClientSupervisor", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Timeout waiting for ServiceConnection callback ").append(string2).toString(), (Throwable)new Exception());
                        string2 = zzg3.getComponentName();
                        if (string2 == null) {
                            string2 = zza3.getComponentName();
                        }
                        if (string2 == null) {
                            string2 = new ComponentName(zza3.getPackage(), "unknown");
                        }
                        zzg3.onServiceDisconnected((ComponentName)string2);
                    }
                }
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ HashMap zza(zze zze2) {
        return zze2.zzee;
    }

    static /* synthetic */ Handler zzb(zze zze2) {
        return zze2.mHandler;
    }

    static /* synthetic */ Context zzc(zze zze2) {
        return zze2.zzef;
    }

    static /* synthetic */ ConnectionTracker zzd(zze zze2) {
        return zze2.zzeg;
    }

    static /* synthetic */ long zze(zze zze2) {
        return zze2.zzei;
    }
}

