/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.Collections;
import java.util.List;

@KeepForSdk
public class ConnectionTracker {
    private static final Object zzfw = new Object();
    private static volatile ConnectionTracker zzfx;
    @VisibleForTesting
    private static boolean zzfy;
    private final List<String> zzfz = Collections.EMPTY_LIST;
    private final List<String> zzga = Collections.EMPTY_LIST;
    private final List<String> zzgb = Collections.EMPTY_LIST;
    private final List<String> zzgc = Collections.EMPTY_LIST;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static ConnectionTracker getInstance() {
        if (zzfx == null) {
            Object object = zzfw;
            synchronized (object) {
                if (zzfx == null) {
                    zzfx = new ConnectionTracker();
                }
            }
        }
        return zzfx;
    }

    private ConnectionTracker() {
    }

    public final boolean zza(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n) {
        int n2 = n;
        ServiceConnection serviceConnection2 = serviceConnection;
        Intent intent2 = intent;
        Context context2 = context;
        Intent intent3 = intent2;
        Context context3 = context2;
        ComponentName componentName = intent3.getComponent();
        if (componentName == null ? false : ClientLibraryUtils.zzc(context3, componentName.getPackageName())) {
            Log.w((String)"ConnectionTracker", (String)"Attempted to bind to a service in a STOPPED package.");
            return false;
        }
        return context2.bindService(intent2, serviceConnection2, n2);
    }

    @KeepForSdk
    public boolean bindService(Context context, Intent intent, ServiceConnection serviceConnection, int n) {
        return this.zza(context, context.getClass().getName(), intent, serviceConnection, n);
    }

    @SuppressLint(value={"UntrackedBindService"})
    @KeepForSdk
    public void unbindService(Context context, ServiceConnection serviceConnection) {
        context.unbindService(serviceConnection);
    }

    @SuppressLint(value={"UntrackedBindService"})
    @KeepForSdk
    public void unbindServiceSafe(Context context, ServiceConnection serviceConnection) {
        try {
            this.unbindService(context, serviceConnection);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w((String)"ConnectionTracker", (String)"Exception thrown while unbinding", (Throwable)illegalArgumentException);
            return;
        }
    }

    static {
        zzfy = false;
    }
}

