/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.wrappers;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Process;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.InstantApps;

@KeepForSdk
public class PackageManagerWrapper {
    private final Context zzil;

    public PackageManagerWrapper(Context context) {
        this.zzil = context;
    }

    @KeepForSdk
    public ApplicationInfo getApplicationInfo(String string2, int n) throws PackageManager.NameNotFoundException {
        return this.zzil.getPackageManager().getApplicationInfo(string2, n);
    }

    @KeepForSdk
    public PackageInfo getPackageInfo(String string2, int n) throws PackageManager.NameNotFoundException {
        return this.zzil.getPackageManager().getPackageInfo(string2, n);
    }

    public final PackageInfo zza(String string2, int n, int n2) throws PackageManager.NameNotFoundException {
        return this.zzil.getPackageManager().getPackageInfo(string2, 64);
    }

    public final String[] getPackagesForUid(int n) {
        return this.zzil.getPackageManager().getPackagesForUid(n);
    }

    @TargetApi(value=19)
    public final boolean zzb(int n, String string2) {
        if (PlatformVersion.isAtLeastKitKat()) {
            try {
                ((AppOpsManager)this.zzil.getSystemService("appops")).checkPackage(n, string2);
                return true;
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        String[] stringArray = this.zzil.getPackageManager().getPackagesForUid(n);
        if (string2 != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @KeepForSdk
    public int checkCallingOrSelfPermission(String string2) {
        return this.zzil.checkCallingOrSelfPermission(string2);
    }

    @KeepForSdk
    public int checkPermission(String string2, String string3) {
        return this.zzil.getPackageManager().checkPermission(string2, string3);
    }

    @KeepForSdk
    public CharSequence getApplicationLabel(String string2) throws PackageManager.NameNotFoundException {
        return this.zzil.getPackageManager().getApplicationLabel(this.zzil.getPackageManager().getApplicationInfo(string2, 0));
    }

    @KeepForSdk
    public boolean isCallerInstantApp() {
        String string2;
        if (Binder.getCallingUid() == Process.myUid()) {
            return InstantApps.isInstantApp(this.zzil);
        }
        if (PlatformVersion.isAtLeastO() && (string2 = this.zzil.getPackageManager().getNameForUid(Binder.getCallingUid())) != null) {
            String string3 = string2;
            return this.zzil.getPackageManager().isInstantApp(string3);
        }
        return false;
    }
}

