/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.AccountAccessor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzd;

@SafeParcelable.Reserved(value={9})
@SafeParcelable.Class(creator="GetServiceRequestCreator")
@KeepForSdk
public class GetServiceRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<GetServiceRequest> CREATOR = new zzd();
    @SafeParcelable.VersionField(id=1)
    private final int zzh;
    @SafeParcelable.Field(id=2)
    private final int zzi;
    @SafeParcelable.Field(id=3)
    private int zzj;
    @SafeParcelable.Field(id=4)
    String zza;
    @SafeParcelable.Field(id=5)
    IBinder zzb;
    @SafeParcelable.Field(id=6)
    Scope[] zzc;
    @SafeParcelable.Field(id=7)
    Bundle zzd;
    @SafeParcelable.Field(id=8)
    Account zze;
    @SafeParcelable.Field(id=10)
    Feature[] zzf;
    @SafeParcelable.Field(id=11)
    Feature[] zzg;
    @SafeParcelable.Field(id=12)
    private boolean zzk;
    @SafeParcelable.Field(id=13, defaultValue="0")
    private int zzl;

    public GetServiceRequest(int n) {
        this.zzh = 4;
        this.zzj = GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
        this.zzi = n;
        this.zzk = true;
    }

    @SafeParcelable.Constructor
    GetServiceRequest(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) int n3, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) IBinder iBinder, @SafeParcelable.Param(id=6) Scope[] scopeArray, @SafeParcelable.Param(id=7) Bundle bundle, @SafeParcelable.Param(id=8) Account account, @SafeParcelable.Param(id=10) Feature[] featureArray, @SafeParcelable.Param(id=11) Feature[] featureArray2, @SafeParcelable.Param(id=12) boolean bl, @SafeParcelable.Param(id=13) int n4) {
        this.zzh = n;
        this.zzi = n2;
        this.zzj = n3;
        this.zza = "com.google.android.gms".equals(string2) ? "com.google.android.gms" : string2;
        if (n < 2) {
            IBinder iBinder2 = iBinder;
            Account account2 = null;
            if (iBinder2 != null) {
                account2 = AccountAccessor.getAccountBinderSafe(IAccountAccessor.Stub.asInterface(iBinder2));
            }
            this.zze = account2;
        } else {
            this.zzb = iBinder;
            this.zze = account;
        }
        this.zzc = scopeArray;
        this.zzd = bundle;
        this.zzf = featureArray;
        this.zzg = featureArray2;
        this.zzk = bl;
        this.zzl = n4;
    }

    @KeepForSdk
    public Bundle getExtraArgs() {
        return this.zzd;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GetServiceRequest getServiceRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeInt(parcel2, 1, getServiceRequest.zzh);
        SafeParcelWriter.writeInt(parcel2, 2, getServiceRequest.zzi);
        SafeParcelWriter.writeInt(parcel2, 3, getServiceRequest.zzj);
        SafeParcelWriter.writeString(parcel2, 4, getServiceRequest.zza, false);
        SafeParcelWriter.writeIBinder(parcel2, 5, getServiceRequest.zzb, false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)6, (Parcelable[])getServiceRequest.zzc, (int)n, (boolean)false);
        SafeParcelWriter.writeBundle(parcel2, 7, getServiceRequest.zzd, false);
        SafeParcelWriter.writeParcelable(parcel2, 8, (Parcelable)getServiceRequest.zze, n, false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)10, (Parcelable[])getServiceRequest.zzf, (int)n, (boolean)false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)11, (Parcelable[])getServiceRequest.zzg, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean(parcel2, 12, getServiceRequest.zzk);
        SafeParcelWriter.writeInt(parcel2, 13, getServiceRequest.zzl);
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }
}

