/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.zza;

@SafeParcelable.Class(creator="ConnectionResultCreator")
public final class ConnectionResult
extends AbstractSafeParcelable {
    @KeepForSdk
    @RecentlyNonNull
    public static final int UNKNOWN = -1;
    @RecentlyNonNull
    public static final int SUCCESS = 0;
    @RecentlyNonNull
    public static final int SERVICE_MISSING = 1;
    @RecentlyNonNull
    public static final int SERVICE_VERSION_UPDATE_REQUIRED = 2;
    @RecentlyNonNull
    public static final int SERVICE_DISABLED = 3;
    @RecentlyNonNull
    public static final int SIGN_IN_REQUIRED = 4;
    @RecentlyNonNull
    public static final int INVALID_ACCOUNT = 5;
    @RecentlyNonNull
    public static final int RESOLUTION_REQUIRED = 6;
    @RecentlyNonNull
    public static final int NETWORK_ERROR = 7;
    @RecentlyNonNull
    public static final int INTERNAL_ERROR = 8;
    @RecentlyNonNull
    public static final int SERVICE_INVALID = 9;
    @RecentlyNonNull
    public static final int DEVELOPER_ERROR = 10;
    @RecentlyNonNull
    public static final int LICENSE_CHECK_FAILED = 11;
    @RecentlyNonNull
    public static final int CANCELED = 13;
    @RecentlyNonNull
    public static final int TIMEOUT = 14;
    @RecentlyNonNull
    public static final int INTERRUPTED = 15;
    @RecentlyNonNull
    public static final int API_UNAVAILABLE = 16;
    @RecentlyNonNull
    public static final int SIGN_IN_FAILED = 17;
    @RecentlyNonNull
    public static final int SERVICE_UPDATING = 18;
    @RecentlyNonNull
    public static final int SERVICE_MISSING_PERMISSION = 19;
    @RecentlyNonNull
    public static final int RESTRICTED_PROFILE = 20;
    @RecentlyNonNull
    public static final int RESOLUTION_ACTIVITY_NOT_FOUND = 22;
    @Deprecated
    @RecentlyNonNull
    public static final int DRIVE_EXTERNAL_STORAGE_REQUIRED = 1500;
    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public static final ConnectionResult RESULT_SUCCESS = new ConnectionResult(0);
    @RecentlyNonNull
    public static final Parcelable.Creator<ConnectionResult> CREATOR = new zza();
    @SafeParcelable.VersionField(id=1)
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getErrorCode")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getResolution")
    @Nullable
    private final PendingIntent zzc;
    @SafeParcelable.Field(id=4, getter="getErrorMessage")
    @Nullable
    private final String zzd;

    @SafeParcelable.Constructor
    ConnectionResult(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @Nullable @SafeParcelable.Param(id=3) PendingIntent pendingIntent, @Nullable @SafeParcelable.Param(id=4) String string) {
        this.zza = n;
        this.zzb = n2;
        this.zzc = pendingIntent;
        this.zzd = string;
    }

    public ConnectionResult(@RecentlyNonNull int n) {
        this(n, null, null);
    }

    public ConnectionResult(@RecentlyNonNull int n, @Nullable PendingIntent pendingIntent) {
        this(n, pendingIntent, null);
    }

    public ConnectionResult(@RecentlyNonNull int n, @Nullable PendingIntent pendingIntent, @Nullable String string) {
        this(1, n, pendingIntent, string);
    }

    public final void startResolutionForResult(@RecentlyNonNull Activity activity, @RecentlyNonNull int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(Preconditions.checkNotNull(this.zzc).getIntentSender(), n, null, 0, 0, 0);
    }

    @RecentlyNonNull
    public final boolean hasResolution() {
        return this.zzb != 0 && this.zzc != null;
    }

    @RecentlyNonNull
    public final boolean isSuccess() {
        return this.zzb == 0;
    }

    @RecentlyNonNull
    public final int getErrorCode() {
        return this.zzb;
    }

    @RecentlyNullable
    public final PendingIntent getResolution() {
        return this.zzc;
    }

    @RecentlyNullable
    public final String getErrorMessage() {
        return this.zzd;
    }

    @NonNull
    static String zza(int n) {
        switch (n) {
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "SERVICE_MISSING";
            }
            case 2: {
                return "SERVICE_VERSION_UPDATE_REQUIRED";
            }
            case 3: {
                return "SERVICE_DISABLED";
            }
            case 4: {
                return "SIGN_IN_REQUIRED";
            }
            case 5: {
                return "INVALID_ACCOUNT";
            }
            case 6: {
                return "RESOLUTION_REQUIRED";
            }
            case 7: {
                return "NETWORK_ERROR";
            }
            case 8: {
                return "INTERNAL_ERROR";
            }
            case 9: {
                return "SERVICE_INVALID";
            }
            case 10: {
                return "DEVELOPER_ERROR";
            }
            case 11: {
                return "LICENSE_CHECK_FAILED";
            }
            case 13: {
                return "CANCELED";
            }
            case 14: {
                return "TIMEOUT";
            }
            case 15: {
                return "INTERRUPTED";
            }
            case 16: {
                return "API_UNAVAILABLE";
            }
            case 17: {
                return "SIGN_IN_FAILED";
            }
            case 18: {
                return "SERVICE_UPDATING";
            }
            case 19: {
                return "SERVICE_MISSING_PERMISSION";
            }
            case 20: {
                return "RESTRICTED_PROFILE";
            }
            case 21: {
                return "API_VERSION_UPDATE_REQUIRED";
            }
            case 22: {
                return "RESOLUTION_ACTIVITY_NOT_FOUND";
            }
            case 1500: {
                return "DRIVE_EXTERNAL_STORAGE_REQUIRED";
            }
            case 99: {
                return "UNFINISHED";
            }
            case -1: {
                return "UNKNOWN";
            }
        }
        return new StringBuilder(31).append("UNKNOWN_ERROR_CODE(").append(n).append(")").toString();
    }

    @RecentlyNonNull
    public final boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConnectionResult)) {
            return false;
        }
        ConnectionResult connectionResult = (ConnectionResult)object;
        return this.zzb == connectionResult.zzb && Objects.equal(this.zzc, connectionResult.zzc) && Objects.equal(this.zzd, connectionResult.zzd);
    }

    @RecentlyNonNull
    public final int hashCode() {
        return Objects.hashCode(this.zzb, this.zzc, this.zzd);
    }

    @RecentlyNonNull
    public final String toString() {
        return Objects.toStringHelper(this).add("statusCode", ConnectionResult.zza(this.zzb)).add("resolution", this.zzc).add("message", this.zzd).toString();
    }

    public final void writeToParcel(@RecentlyNonNull Parcel parcel, @RecentlyNonNull int n) {
        Parcel parcel2 = parcel;
        ConnectionResult connectionResult = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeInt(parcel2, 1, connectionResult.zza);
        SafeParcelWriter.writeInt(parcel2, 2, connectionResult.getErrorCode());
        SafeParcelWriter.writeParcelable(parcel2, 3, (Parcelable)connectionResult.getResolution(), n, false);
        SafeParcelWriter.writeString(parcel2, 4, connectionResult.getErrorMessage(), false);
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }
}

