/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.util.Log;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;

public abstract class ResultCallbacks<R extends Result>
implements ResultCallback<R> {
    @Override
    @KeepForSdk
    public final void onResult(@RecentlyNonNull R r) {
        Status status = r.getStatus();
        if (status.isSuccess()) {
            this.onSuccess(r);
            return;
        }
        this.onFailure(status);
        if (r instanceof Releasable) {
            try {
                ((Releasable)r).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(r);
                Log.w((String)"ResultCallbacks", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    public abstract void onSuccess(@RecentlyNonNull R var1);

    public abstract void onFailure(@RecentlyNonNull Status var1);
}

